/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAlwaysLookAtPlayerGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAngerableMeleeAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeeQueenState;
import com.telepathicgrunt.the_bumblezone.entities.navigation.DirectPathNavigator;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ItemEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.packets.TradeHintParticleSpawnPacket;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BeeQueenEntity
extends Animal
implements NeutralMob {
    private static final TargetingConditions PLAYER_ACKNOWLEDGE_SIGHT = TargetingConditions.forNonCombat().range(10.0);
    public static final int TRADE_HINT_PARTICLE_LIFETIME = 200;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState itemThrownAnimationState = new AnimationState();
    public final AnimationState itemRejectAnimationState = new AnimationState();
    public static final EntityDataSerializer<BeeQueenState> QUEEN_POSE_SERIALIZER = EntityDataSerializer.forValueType(BeeQueenState.STREAM_CODEC);
    private static final EntityDataAccessor<Integer> THROWCOOLDOWN = SynchedEntityData.defineId(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BEESPAWNCOOLDOWN = SynchedEntityData.defineId(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.defineId(BeeQueenEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<BeeQueenState> QUEEN_POSE = SynchedEntityData.defineId(BeeQueenEntity.class, QUEEN_POSE_SERIALIZER);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)60, (int)120);
    private UUID persistentAngerTarget;
    private int underWaterTicks;
    private int poseTicks;
    private int tradeHintCooldown = 0;
    private boolean isSpecialDay = false;
    private static final WeightedTradeResult ESSENCE_DROP = new WeightedTradeResult(null, Optional.of(List.of(((Item)BzItems.ESSENCE_OF_THE_BEES.get()).getDefaultInstance())), 1, 1000, 1);
    private static final ResourceLocation BEE_ESSENCE_ADVANCEMENT_RL = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence/bee_essence_infusion");

    public BeeQueenEntity(EntityType<? extends BeeQueenEntity> type, Level world) {
        super(type, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(THROWCOOLDOWN, (Object)0);
        builder.define(REMAINING_ANGER_TIME, (Object)0);
        builder.define(BEESPAWNCOOLDOWN, (Object)0);
        builder.define(QUEEN_POSE, (Object)BeeQueenState.NONE);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (QUEEN_POSE.equals(entityDataAccessor)) {
            BeeQueenState pose = this.getQueenPose();
            this.setAnimationState(pose, BeeQueenState.ATTACKING, this.attackAnimationState);
            this.setAnimationState(pose, BeeQueenState.ITEM_REJECT, this.itemRejectAnimationState);
            this.setAnimationState(pose, BeeQueenState.ITEM_THROW, this.itemThrownAnimationState);
        }
        super.onSyncedDataUpdated(entityDataAccessor);
    }

    private void setAnimationState(BeeQueenState pose, BeeQueenState poseToCheckFor, AnimationState animationState) {
        if (pose == poseToCheckFor) {
            animationState.start(this.tickCount);
        } else {
            animationState.stop();
        }
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.MOVEMENT_SPEED, 0.1).add(Attributes.ATTACK_DAMAGE, 10.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new BeeQueenAngerableMeleeAttackGoal(this));
        this.goalSelector.addGoal(2, (Goal)new BeeQueenAlwaysLookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("throwcooldown", this.getThrowCooldown());
        tag.putInt("beespawncooldown", this.getBeeSpawnCooldown());
        this.addPersistentAngerSaveData(tag);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setThrowCooldown(tag.getInt("throwcooldown"));
        this.setBeeSpawnCooldown(tag.getInt("beespawncooldown"));
        this.readPersistentAngerSaveData(this.level(), tag);
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    public void setIsSpecialDay(boolean isSpecialDay) {
        this.isSpecialDay = isSpecialDay;
    }

    public boolean getIsSpecialDay() {
        return this.isSpecialDay;
    }

    public void setQueenPose(BeeQueenState beeQueenState) {
        this.entityData.set(QUEEN_POSE, (Object)beeQueenState);
    }

    public BeeQueenState getQueenPose() {
        return (BeeQueenState)((Object)this.entityData.get(QUEEN_POSE));
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new DirectPathNavigator((Mob)this, pLevel);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return true;
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader worldReader) {
        AABB box = this.getBoundingBox();
        return !worldReader.containsAnyLiquid(box) && worldReader.getBlockStates(box).noneMatch(state -> state.blocksMotion()) && worldReader.isUnobstructed((Entity)this);
    }

    public boolean isPushable() {
        return false;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        return new Vec3(0.0, (double)(this.getDimensions(Pose.STANDING).height() * 0.9f), 0.0);
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).yBodyRot = this.yBodyRot;
        }
        if (this.hasPassenger(passenger)) {
            Vec3 vec3 = this.getPassengerRidingPosition(passenger);
            Vec3 forwardVect = Vec3.directionFromRotation((float)0.0f, (float)this.getVisualRotationYInDegrees());
            Vec3 sideVect = Vec3.directionFromRotation((float)0.0f, (float)(this.getVisualRotationYInDegrees() - 90.0f));
            moveFunction.accept(passenger, vec3.x() + sideVect.x() - forwardVect.x() * 0.5, vec3.y() + 0.2 - passenger.getVehicleAttachmentPoint((Entity)this).y(), vec3.z() + sideVect.z() - forwardVect.z() * 0.5);
        }
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (damageSource == this.level().damageSources().sweetBerryBush()) {
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    public void makeStuckInBlock(BlockState blockState, Vec3 speedMult) {
        if (blockState.getBlock() instanceof SweetBerryBushBlock) {
            return;
        }
        super.makeStuckInBlock(blockState, speedMult);
    }

    public boolean hurt(DamageSource source, float amount) {
        LivingEntity livingEntity;
        Entity entity;
        Snowball snowball;
        Entity entity2 = source.getDirectEntity();
        if (entity2 instanceof Snowball && (snowball = (Snowball)entity2).getType() == EntityType.SNOWBALL && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)Items.SNOWBALL)) {
            if (!this.level().isClientSide()) {
                Vec3 forwardVect = Vec3.directionFromRotation((float)0.0f, (float)this.getVisualRotationYInDegrees());
                Vec3 sideVect = Vec3.directionFromRotation((float)0.0f, (float)(this.getVisualRotationYInDegrees() - 90.0f));
                ItemEntity itemEntity = new ItemEntity(this.level(), 0.0, 0.0, 0.0, Items.SNOWBALL.getDefaultInstance());
                Entity entity3 = snowball.getOwner();
                if (entity3 instanceof Player) {
                    Player player = (Player)entity3;
                    itemEntity.setThrower((Entity)player);
                }
                this.tradeItemEntity(itemEntity, forwardVect, sideVect);
            }
            return false;
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.isOnPortalCooldown() && source == this.level().damageSources().inWall()) {
            this.spawnAngryParticles(6);
            this.playHurtSound(source);
            return false;
        }
        if (!(this.isNoAi() || !((entity = source.getEntity()) instanceof LivingEntity) || (livingEntity = (LivingEntity)entity).isSpectator() || livingEntity.getType().is(BzTags.FORCED_BEE_CALM_AT) || BeeAggression.isBeelikeEntity((Entity)livingEntity))) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (this.level().getDifficulty() == Difficulty.PEACEFUL || player.isCreative()) {
                    this.spawnAngryParticles(6);
                    return super.hurt(source, amount);
                }
            }
            if ((livingEntity.level().dimension().equals(BzDimension.BZ_WORLD_KEY) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && BzBeeAggressionConfigs.aggressiveBees) {
                if (livingEntity.hasEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                    livingEntity.removeEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder());
                } else {
                    livingEntity.addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 3, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
            }
            this.startPersistentAngerTimer();
            this.setPersistentAngerTarget(livingEntity.getUUID());
            this.setTarget(livingEntity);
        }
        this.spawnAngryParticles(6);
        return super.hurt(source, amount);
    }

    protected void customServerAiStep() {
        this.underWaterTicks = this.isUnderWater() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 100) {
            this.hurt(this.level().damageSources().drown(), 3.0f);
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), false);
        }
    }

    public void tick() {
        super.tick();
        if (this.isAlive()) {
            this.idleAnimationState.startIfStopped(this.tickCount);
        } else {
            this.idleAnimationState.stop();
        }
        BeeQueenState pose = this.getQueenPose();
        if (pose != BeeQueenState.NONE) {
            if (pose == BeeQueenState.ATTACKING && this.poseTicks > 17) {
                this.setQueenPose(BeeQueenState.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenState.ITEM_REJECT && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenState.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenState.ITEM_THROW && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenState.NONE);
                this.poseTicks = 0;
            }
            ++this.poseTicks;
        }
        if (!this.isNoAi()) {
            if (!this.level().isClientSide() && this.level().getGameTime() % 200L == 0L && !this.isDeadOrDying()) {
                this.heal(1.0f);
            }
            if (!this.level().isClientSide()) {
                if (this.isAngry()) {
                    this.performAngryActions();
                } else {
                    this.performGroundTrades();
                }
            }
            if (!this.level().isClientSide()) {
                if (BzGeneralConfigs.beeQueenSpecialDayTrades && (this.tickCount == 1 || ((long)this.tickCount + this.getUUID().getLeastSignificantBits()) % 72000L == 0L)) {
                    Optional<List<Item>> specialDayItem = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItem();
                    List<Item> allowedSpecialDayTradeItems = ((List)specialDayItem.orElse(new ArrayList())).stream().filter(i -> i.isEnabled(this.level().enabledFeatures())).toList();
                    this.setIsSpecialDay(!allowedSpecialDayTradeItems.isEmpty());
                }
                if (this.tradeHintCooldown == 0 && ((long)this.tickCount + this.getUUID().getLeastSignificantBits()) % 40L == 0L) {
                    List nearbyPlayers = this.level().getNearbyPlayers(PLAYER_ACKNOWLEDGE_SIGHT, (LivingEntity)this, this.getBoundingBox().inflate(10.0));
                    for (Player player : nearbyPlayers) {
                        if (!this.isLookingAtMeClose(player)) continue;
                        Item wantItem = null;
                        List tradeResults = null;
                        if (this.getIsSpecialDay()) {
                            Optional<Pair<QueensTradeManager.SpecialDaysEntry, WeightedRandomList<WeightedTradeResult>>> specialDayRewards;
                            Optional<List<Item>> specialDayItem = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItem();
                            if (specialDayItem.isEmpty()) {
                                this.setIsSpecialDay(false);
                            }
                            if ((specialDayRewards = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(wantItem = specialDayItem.get().get(this.random.nextInt(specialDayItem.get().size())))).isEmpty()) {
                                this.setIsSpecialDay(false);
                            } else {
                                tradeResults = ((WeightedRandomList)specialDayRewards.get().getSecond()).unwrap();
                            }
                        }
                        if (wantItem == null || tradeResults == null) {
                            ObjectSet keySet = QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.keySet();
                            wantItem = keySet.stream().skip(this.random.nextInt(keySet.size())).findFirst().orElse(null);
                            tradeResults = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)wantItem)).unwrap();
                        }
                        int maximumRewardsToShowAtATime = 5;
                        ArrayList<ItemStack> allRewardItems = new ArrayList<ItemStack>();
                        for (WeightedTradeResult weightedTradeResult : tradeResults) {
                            allRewardItems.addAll(weightedTradeResult.getItems());
                        }
                        Collections.shuffle(allRewardItems);
                        List<ItemStack> slicedRewardItems = allRewardItems.subList(0, Math.min(maximumRewardsToShowAtATime, allRewardItems.size()));
                        TradeHintParticleSpawnPacket.sendToClient((Entity)this, wantItem, slicedRewardItems);
                        this.tradeHintCooldown = 220;
                        break;
                    }
                }
                if (this.tradeHintCooldown > 0) {
                    --this.tradeHintCooldown;
                }
            }
        }
    }

    private void performAngryActions() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.getTarget() instanceof Player) {
            this.stopBeingAngry();
            return;
        }
        int beeCooldown = this.getBeeSpawnCooldown();
        if (beeCooldown <= 0 && !this.isImmobile() && this.level().getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            this.setBeeSpawnCooldown(this.random.nextInt(50) + 75);
            BlockPos spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange((LivingEntity)this, 5, 0);
            if (!this.level().getBlockState(spawnBlockPos).isAir()) {
                return;
            }
            Bee bee = (Bee)EntityType.BEE.create(this.level());
            if (bee == null) {
                return;
            }
            bee.setRemainingPersistentAngerTime(this.getRemainingPersistentAngerTime());
            bee.setPersistentAngerTarget(this.getPersistentAngerTarget());
            bee.setTarget(this.getTarget());
            bee.absMoveTo((double)spawnBlockPos.getX() + 0.5, (double)spawnBlockPos.getY() + 0.5, (double)spawnBlockPos.getZ() + 0.5, this.random.nextFloat() * 360.0f, 0.0f);
            bee.finalizeSpawn((ServerLevelAccessor)((ServerLevel)this.level()), this.level().getCurrentDifficultyAt(spawnBlockPos), MobSpawnType.TRIGGERED, null);
            bee.addEffect(new MobEffectInstance(MobEffects.WITHER, Integer.MAX_VALUE, 0, true, false, false));
            this.level().addFreshEntity((Entity)bee);
            this.spawnAngryParticles(6);
            this.setQueenPose(BeeQueenState.ATTACKING);
        } else {
            this.setBeeSpawnCooldown(beeCooldown - 1);
        }
    }

    private void performGroundTrades() {
        if (!BzGeneralConfigs.beeQueenGroundPickup) {
            return;
        }
        int throwCooldown = this.getThrowCooldown();
        if (throwCooldown > 0) {
            this.setThrowCooldown(throwCooldown - 1);
        }
        if ((this.level().getGameTime() + this.getUUID().getLeastSignificantBits()) % 20L == 0L && throwCooldown <= 0) {
            Vec3 forwardVect = Vec3.directionFromRotation((float)0.0f, (float)this.getVisualRotationYInDegrees());
            Vec3 sideVect = Vec3.directionFromRotation((float)0.0f, (float)(this.getVisualRotationYInDegrees() - 90.0f));
            AABB scanArea = this.getBoundingBox().deflate(0.45, 0.9, 0.45).move(forwardVect.x() * 0.5, -0.95, forwardVect.z() * 0.5);
            List items = this.level().getEntitiesOfClass(ItemEntity.class, scanArea);
            items.stream().filter(ie -> !ie.hasPickUpDelay()).findFirst().ifPresent(itemEntity -> this.tradeItemEntity((ItemEntity)itemEntity, forwardVect, sideVect));
        }
    }

    private void tradeItemEntity(ItemEntity itemEntity, Vec3 forwardVect, Vec3 sideVect) {
        Player player;
        Optional reward;
        int tradedItems = 0;
        Item item = itemEntity.getItem().getItem();
        boolean didSpecialDayTrade = false;
        if (this.getIsSpecialDay() && QueensTradeManager.QUEENS_TRADE_MANAGER.specialDayQueenTrades.containsKey((Object)item)) {
            Optional<Pair<QueensTradeManager.SpecialDaysEntry, WeightedRandomList<WeightedTradeResult>>> specialDayItems = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(item);
            if (specialDayItems.isPresent()) {
                reward = ((WeightedRandomList)specialDayItems.get().getSecond()).getRandom(this.random);
                if (reward.isPresent()) {
                    this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.getItem(), ((ItemEntityAccessor)itemEntity).bumblezone$getThrower(), (QueensTradeManager.SpecialDaysEntry)specialDayItems.get().getFirst());
                    ++tradedItems;
                }
            } else {
                this.setIsSpecialDay(false);
            }
        }
        if (!didSpecialDayTrade && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            for (int i = 0; i < itemEntity.getItem().getCount(); ++i) {
                reward = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).getRandom(this.random);
                if (!reward.isPresent()) continue;
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.getItem(), ((ItemEntityAccessor)itemEntity).bumblezone$getThrower());
                ++tradedItems;
            }
        }
        if (tradedItems > 0) {
            itemEntity.remove(Entity.RemovalReason.DISCARDED);
        } else {
            itemEntity.remove(Entity.RemovalReason.DISCARDED);
            ItemEntity rejectedItemEntity = new ItemEntity(this.level(), this.getX() + sideVect.x() * 1.75 + forwardVect.x() * 1.0, this.getY() + 0.3, this.getZ() + sideVect.z() * 1.75 + forwardVect.x() * 1.0, itemEntity.getItem(), (double)((this.random.nextFloat() - 0.5f) / 10.0f) + forwardVect.x() / 3.0, (double)0.4f, (double)((this.random.nextFloat() - 0.5f) / 10.0f) + forwardVect.z() / 3.0);
            this.level().addFreshEntity((Entity)rejectedItemEntity);
            rejectedItemEntity.setDefaultPickUpDelay();
            this.spawnAngryParticles(2);
            this.setQueenPose(BeeQueenState.ITEM_REJECT);
        }
        this.setThrowCooldown(50);
        if (tradedItems > 0 && itemEntity.getOwner() != null && (player = this.level().getPlayerByUUID(itemEntity.getOwner().getUUID())) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((GenericTrigger)((Object)BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.get())).trigger(serverPlayer);
            PlayerDataHandler.onQueenBeeTrade((Player)serverPlayer, tradedItems);
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                    if (!capability.receivedEssencePrize) {
                        this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.EMPTY, serverPlayer.getUUID());
                        capability.receivedEssencePrize = true;
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"entity.the_bumblezone.bee_queen.mention_reset").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), false);
                    }
                });
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isNoAi()) {
            return InteractionResult.PASS;
        }
        if (this.isAngry() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (stack.isEmpty() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                    if (!capability.receivedEssencePrize) {
                        Vec3 forwardVect = Vec3.directionFromRotation((float)0.0f, (float)this.getVisualRotationYInDegrees());
                        Vec3 sideVect = Vec3.directionFromRotation((float)0.0f, (float)(this.getVisualRotationYInDegrees() - 90.0f));
                        this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.EMPTY, serverPlayer.getUUID());
                        capability.receivedEssencePrize = true;
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"entity.the_bumblezone.bee_queen.mention_reset").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), false);
                    } else {
                        long timeDiff = this.level().getGameTime() - capability.tradeResetPrimedTime;
                        if (timeDiff < 200L && timeDiff > 10L) {
                            this.resetAdvancementTree(serverPlayer, BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
                            capability.resetAllTrackerStats();
                            serverPlayer.displayClientMessage((Component)Component.translatable((String)"entity.the_bumblezone.bee_queen.reset_advancements").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), false);
                        } else {
                            capability.tradeResetPrimedTime = this.level().getGameTime();
                            serverPlayer.displayClientMessage((Component)Component.translatable((String)"entity.the_bumblezone.bee_queen.advancements_warning").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), false);
                        }
                    }
                });
            }
            return InteractionResult.PASS;
        }
        boolean traded = false;
        if (QueensTradeManager.QUEENS_TRADE_MANAGER.specialDayQueenTrades.containsKey((Object)item)) {
            Optional<Pair<QueensTradeManager.SpecialDaysEntry, WeightedRandomList<WeightedTradeResult>>> specialDayItems = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(item);
            if (specialDayItems.isPresent()) {
                if (this.level().isClientSide()) {
                    return InteractionResult.SUCCESS;
                }
                Vec3 forwardVect = Vec3.directionFromRotation((float)0.0f, (float)this.getVisualRotationYInDegrees());
                Vec3 sideVect = Vec3.directionFromRotation((float)0.0f, (float)(this.getVisualRotationYInDegrees() - 90.0f));
                Optional reward = ((WeightedRandomList)specialDayItems.get().getSecond()).getRandom(this.random);
                if (reward.isPresent()) {
                    this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.getUUID(), (QueensTradeManager.SpecialDaysEntry)specialDayItems.get().getFirst());
                    traded = true;
                }
            } else {
                this.setIsSpecialDay(false);
            }
        }
        if (!traded && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            if (this.level().isClientSide()) {
                return InteractionResult.SUCCESS;
            }
            Vec3 forwardVect = Vec3.directionFromRotation((float)0.0f, (float)this.getVisualRotationYInDegrees());
            Vec3 sideVect = Vec3.directionFromRotation((float)0.0f, (float)(this.getVisualRotationYInDegrees() - 90.0f));
            Optional reward = ((WeightedRandomList)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).getRandom(this.random);
            if (reward.isPresent()) {
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.getUUID());
                traded = true;
            }
        }
        if (!this.level().isClientSide()) {
            if (!traded) {
                this.spawnAngryParticles(2);
                this.setQueenPose(BeeQueenState.ITEM_REJECT);
            } else {
                this.setThrowCooldown(50);
                stack.shrink(1);
                player.setItemInHand(hand, stack);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((GenericTrigger)((Object)BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.get())).trigger(serverPlayer);
                    PlayerDataHandler.onQueenBeeTrade((Player)serverPlayer);
                    if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                        ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                            if (!capability.receivedEssencePrize) {
                                Vec3 forwardVect = Vec3.directionFromRotation((float)0.0f, (float)this.getVisualRotationYInDegrees());
                                Vec3 sideVect = Vec3.directionFromRotation((float)0.0f, (float)(this.getVisualRotationYInDegrees() - 90.0f));
                                this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, ItemStack.EMPTY, serverPlayer.getUUID());
                                capability.receivedEssencePrize = true;
                                serverPlayer.displayClientMessage((Component)Component.translatable((String)"entity.the_bumblezone.bee_queen.mention_reset").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD), false);
                            }
                        });
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void resetAdvancementTree(ServerPlayer serverPlayer, ResourceLocation advancementRL) {
        AdvancementTree tree = serverPlayer.server.getAdvancements().tree();
        AdvancementHolder parentAdvancement = serverPlayer.server.getAdvancements().get(advancementRL);
        if (parentAdvancement == null) {
            return;
        }
        AdvancementNode advancementParentNode = tree.get(parentAdvancement);
        if (advancementParentNode == null) {
            return;
        }
        AdvancementHolder beeEssenceAdvancementHolder = serverPlayer.server.getAdvancements().get(BEE_ESSENCE_ADVANCEMENT_RL);
        Iterable advancements = advancementParentNode.children();
        for (AdvancementNode advancementChildNode : advancements) {
            if (advancementChildNode.holder().equals((Object)beeEssenceAdvancementHolder)) continue;
            AdvancementProgress advancementprogress = serverPlayer.getAdvancements().getOrStartProgress(advancementChildNode.holder());
            for (String criteria : advancementprogress.getCompletedCriteria()) {
                serverPlayer.getAdvancements().revoke(advancementChildNode.holder(), criteria);
            }
            this.resetAdvancementTree(serverPlayer, advancementChildNode.holder().id());
        }
    }

    private static boolean finalbeeQueenAdvancementDone(ServerPlayer serverPlayer) {
        AdvancementHolder advancementHolder = serverPlayer.server.getAdvancements().get(BzCriterias.QUEENS_DESIRE_FINAL_ADVANCEMENT);
        if (advancementHolder == null) {
            return false;
        }
        Map<AdvancementHolder, AdvancementProgress> advancementsProgressMap = ((PlayerAdvancementsAccessor)serverPlayer.getAdvancements()).bumblezone$getProgress();
        return advancementsProgressMap.containsKey(advancementHolder) && advancementsProgressMap.get(advancementHolder).isDone();
    }

    private void spawnReward(Vec3 forwardVect, Vec3 sideVect, WeightedTradeResult reward, ItemStack originalItem, UUID playerUUID) {
        this.spawnReward(forwardVect, sideVect, reward, originalItem, playerUUID, null);
    }

    private void spawnReward(Vec3 forwardVect, Vec3 sideVect, WeightedTradeResult reward, ItemStack originalItem, UUID playerUUID, QueensTradeManager.SpecialDaysEntry specialDaysEntry) {
        int currentItemStackCount;
        Player player;
        int rewardMultiplier = 1;
        if (specialDaysEntry != null && playerUUID != null && (player = this.level().getPlayerByUUID(playerUUID)) != null) {
            player.displayClientMessage((Component)Component.translatable((String)specialDaysEntry.specialMessage()).withStyle(specialDaysEntry.textColor()), true);
        }
        ItemStack chosenItem = reward.getItems().get(this.random.nextInt(reward.getItems().size()));
        int itemStackMaxSize = chosenItem.getMaxStackSize();
        for (int remainingItemToSpawn = reward.count * rewardMultiplier; remainingItemToSpawn > 0; remainingItemToSpawn -= currentItemStackCount) {
            Level level;
            ItemStack rewardItem = chosenItem.copyWithCount(1);
            this.setQueenPose(BeeQueenState.ITEM_THROW);
            currentItemStackCount = Math.min(remainingItemToSpawn, itemStackMaxSize);
            rewardItem.setCount(currentItemStackCount);
            ItemEntity rewardItemEntity = new ItemEntity(this.level(), this.getX() + sideVect.x() * 0.9 + forwardVect.x() * 1.0, this.getY() + 0.3, this.getZ() + sideVect.z() * 0.9 + forwardVect.x() * 1.0, rewardItem, (double)((this.random.nextFloat() - 0.5f) / 10.0f) + forwardVect.x() / 4.0, (double)0.3f, (double)((this.random.nextFloat() - 0.5f) / 10.0f) + forwardVect.z() / 4.0);
            this.level().addFreshEntity((Entity)rewardItemEntity);
            rewardItemEntity.setDefaultPickUpDelay();
            this.spawnHappyParticles();
            if (reward.xpReward <= 0 || !((level = this.level()) instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            ExperienceOrb.award((ServerLevel)serverLevel, (Vec3)new Vec3(this.getX() + forwardVect.x() * 1.0, this.getY() + 0.3, this.getZ() + forwardVect.x() * 1.0), (int)reward.xpReward);
        }
        this.level().playSound(null, this.blockPosition(), (SoundEvent)BzSounds.BEE_QUEEN_HAPPY.get(), SoundSource.NEUTRAL, 1.0f, this.getRandom().nextFloat() * 0.2f + 0.6f);
    }

    boolean isLookingAtMeClose(Player player) {
        Vec3 normalizedPlayerView = player.getViewVector(1.0f).normalize();
        Vec3 diff = new Vec3(this.getX() - player.getX(), this.getEyeY() - 0.2 - player.getEyeY(), this.getZ() - player.getZ());
        double d = diff.length();
        double dotProduct = normalizedPlayerView.dot(diff = diff.normalize());
        return dotProduct > 0.9 - 0.025 / d && player.hasLineOfSight((Entity)this);
    }

    public void spawnAngryParticles(int particles) {
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX(), this.getY() + (double)0.45f, this.getZ(), particles, (double)(this.getRandom().nextFloat() - 0.5f), (double)(this.getRandom().nextFloat() * 0.4f + 0.4f), (double)(this.getRandom().nextFloat() - 0.5f), (double)(this.getRandom().nextFloat() * 0.8f + 0.4f));
        }
    }

    private void spawnHappyParticles() {
        ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX(), this.getY() + 0.75, this.getZ(), 5, 0.8, 0.75, 0.8, (double)this.getRandom().nextFloat() + 0.5);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        Bee bee = (Bee)EntityType.BEE.create((Level)serverWorld);
        bee.setBaby(true);
        return bee;
    }

    public int getHeadRotSpeed() {
        return 1;
    }

    public int getMaxHeadXRot() {
        return 90;
    }

    public int getThrowCooldown() {
        return (Integer)this.entityData.get(THROWCOOLDOWN);
    }

    public void setThrowCooldown(Integer cooldown) {
        this.entityData.set(THROWCOOLDOWN, (Object)cooldown);
    }

    public int getBeeSpawnCooldown() {
        return (Integer)this.entityData.get(BEESPAWNCOOLDOWN);
    }

    public void setBeeSpawnCooldown(Integer cooldown) {
        this.entityData.set(BEESPAWNCOOLDOWN, (Object)cooldown);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int remainingPersistentAngerTime) {
        this.entityData.set(REMAINING_ANGER_TIME, (Object)remainingPersistentAngerTime);
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    public void stopBeingAngry() {
        super.stopBeingAngry();
        this.setBeeSpawnCooldown(0);
        this.setTarget(null);
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)BzSounds.BEE_QUEEN_LOOP.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)BzSounds.BEE_QUEEN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)BzSounds.BEE_QUEEN_DEATH.get();
    }

    public boolean canBeLeashed() {
        return false;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.2f));
    }
}

