/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.neoforge;

import com.telepathicgrunt.the_bumblezone.configs.neoforge.BzBeeAggressionConfig;
import com.telepathicgrunt.the_bumblezone.configs.neoforge.BzClientConfig;
import com.telepathicgrunt.the_bumblezone.configs.neoforge.BzDimensionConfig;
import com.telepathicgrunt.the_bumblezone.configs.neoforge.BzGeneralConfig;
import com.telepathicgrunt.the_bumblezone.configs.neoforge.BzModCompatibilityConfig;
import com.telepathicgrunt.the_bumblezone.configs.neoforge.BzWorldgenConfig;
import com.telepathicgrunt.the_bumblezone.items.potions.ConfigSafePotion;
import com.telepathicgrunt.the_bumblezone.modinit.BzPotions;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.FMLPaths;

public class BzConfigHandler {
    public static void setup(ModContainer modContainer, IEventBus modEventBus) {
        modEventBus.addListener(BzConfigHandler::onConfigLoad);
        modEventBus.addListener(BzConfigHandler::onConfigReload);
        try {
            Files.createDirectories(FMLPaths.CONFIGDIR.get().resolve("the_bumblezone"), new FileAttribute[0]);
            modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BzClientConfig.GENERAL_SPEC, "the_bumblezone/client.toml");
            modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzGeneralConfig.GENERAL_SPEC, "the_bumblezone/general.toml");
            modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzWorldgenConfig.GENERAL_SPEC, "the_bumblezone/worldgen.toml");
            modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzDimensionConfig.GENERAL_SPEC, "the_bumblezone/dimension.toml");
            modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzBeeAggressionConfig.GENERAL_SPEC, "the_bumblezone/bee_aggression.toml");
            modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BzModCompatibilityConfig.GENERAL_SPEC, "the_bumblezone/mod_compatibility.toml");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create Bumblezone config files: ", e);
        }
    }

    private static void onConfigLoad(ModConfigEvent.Loading event) {
        BzConfigHandler.copyToCommon(event.getConfig().getSpec());
    }

    private static void onConfigReload(ModConfigEvent.Reloading event) {
        BzPotions.POTIONS.getEntries().forEach(p -> {
            if (p instanceof ConfigSafePotion) {
                ConfigSafePotion configSafePotion = (ConfigSafePotion)((Object)p);
                configSafePotion.clearCachedEffectList();
            }
        });
        BzConfigHandler.copyToCommon(event.getConfig().getSpec());
    }

    private static void copyToCommon(IConfigSpec spec) {
        if (spec == BzClientConfig.GENERAL_SPEC) {
            BzClientConfig.copyToCommon();
        }
        if (spec == BzGeneralConfig.GENERAL_SPEC) {
            BzGeneralConfig.copyToCommon();
        }
        if (spec == BzWorldgenConfig.GENERAL_SPEC) {
            BzWorldgenConfig.copyToCommon();
        }
        if (spec == BzDimensionConfig.GENERAL_SPEC) {
            BzDimensionConfig.copyToCommon();
        }
        if (spec == BzBeeAggressionConfig.GENERAL_SPEC) {
            BzBeeAggressionConfig.copyToCommon();
        }
        if (spec == BzModCompatibilityConfig.GENERAL_SPEC) {
            BzModCompatibilityConfig.copyToCommon();
        }
    }
}

