/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.items.BuzzingBriefcase;
import com.telepathicgrunt.the_bumblezone.menus.BuzzingBriefcaseMenu;
import com.telepathicgrunt.the_bumblezone.mixin.client.EntityRenderersAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.BeeEntityInvoker;
import com.telepathicgrunt.the_bumblezone.mixin.entities.EntityAccessor;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.resources.LegacyStuffWrapper;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;

public class BuzzingBriefcaseScreen
extends AbstractContainerScreen<BuzzingBriefcaseMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/background.png");
    private static final ResourceLocation BEE_SLOT_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_slots.png");
    private static final ResourceLocation GENERAL_ICONS = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/general_icons.png");
    private static final ResourceLocation BEE_VANILLA_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_vanilla.png");
    private static final ResourceLocation BEE_BASE_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_base_layer.png");
    private static final ResourceLocation BEE_PRIMARY_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_primary_layer.png");
    private static final ResourceLocation BEE_SECONDARY_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_secondary_layer.png");
    private static final ResourceLocation BEE_STINGER_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_stinger.png");
    private static final ResourceLocation BEE_POLLEN_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_pollen.png");
    private static final ResourceLocation BEE_BABY_BASE_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_baby_base_layer.png");
    private static final ResourceLocation BEE_BABY_PRIMARY_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_baby_primary_layer.png");
    private static final ResourceLocation BEE_BABY_SECONDARY_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_baby_secondary_layer.png");
    private static final ResourceLocation BEE_BABY_STINGER_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_baby_stinger.png");
    private static final ResourceLocation BEE_BABY_POLLEN_ICON = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/gui/buzzing_briefcase/bee_icon_baby_pollen.png");
    private static final int NORMAL_PRIMARY_COLOR = 15046912;
    private static final int NORMAL_SECONDARY_COLOR = 2298112;
    private static final int MISSING_PRIMARY_COLOR = 0;
    private static final int MISSING_SECONDARY_COLOR = 0xF200FF;
    private static final int[] IGNORE_COLORS = new int[]{8178129, 1973800, 3156791, 0xF7FDFD, 15856352, 6238757};
    private static final float SCALE = 1.25f;
    private static final int MENU_HEIGHT = 217;
    private static final int MENU_WIDTH = 382;
    private static final int MAX_ROW_LENGTH = 7;
    private final List<BeeState> BEE_INVENTORY = new ArrayList<BeeState>();
    private final Inventory inventory;
    private CompoundTag cachedBriefcaseTag;

    public BuzzingBriefcaseScreen(BuzzingBriefcaseMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 240;
        this.imageHeight = 126;
        this.titleLabelX = 75;
        this.titleLabelY = -38;
        this.inventory = playerInventory;
    }

    protected void init() {
        this.leftPos = (this.getTrueWidth() - this.imageWidth) / 2;
        this.topPos = (this.getTrueHeight() - this.imageHeight) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        ItemStack briefcaseStack = (ItemStack)((BuzzingBriefcaseMenu)this.menu).getItems().get(0);
        if (!briefcaseStack.isEmpty() && !((CustomData)briefcaseStack.getComponents().get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get())).getUnsafe().equals((Object)this.cachedBriefcaseTag)) {
            this.cachedBriefcaseTag = ((CustomData)briefcaseStack.getComponents().get((DataComponentType)BzDataComponents.BUZZING_BRIEFCASE_DATA.get())).getUnsafe();
            List<Entity> beesStored = BuzzingBriefcase.getBeesStored(this.inventory.player.level(), briefcaseStack, false);
            if (this.isDiffFoundInBeeList(beesStored)) {
                this.BEE_INVENTORY.clear();
                for (Entity entity : beesStored) {
                    if (!(entity instanceof Bee)) continue;
                    Bee bee = (Bee)entity;
                    bee.stopBeingAngry();
                    boolean pollinated = bee.hasNectar();
                    ((BeeEntityInvoker)bee).bumblezone$callSetHasNectar(false);
                    try {
                        this.addBeeWithColor(bee);
                    }
                    catch (Exception e) {
                        this.BEE_INVENTORY.add(new BeeState(bee, 0, 0xF200FF));
                        Bumblezone.LOGGER.warn("Bumblezone Buzzing Briefcase Clientside: Error trying to dynamically get color for following bee -");
                        CompoundTag tag = new CompoundTag();
                        bee.saveWithoutId(tag);
                        Bumblezone.LOGGER.warn("Bee: {}", (Object)tag);
                    }
                    ((BeeEntityInvoker)bee).bumblezone$callSetHasNectar(pollinated);
                }
            }
        }
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.enableDepthTest();
        this.drawBeeSlots(guiGraphics, this.leftPos, this.topPos, mouseX, mouseY);
    }

    private boolean isDiffFoundInBeeList(List<Entity> beesStored) {
        if (this.BEE_INVENTORY.size() != beesStored.size()) {
            return true;
        }
        for (int i = 0; i < beesStored.size(); ++i) {
            Entity beeFound = beesStored.get(i);
            Bee beeSaved = this.BEE_INVENTORY.get(i).beeEntity();
            if (!(beeFound instanceof Bee)) continue;
            Bee bee = (Bee)beeFound;
            if (bee.hasNectar() != beeSaved.hasNectar()) {
                return true;
            }
            if (bee.getHealth() != beeSaved.getHealth()) {
                return true;
            }
            if (bee.isBaby() != beeSaved.isBaby()) {
                return true;
            }
            if (bee.hasStung() == beeSaved.hasStung()) continue;
            return true;
        }
        return false;
    }

    private void addBeeWithColor(Bee bee) throws IOException {
        int primaryColor = 15046912;
        int secondaryColor = 2298112;
        if (bee.getType() == EntityType.BEE) {
            this.BEE_INVENTORY.add(new BeeState(bee, primaryColor, secondaryColor));
            return;
        }
        for (ModCompat compat : ModChecker.BEE_COLOR_COMPATS) {
            Pair<Integer, Integer> moddedBeeColors = compat.getModdedBeePrimaryAndSecondaryColors((Entity)bee);
            if (moddedBeeColors == null) continue;
            this.BEE_INVENTORY.add(new BeeState(bee, (Integer)moddedBeeColors.getFirst(), (Integer)moddedBeeColors.getSecond()));
            return;
        }
        EntityRendererProvider<?> rendererProvider = EntityRenderersAccessor.bumblezone$getPROVIDERS().get(bee.getType());
        if (rendererProvider != null) {
            EntityRenderer entityRenderer = rendererProvider.create(new EntityRendererProvider.Context(this.minecraft.getEntityRenderDispatcher(), this.minecraft.getItemRenderer(), this.minecraft.getBlockRenderer(), new ItemInHandRenderer(this.minecraft, this.minecraft.getEntityRenderDispatcher(), this.minecraft.getItemRenderer()), this.minecraft.getResourceManager(), this.minecraft.getEntityModels(), this.font));
            ResourceLocation textureLocation = entityRenderer.getTextureLocation((Entity)bee);
            int[] pixels = LegacyStuffWrapper.getPixels((ResourceManager)this.minecraft.getResourceManager(), (ResourceLocation)textureLocation);
            if (pixels == null || pixels.length == 0) {
                throw new RuntimeException("No pixels found for bee texture.");
            }
            ObjectArrayList colors = new ObjectArrayList();
            HashMap<Integer, Integer> deniedColors = new HashMap<Integer, Integer>();
            for (int pixel : pixels) {
                if (!((double)GeneralUtils.getAlpha(pixel) > 0.15)) continue;
                boolean isColorSimilarToDisallowedColors = false;
                for (int disallowedColor : IGNORE_COLORS) {
                    if (!GeneralUtils.isSimilarInColor(pixel, disallowedColor, 1)) continue;
                    isColorSimilarToDisallowedColors = true;
                    break;
                }
                if (!isColorSimilarToDisallowedColors) {
                    colors.add(pixel);
                    continue;
                }
                deniedColors.put(pixel, deniedColors.getOrDefault(pixel, 0) + 1);
            }
            Object object = deniedColors.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if ((Integer)entry.getValue() < 200) continue;
                for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                    colors.add((Integer)entry.getKey());
                }
            }
            deniedColors.clear();
            ObjectArrayList originalColors = new ObjectArrayList();
            ObjectArrayList averagedColors = new ObjectArrayList();
            ObjectArrayList combinedColorCount = new ObjectArrayList();
            for (int i = colors.size() - 1; i >= 0; --i) {
                int color = (Integer)colors.remove(i);
                if (averagedColors.isEmpty()) {
                    originalColors.add(color);
                    averagedColors.add(color);
                    combinedColorCount.add(1);
                    continue;
                }
                boolean combined = false;
                for (int k = averagedColors.size() - 1; k >= 0; --k) {
                    int originalColor = (Integer)originalColors.get(k);
                    int averagedColor = (Integer)averagedColors.get(k);
                    if (!GeneralUtils.isSimilarInVisualColor(color, originalColor, 35, 80)) continue;
                    averagedColors.set(k, GeneralUtils.colorToInt((GeneralUtils.getRed(color) + GeneralUtils.getRed(averagedColor)) / 2, (GeneralUtils.getGreen(color) + GeneralUtils.getGreen(averagedColor)) / 2, (GeneralUtils.getBlue(color) + GeneralUtils.getBlue(averagedColor)) / 2));
                    combinedColorCount.set(k, (Integer)combinedColorCount.get(k) + 1);
                    combined = true;
                }
                if (combined) continue;
                originalColors.add(color);
                averagedColors.add(color);
                combinedColorCount.add(1);
            }
            int largestColorIndex1 = 0;
            int largestColorIndex2 = 0;
            for (int i = 0; i < combinedColorCount.size(); ++i) {
                if ((Integer)combinedColorCount.get(i) >= (Integer)combinedColorCount.get(largestColorIndex1)) {
                    if ((Integer)combinedColorCount.get(largestColorIndex1) >= (Integer)combinedColorCount.get(largestColorIndex2)) {
                        largestColorIndex2 = largestColorIndex1;
                    }
                    largestColorIndex1 = i;
                    continue;
                }
                if (largestColorIndex2 != largestColorIndex1 && (largestColorIndex1 == i || (Integer)combinedColorCount.get(i) < (Integer)combinedColorCount.get(largestColorIndex2))) continue;
                largestColorIndex2 = i;
            }
            primaryColor = (Integer)averagedColors.get(largestColorIndex1);
            secondaryColor = (Integer)averagedColors.get(largestColorIndex2);
        }
        this.BEE_INVENTORY.add(new BeeState(bee, primaryColor, secondaryColor));
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialtick, int x, int y) {
        int startX = (this.getTrueWidth() - 382) / 2;
        int startY = (this.getTrueHeight() - 217) / 2;
        RenderSystem.enableDepthTest();
        guiGraphics.blit(CONTAINER_BACKGROUND, startX, startY, 0.0f, 0.0f, 382, 434, 382, 434);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        guiGraphics.drawString(this.font, this.title, 74, -38, 0xFFEFAF, true);
    }

    protected void renderButtonTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int rowIndex = 0;
        int columnIndex = 0;
        for (BeeState beeState : this.BEE_INVENTORY) {
            Component beeNormalAndCustomName;
            int xOffset = BuzzingBriefcaseScreen.getXOffset(rowIndex);
            int yOffset = BuzzingBriefcaseScreen.getYOffset(columnIndex);
            int mainX = this.leftPos + xOffset;
            int mainY = this.topPos + yOffset;
            if (++rowIndex == 7) {
                rowIndex = 0;
                ++columnIndex;
            }
            if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 22.0 && (double)(mouseY - mainY) >= 0.0 && (double)(mouseY - mainY) < 22.0) {
                Bee beeEntity = beeState.beeEntity();
                beeNormalAndCustomName = beeEntity.getName();
                Component beeNoneCustomName = beeEntity.getName();
                if (beeNoneCustomName != null && beeNoneCustomName.equals((Object)beeEntity.getCustomName())) {
                    beeNoneCustomName = ((EntityAccessor)beeEntity).bumblezone$callGetTypeName();
                }
                boolean isNameAndTypeEqual = beeNoneCustomName != null && beeNoneCustomName.equals((Object)beeNormalAndCustomName);
                ArrayList<MutableComponent> toolTipComponents = new ArrayList<MutableComponent>();
                if (isNameAndTypeEqual) {
                    toolTipComponents.add(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_bee_type", (Object[])new Object[]{beeNormalAndCustomName}).withStyle(ChatFormatting.YELLOW));
                } else {
                    toolTipComponents.add(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_bee_name", (Object[])new Object[]{beeNormalAndCustomName}));
                    toolTipComponents.add(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_bee_type", (Object[])new Object[]{beeNoneCustomName}).withStyle(ChatFormatting.YELLOW));
                }
                if (GeneralUtilsClient.isAdvancedToolTipActive()) {
                    toolTipComponents.add(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_bee_registry_name", (Object[])new Object[]{BuiltInRegistries.ENTITY_TYPE.getKey((Object)beeState.beeEntity().getType()).toString()}).withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
                }
                guiGraphics.renderTooltip(this.font, toolTipComponents, Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - (mainX + 22)) >= 0.0 && (double)(mouseX - (mainX + 22)) < 11.0 && (double)(mouseY - mainY) >= 0.0 && (double)(mouseY - mainY) < 11.0) {
                Bee beeEntity = beeState.beeEntity();
                beeNormalAndCustomName = beeEntity.getName();
                guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_release", (Object[])new Object[]{beeNormalAndCustomName})), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
                if (!(beeState.beeEntity().getHealth() < beeState.beeEntity().getMaxHealth())) continue;
                boolean hasHoneyBottleItem = this.inventory.contains(Items.HONEY_BOTTLE.getDefaultInstance());
                if (hasHoneyBottleItem) {
                    guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_health_1"), Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_health_2")), Optional.empty(), mouseX, mouseY);
                    continue;
                }
                guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_health_missing_item")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - (mainX + 11)) >= 0.0 && (double)(mouseX - (mainX + 11)) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
                if (!beeState.beeEntity().hasStung()) continue;
                boolean hasBeeStingerItem = this.inventory.contains(((Item)BzItems.BEE_STINGER.get()).getDefaultInstance());
                if (hasBeeStingerItem) {
                    guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_stinger_1"), Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_stinger_2")), Optional.empty(), mouseX, mouseY);
                    continue;
                }
                guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_stinger_missing_item")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 33)) >= 0.0 && (double)(mouseY - (mainY + 33)) < 11.0) {
                if (!beeState.beeEntity().isBaby()) continue;
                boolean hasHoneyBottleItem = this.inventory.contains(Items.HONEY_BOTTLE.getDefaultInstance());
                if (hasHoneyBottleItem) {
                    guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_grow_up_1"), Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_grow_up_2")), Optional.empty(), mouseX, mouseY);
                    continue;
                }
                guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_grow_up_missing_item")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            if (!((double)(mouseX - (mainX + 11)) >= 0.0) || !((double)(mouseX - (mainX + 11)) < 11.0) || !((double)(mouseY - (mainY + 33)) >= 0.0) || !((double)(mouseY - (mainY + 33)) < 11.0) || !beeState.beeEntity().getType().is(BzTags.BUZZING_BRIEFCASE_CAN_POLLINATE) || beeState.beeEntity().hasNectar()) continue;
            boolean hasPollenPuffItem = this.inventory.contains(((Item)BzItems.POLLEN_PUFF.get()).getDefaultInstance());
            if (hasPollenPuffItem) {
                guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_pollen_1"), Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_pollen_2")), Optional.empty(), mouseX, mouseY);
                continue;
            }
            guiGraphics.renderTooltip(this.font, List.of(Component.translatable((String)"item.the_bumblezone.buzzing_briefcase_pollen_missing_item")), Optional.empty(), mouseX, mouseY);
        }
    }

    private void drawBeeSlots(GuiGraphics guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        boolean hasStingerItem = false;
        boolean hasHoneyBottleItem = false;
        boolean hasPollenPuffItem = false;
        if (!this.BEE_INVENTORY.isEmpty()) {
            hasStingerItem = this.inventory.contains(((Item)BzItems.BEE_STINGER.get()).getDefaultInstance());
            hasHoneyBottleItem = this.inventory.contains(Items.HONEY_BOTTLE.getDefaultInstance());
            hasPollenPuffItem = this.inventory.contains(((Item)BzItems.POLLEN_PUFF.get()).getDefaultInstance());
        }
        int rowIndex = 0;
        int columnIndex = 0;
        for (int beeIndex = 0; beeIndex < 14; ++beeIndex) {
            int xOffset = BuzzingBriefcaseScreen.getXOffset(rowIndex);
            int yOffset = BuzzingBriefcaseScreen.getYOffset(columnIndex);
            int mainX = startX + xOffset;
            int mainY = startY + yOffset;
            if (++rowIndex == 7) {
                rowIndex = 0;
                ++columnIndex;
            }
            BeeState beeState = null;
            if (beeIndex < this.BEE_INVENTORY.size()) {
                beeState = this.BEE_INVENTORY.get(beeIndex);
            }
            RenderSystem.enableDepthTest();
            if (beeState == null) {
                guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX, mainY, 22.0f, 0.0f, 22, 22, 64, 64);
                guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX, mainY + 22, 22.0f, 22.0f, 11, 11, 64, 64);
                guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX + 11, mainY + 22, 22.0f, 22.0f, 11, 11, 64, 64);
                guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
                guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX + 11, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
                continue;
            }
            BuzzingBriefcaseScreen.drawBeeSlot(guiGraphics, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderHealthButton(guiGraphics, mouseX, mouseY, hasHoneyBottleItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderStingerButton(guiGraphics, mouseX, mouseY, hasStingerItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderGrowUpButton(guiGraphics, mouseX, mouseY, hasHoneyBottleItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderPollenButton(guiGraphics, mouseX, mouseY, hasPollenPuffItem, mainX, mainY, beeState);
            BuzzingBriefcaseScreen.renderReleaseButton(guiGraphics, mouseX, mouseY, mainX, mainY);
            this.renderButtonTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private static void drawBeeSlot(GuiGraphics guiGraphics, int mainX, int mainY, BeeState beeState) {
        guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX, mainY, 0.0f, 0.0f, 22, 22, 64, 64);
        boolean isBaby = beeState.beeEntity().isBaby();
        if (beeState.beeEntity().getType() == EntityType.BEE) {
            int beeIconXOffset = 0;
            int beeIconYOffset = 0;
            if (isBaby) {
                beeIconYOffset += 16;
            }
            if (beeState.beeEntity().hasStung()) {
                beeIconXOffset += 16;
            }
            if (beeState.beeEntity().hasNectar()) {
                beeIconXOffset += 32;
            }
            guiGraphics.blit(BEE_VANILLA_ICON, mainX + 3, mainY + 3, (float)beeIconXOffset, (float)beeIconYOffset, 16, 16, 64, 64);
        } else {
            guiGraphics.blit(isBaby ? BEE_BABY_BASE_ICON : BEE_BASE_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.setColor((float)GeneralUtils.getRed(beeState.primaryColor()) / 255.0f, (float)GeneralUtils.getGreen(beeState.primaryColor()) / 255.0f, (float)GeneralUtils.getBlue(beeState.primaryColor()) / 255.0f, 1.0f);
            guiGraphics.blit(isBaby ? BEE_BABY_PRIMARY_ICON : BEE_PRIMARY_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.setColor((float)GeneralUtils.getRed(beeState.secondaryColor()) / 255.0f, (float)GeneralUtils.getGreen(beeState.secondaryColor()) / 255.0f, (float)GeneralUtils.getBlue(beeState.secondaryColor()) / 255.0f, 1.0f);
            guiGraphics.blit(isBaby ? BEE_BABY_SECONDARY_ICON : BEE_SECONDARY_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (!beeState.beeEntity().hasStung()) {
                guiGraphics.blit(isBaby ? BEE_BABY_STINGER_ICON : BEE_STINGER_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            if (beeState.beeEntity().hasNectar()) {
                guiGraphics.blit(isBaby ? BEE_BABY_POLLEN_ICON : BEE_POLLEN_ICON, mainX + 3, mainY + 3, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
        float healthPercentage = Math.min(1.0f, beeState.beeEntity().getHealth() / beeState.beeEntity().getMaxHealth());
        int barColor = Mth.hsvToRgb((float)(healthPercentage / 3.0f), (float)1.0f, (float)1.0f);
        int barWidth = (int)Math.max(1.0f, 16.0f * healthPercentage);
        guiGraphics.fill(RenderType.guiOverlay(), mainX + 3, mainY + 19, mainX + 3 + barWidth, mainY + 18, barColor | 0xFF000000);
    }

    private static void renderReleaseButton(GuiGraphics guiGraphics, int mouseX, int mouseY, int mainX, int mainY) {
        if ((double)(mouseX - (mainX + 22)) >= 0.0 && (double)(mouseX - (mainX + 22)) < 11.0 && (double)(mouseY - mainY) >= 0.0 && (double)(mouseY - mainY) < 11.0) {
            guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX + 22, mainY, 33.0f, 33.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX + 22, mainY, 0.0f, 33.0f, 11, 11, 64, 64);
        }
    }

    private static void renderHealthButton(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hasHoneyBottle, int mainX, int mainY, BeeState beeState) {
        if (beeState.beeEntity().getHealth() == beeState.beeEntity().getMaxHealth()) {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 22, 11.0f, 11.0f, 11, 11, 64, 64);
        } else if (!hasHoneyBottle) {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 22, 22.0f, 11.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 22, 33.0f, 11.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 22, 0.0f, 11.0f, 11, 11, 64, 64);
        }
    }

    private static void renderStingerButton(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hasStingerItem, int mainX, int mainY, BeeState beeState) {
        if (!beeState.beeEntity().hasStung()) {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 22, 11.0f, 0.0f, 11, 11, 64, 64);
        } else if (!hasStingerItem) {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 22, 22.0f, 0.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - (mainX + 11)) >= 0.0 && (double)(mouseX - (mainX + 11)) < 11.0 && (double)(mouseY - (mainY + 22)) >= 0.0 && (double)(mouseY - (mainY + 22)) < 11.0) {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 22, 33.0f, 0.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 22, 0.0f, 0.0f, 11, 11, 64, 64);
        }
    }

    private static void renderGrowUpButton(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hasHoneyBottle, int mainX, int mainY, BeeState beeState) {
        if (!beeState.beeEntity().isBaby()) {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 33, 11.0f, 33.0f, 11, 11, 64, 64);
        } else if (!hasHoneyBottle) {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 33, 22.0f, 33.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - mainX) >= 0.0 && (double)(mouseX - mainX) < 11.0 && (double)(mouseY - (mainY + 33)) >= 0.0 && (double)(mouseY - (mainY + 33)) < 11.0) {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 33, 33.0f, 33.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.blit(GENERAL_ICONS, mainX, mainY + 33, 0.0f, 33.0f, 11, 11, 64, 64);
        }
    }

    private static void renderPollenButton(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hasPollenPuff, int mainX, int mainY, BeeState beeState) {
        if (!beeState.beeEntity().getType().is(BzTags.BUZZING_BRIEFCASE_CAN_POLLINATE)) {
            guiGraphics.blit(BEE_SLOT_BACKGROUND, mainX + 11, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
        } else if (beeState.beeEntity().hasNectar()) {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 33, 11.0f, 22.0f, 11, 11, 64, 64);
        } else if (!hasPollenPuff) {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 33, 22.0f, 22.0f, 11, 11, 64, 64);
        } else if ((double)(mouseX - (mainX + 11)) >= 0.0 && (double)(mouseX - (mainX + 11)) < 11.0 && (double)(mouseY - (mainY + 33)) >= 0.0 && (double)(mouseY - (mainY + 33)) < 11.0) {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 33, 33.0f, 22.0f, 11, 11, 64, 64);
        } else {
            guiGraphics.blit(GENERAL_ICONS, mainX + 11, mainY + 33, 0.0f, 22.0f, 11, 11, 64, 64);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int rowIndex = 0;
        int columnIndex = 0;
        for (int beeIndex = 0; beeIndex < 14 && beeIndex < this.BEE_INVENTORY.size(); ++beeIndex) {
            ItemStack playerPollenStack;
            ItemStack playerHoneyBottleStack;
            int honeyBottleSlotIndex;
            Bee bee = this.BEE_INVENTORY.get(beeIndex).beeEntity();
            int xOffset = BuzzingBriefcaseScreen.getXOffset(rowIndex);
            int yOffset = BuzzingBriefcaseScreen.getYOffset(columnIndex);
            int mainX = this.leftPos + xOffset;
            int mainY = this.topPos + yOffset;
            if (++rowIndex == 7) {
                rowIndex = 0;
                ++columnIndex;
            }
            if (mouseX - (double)(mainX + 22) >= 0.0 && mouseX - (double)(mainX + 22) < 11.0 && mouseY - (double)mainY >= 0.0 && mouseY - (double)mainY < 11.0) {
                this.sendButtonPressToMenu(beeIndex * 5 + 0);
                continue;
            }
            if (mouseX - (double)mainX >= 0.0 && mouseX - (double)mainX < 11.0 && mouseY - (double)(mainY + 22) >= 0.0 && mouseY - (double)(mainY + 22) < 11.0) {
                if (!(bee.getHealth() < bee.getMaxHealth())) continue;
                this.sendButtonPressToMenu(beeIndex * 5 + 1);
                honeyBottleSlotIndex = this.inventory.findSlotMatchingItem(Items.HONEY_BOTTLE.getDefaultInstance());
                if (honeyBottleSlotIndex == -1 || (playerHoneyBottleStack = this.inventory.getItem(honeyBottleSlotIndex)).isEmpty() || ((BuzzingBriefcaseMenu)this.menu).player.getAbilities().instabuild) continue;
                playerHoneyBottleStack.shrink(1);
                if (playerHoneyBottleStack.isEmpty()) {
                    this.inventory.add(honeyBottleSlotIndex, Items.GLASS_BOTTLE.getDefaultInstance());
                    continue;
                }
                this.inventory.add(Items.GLASS_BOTTLE.getDefaultInstance());
                continue;
            }
            if (mouseX - (double)(mainX + 11) >= 0.0 && mouseX - (double)(mainX + 11) < 11.0 && mouseY - (double)(mainY + 22) >= 0.0 && mouseY - (double)(mainY + 22) < 11.0) {
                ItemStack playerStingerStack;
                if (!bee.hasStung()) continue;
                this.sendButtonPressToMenu(beeIndex * 5 + 2);
                int stingerSlotIndex = this.inventory.findSlotMatchingItem(((Item)BzItems.BEE_STINGER.get()).getDefaultInstance());
                if (stingerSlotIndex == -1 || (playerStingerStack = this.inventory.getItem(stingerSlotIndex)).isEmpty()) continue;
                ((BeeEntityInvoker)bee).bumblezone$callSetHasStung(false);
                if (((BuzzingBriefcaseMenu)this.menu).player.getAbilities().instabuild) continue;
                playerStingerStack.shrink(1);
                continue;
            }
            if (mouseX - (double)mainX >= 0.0 && mouseX - (double)mainX < 11.0 && mouseY - (double)(mainY + 33) >= 0.0 && mouseY - (double)(mainY + 33) < 11.0) {
                if (!bee.isBaby()) continue;
                this.sendButtonPressToMenu(beeIndex * 5 + 3);
                honeyBottleSlotIndex = this.inventory.findSlotMatchingItem(Items.HONEY_BOTTLE.getDefaultInstance());
                if (honeyBottleSlotIndex == -1 || (playerHoneyBottleStack = this.inventory.getItem(honeyBottleSlotIndex)).isEmpty() || ((BuzzingBriefcaseMenu)this.menu).player.getAbilities().instabuild) continue;
                playerHoneyBottleStack.shrink(1);
                if (playerHoneyBottleStack.isEmpty()) {
                    this.inventory.add(honeyBottleSlotIndex, Items.GLASS_BOTTLE.getDefaultInstance());
                    continue;
                }
                this.inventory.add(Items.GLASS_BOTTLE.getDefaultInstance());
                continue;
            }
            if (!(mouseX - (double)(mainX + 11) >= 0.0) || !(mouseX - (double)(mainX + 11) < 11.0) || !(mouseY - (double)(mainY + 33) >= 0.0) || !(mouseY - (double)(mainY + 33) < 11.0) || bee.hasNectar() || !bee.getType().is(BzTags.BUZZING_BRIEFCASE_CAN_POLLINATE)) continue;
            this.sendButtonPressToMenu(beeIndex * 5 + 4);
            int pollenSlotIndex = this.inventory.findSlotMatchingItem(((Item)BzItems.POLLEN_PUFF.get()).getDefaultInstance());
            if (pollenSlotIndex == -1 || (playerPollenStack = this.inventory.getItem(pollenSlotIndex)).isEmpty() || ((BuzzingBriefcaseMenu)this.menu).player.getAbilities().instabuild) continue;
            playerPollenStack.shrink(1);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int left, int top, int button) {
        return false;
    }

    private void sendButtonPressToMenu(Integer sectionId) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
        this.minecraft.gameMode.handleInventoryButtonClick(((BuzzingBriefcaseMenu)this.menu).containerId, sectionId.intValue());
    }

    private int getTrueWidth() {
        return this.width;
    }

    private int getTrueHeight() {
        return this.height - 29;
    }

    private static int getXOffset(int rowIndex) {
        return -11 + rowIndex * 38;
    }

    private static int getYOffset(int columnIndex) {
        return 46 + columnIndex * 54;
    }

    private record BeeState(Bee beeEntity, int primaryColor, int secondaryColor) {
    }
}

