/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminState;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.Iterator;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EssenceBlockGreen
extends EssenceBlock {
    public static final MapCodec<EssenceBlockGreen> CODEC = Block.simpleCodec(EssenceBlockGreen::new);
    private static final int ROOTMIN_HEALTH = 30;
    private static final float STAGE_2_THRESHOLD = 0.75f;
    private static final float STAGE_3_THRESHOLD = 0.575f;
    private static final float STAGE_4_THRESHOLD = 0.3f;
    private static final float STAGE_5_THRESHOLD = 0.15f;

    public EssenceBlockGreen() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).strength(-1.0f, 3600000.8f).lightLevel(blockState -> 15).noLootTable().forceSolidOn().isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).isViewBlocking((blockState, blockGetter, blockPos) -> false).pushReaction(PushReaction.BLOCK));
    }

    public EssenceBlockGreen(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends EssenceBlockGreen> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence/green_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 6000;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.awardStat((ResourceLocation)BzStats.LIFE_EVENT_DEFEATED_RL.get());
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.green_essence_event", BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_6).setDarkenScreen(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"gameplay/rewards/green_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        BlockPos rootminPos = blockPos.offset(9, -3, 0);
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (eventEntitiesInArena.isEmpty()) {
            EssenceBlockGreen.spawnRootmin(serverLevel, essenceBlockEntity, rootminPos, eventEntitiesInArena);
            if (eventEntitiesInArena.size() == 1) {
                List frames = serverLevel.getEntitiesOfClass(HangingEntity.class, new AABB((double)((float)blockPos.getX() - (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() - (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() - (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f), (double)((float)blockPos.getX() + (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() + (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() + (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f)));
                frames.forEach(frame -> eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(frame.getUUID())));
            }
        }
        if (!eventEntitiesInArena.isEmpty()) {
            RootminEntity rootminEntity;
            EssenceBlockEntity.EventEntities eventEntity;
            Entity entity = null;
            Iterator<EssenceBlockEntity.EventEntities> iterator = eventEntitiesInArena.iterator();
            while (iterator.hasNext() && !((entity = serverLevel.getEntity((eventEntity = iterator.next()).uuid())) instanceof RootminEntity)) {
                entity = null;
            }
            float progress = essenceBlockEntity.getEventBar().getProgress();
            if (progress == 0.0f && entity == null) {
                EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
                return;
            }
            if (entity == null) {
                entity = EssenceBlockGreen.spawnRootmin(serverLevel, essenceBlockEntity, rootminPos, eventEntitiesInArena);
            }
            if (entity == null || !(entity instanceof RootminEntity) || !(rootminEntity = (RootminEntity)entity).getEssenceController().equals(essenceBlockEntity.getUUID())) {
                eventEntitiesInArena.remove(0);
                return;
            }
            int hitsLeft = Math.round(progress * 30.0f);
            RootminState rootminState = rootminEntity.getRootminPose();
            if (!rootminEntity.isDeadOrDying()) {
                rootminEntity.setHealth(hitsLeft);
            }
            float rootminHealthPercent = rootminEntity.getHealth() / 30.0f;
            if (rootminState == RootminState.SHOCK || rootminState == RootminState.ANGRY || rootminState == RootminState.CURSE) {
                if (rootminEntity.getLastHurtByMob() != null && rootminState == RootminState.SHOCK) {
                    if (rootminHealthPercent > 0.75f && rootminHealthPercent < 0.8f) {
                        rootminEntity.runAngry();
                    } else if (rootminHealthPercent > 0.575f && rootminHealthPercent < 0.625f) {
                        rootminEntity.runAngry();
                    } else if (rootminHealthPercent > 0.3f && rootminHealthPercent < 0.35000002f) {
                        rootminEntity.runCurse();
                    } else if (rootminHealthPercent <= 0.3f) {
                        rootminEntity.setRootminPose(RootminState.NONE);
                    }
                    --hitsLeft;
                    rootminEntity.setLastHurtByMob(null);
                }
            } else {
                boolean fire;
                Vec3 desiredRootminSpot = Vec3.atCenterOf((Vec3i)rootminPos).add(0.0, -0.5, 0.0);
                if (!rootminEntity.position().equals((Object)desiredRootminSpot)) {
                    Vec3 diff = desiredRootminSpot.subtract(rootminEntity.position());
                    if (diff.length() <= 3.0 && diff.length() > 0.05) {
                        Vec3 moveDirection = diff.scale(0.1);
                        rootminEntity.setDeltaMovement(moveDirection.x(), moveDirection.y(), moveDirection.z());
                    } else if (diff.length() > 3.0) {
                        rootminEntity.moveTo(desiredRootminSpot);
                    }
                }
                int interval = rootminHealthPercent > 0.3f && rootminHealthPercent <= 0.575f ? Mth.lerpInt((float)rootminHealthPercent, (int)15, (int)35) : Mth.lerpInt((float)rootminHealthPercent, (int)10, (int)45);
                boolean bl = fire = rootminEntity.tickCount % interval == 0;
                if (!fire && rootminHealthPercent <= 0.3f) {
                    boolean bl2 = fire = (rootminEntity.tickCount + 4) % interval == 0;
                    if (!fire && rootminHealthPercent <= 0.15f) {
                        boolean bl3 = fire = (rootminEntity.tickCount + 7) % interval == 0;
                    }
                }
                if (fire && !rootminEntity.isDeadOrDying()) {
                    BlockPos playerArea = blockPos.offset(-9, -3, 0);
                    List players = serverLevel.getEntitiesOfClass(Player.class, new AABB((double)(playerArea.getX() - 1), (double)(playerArea.getY() - 1), (double)(playerArea.getZ() - 1), (double)(playerArea.getX() + 2), (double)(playerArea.getY() + 3), (double)(playerArea.getZ() + 2)));
                    if (essenceBlockEntity.getEventTimer() < this.getEventTimeFrame() - 100 && !players.isEmpty()) {
                        boolean isHoming;
                        rootminEntity.setRootminShield(false);
                        boolean bl4 = isHoming = rootminHealthPercent > 0.3f && rootminHealthPercent <= 0.575f;
                        if (isHoming) {
                            RandomSource randomSource = rootminEntity.getRandom();
                            rootminEntity.lookAt(EntityAnchorArgument.Anchor.FEET, ((Player)players.getFirst()).position().add(randomSource.nextDouble() * 21.0 - 10.0, randomSource.nextDouble() * 21.0 - 10.0, randomSource.nextDouble() * 21.0 - 10.0));
                        } else {
                            rootminEntity.lookAt(EntityAnchorArgument.Anchor.FEET, ((Player)players.getFirst()).position());
                        }
                        if (rootminHealthPercent > 0.575f && rootminHealthPercent <= 0.75f) {
                            rootminEntity.runMultiShoot((LivingEntity)players.getFirst(), (float)Mth.lerp((double)rootminHealthPercent, (double)1.1, (double)0.8), 3);
                        } else {
                            rootminEntity.runShoot((LivingEntity)players.getFirst(), isHoming ? 0.8f : (float)Mth.lerp((double)rootminHealthPercent, (double)1.7, (double)0.9), isHoming);
                        }
                    } else {
                        rootminEntity.lookAt(EntityAnchorArgument.Anchor.FEET, Vec3.atLowerCornerOf((Vec3i)Direction.WEST.getNormal()).add(rootminEntity.position()));
                        rootminEntity.setRootminShield(true);
                    }
                }
            }
            float newProgress = (float)hitsLeft / 30.0f;
            essenceBlockEntity.getEventBar().setProgress(newProgress);
            essenceBlockEntity.setChanged();
        }
    }

    private static Entity spawnRootmin(ServerLevel serverLevel, EssenceBlockEntity essenceBlockEntity, BlockPos rootminPos, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        Entity entity = ((EntityType)BzEntities.ROOTMIN.get()).spawn(serverLevel, rootminPos, MobSpawnType.TRIGGERED);
        if (entity instanceof RootminEntity) {
            AttributeInstance knockbackResistanceAttribute;
            RootminEntity rootminEntity = (RootminEntity)entity;
            rootminEntity.addTag("the_bumblezone.green_essence_arena");
            rootminEntity.setRootminShield(true);
            rootminEntity.setEssenceController(essenceBlockEntity.getUUID());
            rootminEntity.setEssenceControllerBlockPos(essenceBlockEntity.getBlockPos());
            rootminEntity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.dimension());
            AttributeInstance livingEntityAttributeHealth = rootminEntity.getAttribute(Attributes.MAX_HEALTH);
            if (livingEntityAttributeHealth != null) {
                float extraHealth = 30.0f - rootminEntity.getMaxHealth();
                livingEntityAttributeHealth.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_health_boost"), (double)extraHealth, AttributeModifier.Operation.ADD_VALUE));
                rootminEntity.heal(extraHealth + rootminEntity.getMaxHealth());
            }
            if ((knockbackResistanceAttribute = rootminEntity.getAttribute(Attributes.KNOCKBACK_RESISTANCE)) != null) {
                knockbackResistanceAttribute.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_knockback_resistance_boost"), 0.25, AttributeModifier.Operation.ADD_VALUE));
            }
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, Vec3.atLowerCornerOf((Vec3i)Direction.SOUTH.getNormal()));
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.getUUID()));
        }
        return entity;
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.LIFE_EVENT.get()).getLocation(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.LIFE_EVENT.get()).getLocation(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

