/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.shiny.event;

import com.mojang.serialization.DynamicOps;
import cy.jdkdigital.shiny.ShinyMod;
import cy.jdkdigital.shiny.ShinyModConfig;
import cy.jdkdigital.shiny.common.datamap.SpawnChanceMap;
import cy.jdkdigital.shiny.common.entity.ShinyVillager;
import cy.jdkdigital.shiny.init.ModEntities;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;

@EventBusSubscriber(modid="shiny")
public class EventHandler {
    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinLevelEvent event) {
        Level level;
        if (!event.loadedFromDisk() && (level = event.getLevel()) instanceof ServerLevel) {
            String shinyEntityId;
            LivingEntity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof LivingEntity && (entity = (LivingEntity)level).getEncodeId() != null && !entity.getEncodeId().contains("shiny:") && (shinyEntityId = entity.getEncodeId().replace("minecraft:", "shiny:shiny_")).contains("shiny:")) {
                float chance;
                SpawnChanceMap chanceData = (SpawnChanceMap)entity.getType().builtInRegistryHolder().getData(ShinyMod.SPAWN_CHANCE_MAP);
                float f = chance = chanceData != null ? chanceData.spawnChance() : ((Double)ShinyModConfig.GENERAL.shinySpawnChance.get()).floatValue();
                if (BuiltInRegistries.ENTITY_TYPE.containsKey(ResourceLocation.parse((String)shinyEntityId)) && chance > serverLevel.getRandom().nextFloat()) {
                    EntityType shiny = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)shinyEntityId));
                    BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(event.getLevel().isClientSide ? LogicalSide.CLIENT : LogicalSide.SERVER);
                    executor.tell((Runnable)new TickTask(0, () -> {
                        Entity newEntity = shiny.create(serverLevel, null, entity.blockPosition(), MobSpawnType.CONVERSION, false, false);
                        if (newEntity != null) {
                            newEntity.load(entity.saveWithoutId(new CompoundTag()));
                            entity.discard();
                            event.setCanceled(true);
                            event.getLevel().addFreshEntity(newEntity);
                        }
                    }));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityConvert(LivingConversionEvent.Post event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ShinyVillager) {
            ShinyVillager villager = (ShinyVillager)livingEntity;
            livingEntity = event.getEntity().level();
            if (livingEntity instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)livingEntity;
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(level.isClientSide ? LogicalSide.CLIENT : LogicalSide.SERVER);
                executor.tell((Runnable)new TickTask(0, () -> {
                    event.getOutcome().discard();
                    ZombieVillager zombievillager = (ZombieVillager)villager.convertTo((EntityType)ModEntities.ZOMBIE_VILLAGER.get(), false);
                    zombievillager.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(zombievillager.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
                    zombievillager.setVillagerData(villager.getVillagerData());
                    zombievillager.setGossips((Tag)villager.getGossips().store((DynamicOps)NbtOps.INSTANCE));
                    zombievillager.setTradeOffers(villager.getOffers().copy());
                    zombievillager.setVillagerXp(villager.getVillagerXp());
                }));
            }
        }
    }
}

