/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.shiny.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.TropicalFishModelA;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.TropicalFish;

public class TropicalFishShinyLayer
extends RenderLayer<TropicalFish, ColorableHierarchicalModel<TropicalFish>> {
    private final TropicalFishModelA<TropicalFish> modelA;
    private final TropicalFishModelB<TropicalFish> modelB;
    private static final Map<TropicalFish.Pattern, RenderType> SHINE = new HashMap<TropicalFish.Pattern, RenderType>(){
        {
            this.put(TropicalFish.Pattern.KOB, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_a_pattern_1.png")));
            this.put(TropicalFish.Pattern.SUNSTREAK, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_a_pattern_2.png")));
            this.put(TropicalFish.Pattern.SNOOPER, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_a_pattern_3.png")));
            this.put(TropicalFish.Pattern.DASHER, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_a_pattern_4.png")));
            this.put(TropicalFish.Pattern.BRINELY, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_a_pattern_5.png")));
            this.put(TropicalFish.Pattern.SPOTTY, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_a_pattern_6.png")));
            this.put(TropicalFish.Pattern.FLOPPER, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_b_pattern_1.png")));
            this.put(TropicalFish.Pattern.STRIPEY, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_b_pattern_2.png")));
            this.put(TropicalFish.Pattern.GLITTER, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_b_pattern_3.png")));
            this.put(TropicalFish.Pattern.BLOCKFISH, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_b_pattern_4.png")));
            this.put(TropicalFish.Pattern.BETTY, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_b_pattern_5.png")));
            this.put(TropicalFish.Pattern.CLAYFISH, RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"shiny", (String)"textures/entity/fish/tropical_b_pattern_6.png")));
        }
    };

    public TropicalFishShinyLayer(RenderLayerParent<TropicalFish, ColorableHierarchicalModel<TropicalFish>> renderer, EntityModelSet modelSet) {
        super(renderer);
        this.modelA = new TropicalFishModelA(modelSet.bakeLayer(ModelLayers.TROPICAL_FISH_SMALL_PATTERN));
        this.modelB = new TropicalFishModelB(modelSet.bakeLayer(ModelLayers.TROPICAL_FISH_LARGE_PATTERN));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, TropicalFish entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!entity.isInvisible()) {
            VertexConsumer vertexconsumer = bufferSource.getBuffer(SHINE.get(entity.getVariant()));
            TropicalFishModelA<TropicalFish> entityModel = entity.getVariant().base().equals((Object)TropicalFish.Base.SMALL) ? this.modelA : this.modelB;
            ((ColorableHierarchicalModel)this.getParentModel()).copyPropertiesTo(entityModel);
            entityModel.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            entityModel.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            int color = entity.getPatternColor().getTextureDiffuseColor();
            entityModel.renderToBuffer(poseStack, vertexconsumer, 0xF00000, OverlayTexture.NO_OVERLAY, color);
        }
    }

    private static int getPatternVariant(int p_30065_) {
        return Math.min((p_30065_ & 0xFF00) >> 8, 5);
    }
}

