/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util.fakeplayer;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.ItemStackHandler;

public class DroneItemHandler
extends ItemStackHandler {
    private final IDrone holder;
    private int useableSlots;
    private ItemStack prevHeldStack = ItemStack.EMPTY;
    private boolean fakePlayerReady = false;

    public DroneItemHandler(IDrone holder, int useableSlots) {
        super(36);
        this.holder = holder;
        this.useableSlots = useableSlots;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot >= this.useableSlots) {
            return stack;
        }
        ItemStack res = super.insertItem(slot, stack, simulate);
        if (res.getCount() != stack.getCount() && !simulate) {
            this.copyItemToFakePlayer(slot);
        }
        return res;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= this.useableSlots) {
            return ItemStack.EMPTY;
        }
        ItemStack res = super.extractItem(slot, amount, simulate);
        if (!res.isEmpty() && !simulate) {
            this.copyItemToFakePlayer(slot);
        }
        return res;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (slot >= this.useableSlots) {
            return;
        }
        super.setStackInSlot(slot, stack);
        this.copyItemToFakePlayer(slot);
    }

    public int getSlots() {
        return Math.min(this.useableSlots, super.getSlots());
    }

    public void setUseableSlots(int useableSlots) {
        this.useableSlots = useableSlots;
    }

    protected boolean isFakePlayerReady() {
        return this.fakePlayerReady;
    }

    public void setFakePlayerReady() {
        if (!this.fakePlayerReady && !this.holder.getDroneLevel().isClientSide) {
            this.fakePlayerReady = true;
            for (int slot = 0; slot < this.getSlots(); ++slot) {
                this.copyItemToFakePlayer(slot);
            }
        }
    }

    public void copyFromFakePlayer() {
        if (!this.fakePlayerReady) {
            return;
        }
        Inventory fakeInv = this.holder.getFakePlayer().getInventory();
        for (int slot = 1; slot < fakeInv.getContainerSize(); ++slot) {
            ItemStack stack = fakeInv.getItem(slot);
            if (stack.isEmpty()) continue;
            if (slot < this.useableSlots) {
                super.setStackInSlot(slot, stack);
            } else {
                Vec3 v = this.holder.getDronePos();
                PneumaticCraftUtils.dropItemOnGround(stack, this.holder.getDroneLevel(), v.x(), v.y(), v.z());
            }
            fakeInv.setItem(slot, ItemStack.EMPTY);
        }
    }

    public void copyItemToFakePlayer(int slot) {
        if (!this.fakePlayerReady) {
            return;
        }
        FakePlayer fakePlayer = this.holder.getFakePlayer();
        if (slot >= fakePlayer.getInventory().items.size()) {
            return;
        }
        ItemStack newStack = this.getStackInSlot(slot);
        fakePlayer.getInventory().items.set(slot, (Object)newStack);
        if (slot == fakePlayer.getInventory().selected) {
            fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, newStack);
            if (!this.prevHeldStack.isEmpty()) {
                this.prevHeldStack.forEachModifier(EquipmentSlot.MAINHAND, (holder, modifier) -> {
                    AttributeInstance instance = fakePlayer.getAttributes().getInstance(holder);
                    if (instance != null) {
                        instance.removeModifier(modifier);
                    }
                });
            }
            if (!newStack.isEmpty()) {
                fakePlayer.getMainHandItem().forEachModifier(EquipmentSlot.MAINHAND, (holder, modifier) -> {
                    AttributeInstance instance = fakePlayer.getAttributes().getInstance(holder);
                    if (instance != null) {
                        instance.removeModifier(modifier.id());
                        instance.addTransientModifier(modifier);
                    }
                });
            }
            this.prevHeldStack = newStack.copy();
        }
    }
}

