/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.mojang.blaze3d.platform.InputConstants;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import me.desht.pneumaticcraft.api.crafting.recipe.HeatPropertiesRecipe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.heat.BlockHeatProperties;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.thirdparty.jei.AbstractPNCCategory;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.RecipeTypes;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class JEIBlockHeatPropertiesCategory
extends AbstractPNCCategory<HeatPropertiesRecipe> {
    private final IDrawable hotArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 0, 31, 18);
    private final IDrawable coldArea = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 18, 31, 18);
    private final IDrawable air = JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 150, 36, 16, 16);
    private static final ScreenRectangle INPUT_AREA = new ScreenRectangle(65, 44, 18, 18);
    private static final ScreenRectangle COLD_AREA = new ScreenRectangle(5, 44, 18, 18);
    private static final ScreenRectangle HOT_AREA = new ScreenRectangle(125, 44, 18, 18);
    private static final ScreenRectangle[] OUTPUT_AREAS = new ScreenRectangle[]{COLD_AREA, HOT_AREA};

    public JEIBlockHeatPropertiesCategory() {
        super(RecipeTypes.HEAT_PROPERTIES, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.title.heatProperties", new Object[0]), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().createDrawable(Textures.GUI_JEI_HEAT_PROPERTIES, 0, 0, 146, 73), (IDrawable)JEIBlockHeatPropertiesCategory.guiHelper().drawableBuilder(Textures.JEI_THERMOMETER, 0, 0, 16, 16).setTextureSize(16, 16).build());
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, HeatPropertiesRecipe recipe, IFocusGroup focuses) {
        builder.addInputHandler((IJeiInputHandler)new ClickHandler(INPUT_AREA, recipe, HeatPropertiesRecipe::getBlock));
        builder.addInputHandler((IJeiInputHandler)new ClickHandler(COLD_AREA, recipe, r -> r.getTransformCold().map(BlockBehaviour.BlockStateBase::getBlock).orElse(null)));
        builder.addInputHandler((IJeiInputHandler)new ClickHandler(HOT_AREA, recipe, r -> r.getTransformHot().map(BlockBehaviour.BlockStateBase::getBlock).orElse(null)));
    }

    public static List<HeatPropertiesRecipe> getAllRecipes() {
        return BlockHeatProperties.getInstance().getAllEntries((Level)Minecraft.getInstance().level).stream().filter(r -> r.getBlock() instanceof LiquidBlock || !new ItemStack((ItemLike)r.getBlock()).isEmpty()).sorted(Comparator.comparingInt(HeatPropertiesRecipe::getTemperature).thenComparing(o -> o.getInputDisplayName().getString())).toList();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HeatPropertiesRecipe recipe, IFocusGroup focuses) {
        this.setInputIngredient(builder, recipe);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        this.collectOutputs(recipe.getTransformCold().orElse(null), items, fluids);
        this.collectOutputs(recipe.getTransformHot().orElse(null), items, fluids);
        for (int idx = 0; idx < 2; ++idx) {
            if (!((FluidStack)fluids.get(idx)).isEmpty()) {
                builder.addSlot(RecipeIngredientRole.OUTPUT, OUTPUT_AREAS[idx].position().x() + 2, OUTPUT_AREAS[idx].position().y() - 1).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)((FluidStack)fluids.get(idx)));
                continue;
            }
            if (((ItemStack)items.get(idx)).isEmpty()) continue;
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack((ItemStack)items.get(idx));
        }
    }

    private void collectOutputs(BlockState state, List<ItemStack> items, List<FluidStack> fluids) {
        if (state != null) {
            Block block = state.getBlock();
            if (block instanceof LiquidBlock) {
                int level;
                LiquidBlock l = (LiquidBlock)block;
                int n = level = state.hasProperty((Property)LiquidBlock.LEVEL) ? (Integer)state.getValue((Property)LiquidBlock.LEVEL) : 15;
                if (level == 0) {
                    level = 15;
                }
                FluidStack stack = new FluidStack((Fluid)l.fluid, 1000 * level / 15);
                fluids.add(stack);
                items.add(new ItemStack((ItemLike)Blocks.BARRIER));
            } else {
                ItemStack stack = new ItemStack((ItemLike)state.getBlock());
                items.add(stack.isEmpty() ? new ItemStack((ItemLike)Blocks.BARRIER) : stack);
                fluids.add(FluidStack.EMPTY);
            }
        } else {
            items.add(new ItemStack((ItemLike)Blocks.BARRIER));
            fluids.add(FluidStack.EMPTY);
        }
    }

    private void setInputIngredient(IRecipeLayoutBuilder builder, HeatPropertiesRecipe recipe) {
        Block block = recipe.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock l = (LiquidBlock)block;
            FluidStack stack = new FluidStack((Fluid)l.fluid, 1000);
            builder.addSlot(RecipeIngredientRole.INPUT, INPUT_AREA.position().x() + 2, INPUT_AREA.position().y() - 1).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)stack);
        } else {
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)block));
        }
    }

    public void draw(HeatPropertiesRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Font fontRenderer = Minecraft.getInstance().font;
        Objects.requireNonNull(fontRenderer);
        int h = 9;
        MutableComponent desc = recipe.getDescriptionKey().isEmpty() ? Component.empty() : Component.literal((String)(" (" + I18n.get((String)recipe.getDescriptionKey(), (Object[])new Object[0]) + ")"));
        graphics.drawString(fontRenderer, (Component)recipe.getInputDisplayName().copy().append((Component)desc), 0, 0, 0x4040A0, false);
        MutableComponent temp = PneumaticCraftUtils.xlate("pneumaticcraft.waila.temperature", new Object[0]).append((Component)Component.literal((String)(recipe.getTemperature() - 273 + "\u00b0C")));
        graphics.drawString(fontRenderer, (Component)temp, 0, h * 2, 0x404040, false);
        recipe.getThermalResistance().ifPresent(resistance -> {
            String res = NumberFormat.getNumberInstance(Locale.getDefault()).format(resistance);
            graphics.drawString(fontRenderer, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.thermalResistance", new Object[0]).append(res), 0, h * 3, 0x404040, false);
        });
        boolean showCapacity = false;
        if (recipe.getTransformCold().isPresent()) {
            this.coldArea.draw(graphics, INPUT_AREA.position().x() - this.coldArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        if (recipe.getTransformHot().isPresent()) {
            this.hotArea.draw(graphics, HOT_AREA.position().x() - this.hotArea.getWidth() - 5, 42);
            showCapacity = true;
        }
        this.renderBlock(recipe.getBlockState(), graphics, INPUT_AREA.position().x() + 9, INPUT_AREA.position().y() + 1);
        recipe.getTransformCold().ifPresent(state -> this.renderBlock((BlockState)state, graphics, COLD_AREA.position().x() + 9, COLD_AREA.position().y() + 1));
        recipe.getTransformHot().ifPresent(state -> this.renderBlock((BlockState)state, graphics, HOT_AREA.position().x() + 9, HOT_AREA.position().y() + 1));
        if (showCapacity) {
            recipe.getHeatCapacity().ifPresent(heatCapacity -> graphics.drawString(fontRenderer, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.heatCapacity", NumberFormat.getNumberInstance(Locale.getDefault()).format(heatCapacity)), 0, this.getBackground().getHeight() - h, 0x404040, false));
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, HeatPropertiesRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (INPUT_AREA.containsPoint((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getBlock(), tooltip);
        } else if (recipe.getTransformCold().isPresent() && COLD_AREA.containsPoint((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformCold().get().getBlock(), tooltip);
        } else if (recipe.getTransformHot().isPresent() && HOT_AREA.containsPoint((int)mouseX, (int)mouseY)) {
            this.addTooltip(recipe.getTransformHot().get().getBlock(), tooltip);
        } else if (mouseY > 20.0 && mouseY < 30.0) {
            tooltip.add((FormattedText)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.thermalResistance", new Object[0]));
        } else if (recipe.getHeatCapacity().isPresent() && mouseY > 62.0) {
            tooltip.add((FormattedText)PneumaticCraftUtils.xlate("pneumaticcraft.gui.jei.tooltip.heatCapacity", new Object[0]));
        }
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    private void addTooltip(Block block, ITooltipBuilder tooltip) {
        ItemStack stack = new ItemStack((ItemLike)block);
        tooltip.add((FormattedText)stack.getHoverName());
        ArrayList list = new ArrayList();
        stack.getItem().appendHoverText(stack, Item.TooltipContext.of((Level)ClientUtils.getClientLevel()), list, (TooltipFlag)(ClientUtils.hasShiftDown() ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
        tooltip.addAll(list);
        if (Minecraft.getInstance().options.advancedItemTooltips) {
            String regName = PneumaticCraftUtils.getRegistryName(stack.getItem()).map(ResourceLocation::toString).orElse("?");
            tooltip.add((FormattedText)Component.literal((String)regName).withStyle(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((FormattedText)Component.literal((String)ModNameCache.getModName(stack.getItem())).withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
    }

    private void renderBlock(BlockState state, GuiGraphics graphics, int x, int y) {
        if (state != null) {
            if (state.getBlock() == Blocks.AIR) {
                this.air.draw(graphics, x - 8, y - 2);
            } else {
                float rot = ClientUtils.getClientLevel().getGameTime() % 360L;
                GuiUtils.renderBlockInGui(graphics, state, x, y, 100.0f, rot, 15.0f);
            }
        }
    }

    public record ClickHandler(ScreenRectangle area, HeatPropertiesRecipe recipe, Function<HeatPropertiesRecipe, Block> blockGetter) implements IJeiInputHandler
    {
        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
            int mouseButton;
            IFocus<?> focus;
            if (input.getKey().getType() == InputConstants.Type.MOUSE && (focus = ClickHandler.makeFocus(this.blockGetter.apply(this.recipe), (mouseButton = input.getKey().getValue()) == 0 ? RecipeIngredientRole.OUTPUT : RecipeIngredientRole.INPUT)) != null) {
                if (!input.isSimulate()) {
                    JEIPlugin.recipesGui.show(focus);
                }
                return true;
            }
            return false;
        }

        private static IFocus<?> makeFocus(Block block, RecipeIngredientRole mode) {
            return block == null || block == Blocks.AIR || block instanceof LiquidBlock ? null : JEIPlugin.jeiHelpers.getFocusFactory().createFocus(mode, (IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)block));
        }
    }
}

