/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes.special;

import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.recipes.special.WrappedShapedRecipe;
import me.desht.pneumaticcraft.common.registry.ModRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;
import org.jline.utils.Log;

public class CompressorUpgradeCrafting
extends WrappedShapedRecipe {
    private static final Supplier<List<Item>> COMPRESSORS = Suppliers.memoize(() -> List.of(CompressorUpgradeCrafting.getItem("advanced_air_compressor"), CompressorUpgradeCrafting.getItem("advanced_liquid_compressor"), CompressorUpgradeCrafting.getItem("air_compressor"), CompressorUpgradeCrafting.getItem("liquid_compressor")));

    public CompressorUpgradeCrafting(ShapedRecipe wrapped) {
        super(wrapped);
    }

    private static Item getItem(String id) {
        return (Item)BuiltInRegistries.ITEM.get(PneumaticRegistry.RL(id));
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipeSerializers.COMPRESSOR_UPGRADE_CRAFTING.get();
    }

    @NotNull
    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider registryAccess) {
        ItemStack result = this.wrapped.assemble(inv, registryAccess);
        int index = this.getMainItem(inv);
        if (index == -1) {
            Log.warn((Object[])new Object[]{"Just crafted a PNC Compressor upgrade recipe but couldn't find a compressor in the input!"});
            return ItemStack.EMPTY;
        }
        ItemStack input = inv.getItem(index);
        CustomData data = (CustomData)input.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data != null && !data.isEmpty()) {
            result.set(DataComponents.BLOCK_ENTITY_DATA, (Object)data);
        }
        return result;
    }

    private int getMainItem(CraftingInput container) {
        int i;
        boolean matchFound = false;
        for (i = 0; i < container.size(); ++i) {
            ItemStack item = container.getItem(i);
            if (!COMPRESSORS.get().contains(item.getItem())) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            return -1;
        }
        return i;
    }

    public static class Serializer
    implements RecipeSerializer<CompressorUpgradeCrafting> {
        public static final MapCodec<CompressorUpgradeCrafting> CODEC = ShapedRecipe.Serializer.CODEC.xmap(CompressorUpgradeCrafting::new, WrappedShapedRecipe::wrapped);
        public static final StreamCodec<RegistryFriendlyByteBuf, CompressorUpgradeCrafting> STREAM_CODEC = ShapedRecipe.Serializer.STREAM_CODEC.map(CompressorUpgradeCrafting::new, WrappedShapedRecipe::wrapped);

        public MapCodec<CompressorUpgradeCrafting> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CompressorUpgradeCrafting> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

