/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;

public class VanillaRecipeCache<T extends RecipeType<R>, R extends Recipe<C>, C extends RecipeInput> {
    public static final VanillaRecipeCache<RecipeType<CraftingRecipe>, CraftingRecipe, CraftingInput> CRAFTING = new VanillaRecipeCache(RecipeType.CRAFTING, true);
    public static final VanillaRecipeCache<RecipeType<SmeltingRecipe>, SmeltingRecipe, SingleRecipeInput> SMELTING = new VanillaRecipeCache(RecipeType.SMELTING, false);
    private static final int MAX_CACHE_SIZE = 1024;
    private final T type;
    private final boolean checkComponents;
    private final Int2ObjectLinkedOpenHashMap<Optional<R>> recipeCache = new Int2ObjectLinkedOpenHashMap(1024, 0.25f);

    private VanillaRecipeCache(T type, boolean checkComponents) {
        this.type = type;
        this.checkComponents = checkComponents;
    }

    static void clearAll() {
        CRAFTING.clear();
        SMELTING.clear();
    }

    public Optional<R> getCachedRecipe(Level world, C inv) {
        int key = this.makeKey(inv);
        if (this.recipeCache.containsKey(key)) {
            return (Optional)this.recipeCache.getAndMoveToFirst(key);
        }
        Optional<Recipe> newRecipe = world.getRecipeManager().getRecipeFor(this.type, inv, world).map(RecipeHolder::value);
        if (this.recipeCache.size() == 1024) {
            this.recipeCache.removeLast();
        }
        this.recipeCache.put(key, newRecipe);
        return newRecipe;
    }

    private void clear() {
        this.recipeCache.clear();
    }

    private int makeKey(C inv) {
        IntArrayList c = new IntArrayList();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            c.add(this.checkComponents ? ItemStack.hashItemAndComponents((ItemStack)stack) : stack.getItem().hashCode());
        }
        return c.hashCode();
    }
}

