/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.pneumatic_armor;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.api.pneumatic_armor.BuiltinArmorUpgrades;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import org.apache.commons.lang3.Validate;

public enum ArmorUpgradeRegistry {
    INSTANCE;

    private final List<List<IArmorUpgradeHandler<?>>> upgradeHandlers;
    private final Map<ResourceLocation, IArmorUpgradeHandler<?>> byID = new ConcurrentHashMap();
    private boolean isFrozen = false;
    private final List<String> knownUpgradeIds = new ArrayList<String>();
    public static final EquipmentSlot[] ARMOR_SLOTS;

    public static ArmorUpgradeRegistry getInstance() {
        return INSTANCE;
    }

    private ArmorUpgradeRegistry() {
        ImmutableList.Builder b = ImmutableList.builder();
        for (int i = 0; i < 4; ++i) {
            b.add(new ArrayList());
        }
        this.upgradeHandlers = b.build();
    }

    public synchronized <T extends IArmorUpgradeHandler<?>> T registerUpgradeHandler(T handler) {
        if (this.isFrozen) {
            throw new IllegalStateException("armor upgrade registry is frozen!");
        }
        Validate.isTrue((!this.byID.containsKey(handler.getID()) ? 1 : 0) != 0, (String)("handler " + String.valueOf(handler.getID()) + " is already registered!"), (Object[])new Object[0]);
        this.byID.put(handler.getID(), handler);
        return handler;
    }

    public List<IArmorUpgradeHandler<?>> getHandlersForSlot(EquipmentSlot slotType) {
        if (!this.isFrozen) {
            throw new IllegalStateException("armor upgrade registry is not frozen yet!");
        }
        return this.upgradeHandlers.get(slotType.getIndex());
    }

    public IArmorUpgradeHandler<?> getUpgradeEntry(ResourceLocation upgradeID) {
        if (upgradeID == null) {
            return null;
        }
        return this.byID.get(upgradeID);
    }

    public Stream<IArmorUpgradeHandler<?>> entries() {
        return this.byID.values().stream();
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void freeze() {
        if (this.isFrozen) {
            throw new IllegalStateException("armor upgrade registry is already frozen!");
        }
        this.byID.values().stream().sorted((o1, o2) -> this.compareHandlerID(o1.getID(), o2.getID())).forEach(this::addHandlerToList);
        this.isFrozen = true;
    }

    public List<String> getKnownUpgradeIds() {
        if (!this.isFrozen()) {
            return List.of();
        }
        if (this.knownUpgradeIds.isEmpty()) {
            for (EquipmentSlot slot : ARMOR_SLOTS) {
                ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot).forEach(u -> this.knownUpgradeIds.add(u.getID().toString()));
            }
            this.knownUpgradeIds.sort(String::compareTo);
        }
        return Collections.unmodifiableList(this.knownUpgradeIds);
    }

    private int compareHandlerID(ResourceLocation id1, ResourceLocation id2) {
        if (id1.equals((Object)BuiltinArmorUpgrades.CORE_COMPONENTS)) {
            return -1;
        }
        if (id1.getNamespace().equals("pneumaticcraft") && !id2.getNamespace().equals("pneumaticcraft")) {
            return -1;
        }
        return id1.compareTo(id2);
    }

    private void addHandlerToList(IArmorUpgradeHandler<?> handler) {
        List<IArmorUpgradeHandler<?>> handlerList = this.upgradeHandlers.get(handler.getEquipmentSlot().getIndex());
        handler.setIndex(handlerList.size());
        handlerList.add(handler);
    }

    static {
        ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    }
}

