/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketMinigunStop(ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketMinigunStop> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("packetminigunstop"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketMinigunStop> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, PacketMinigunStop::stack, PacketMinigunStop::new);

    public CustomPacketPayload.Type<PacketMinigunStop> type() {
        return TYPE;
    }

    public static void handle(PacketMinigunStop message, IPayloadContext ctx) {
        ItemStack stack = message.stack();
        Item item = stack.getItem();
        if (item instanceof MinigunItem) {
            MinigunItem mgItem = (MinigunItem)item;
            Minigun minigun = mgItem.getMinigun(stack, ctx.player());
            minigun.setMinigunSpeed(0.0f);
            minigun.setMinigunActivated(false);
            minigun.setMinigunTriggerTimeOut(0);
            ctx.player().playSound((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 1.0f);
        }
    }
}

