/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.common.network.DronePacket;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketAphorismTileUpdate;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.network.PacketClearRecipeCache;
import me.desht.pneumaticcraft.common.network.PacketDebugBlock;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketJetBootsActivate;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.network.PacketMinigunStop;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketNotifyBlockUpdate;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketPneumaticKick;
import me.desht.pneumaticcraft.common.network.PacketProgrammerSync;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.network.PacketShiftScrollWheel;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSpawnIndicatorParticles;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticleTrail;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.network.PacketSyncClassifyFilter;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneProgWidgets;
import me.desht.pneumaticcraft.common.network.PacketSyncEntityHacks;
import me.desht.pneumaticcraft.common.network.PacketSyncHackSimulationUpdate;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToClient;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToClient;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketTeleportCommand;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.network.PacketTubeModuleColor;
import me.desht.pneumaticcraft.common.network.PacketUpdateAirGrateModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorColors;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import me.desht.pneumaticcraft.common.network.PacketUpdateGPSAreaTool;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticsModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateRemoteLayout;
import me.desht.pneumaticcraft.common.network.PacketUpdateSearchItem;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.network.TubeModulePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="pneumaticcraft", bus=EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("pneumaticcraft").versioned(PROTOCOL_VERSION);
        registrar.playToServer(PacketChangeGPSToolCoordinate.TYPE, PacketChangeGPSToolCoordinate.STREAM_CODEC, PacketChangeGPSToolCoordinate::handle);
        registrar.playToServer(PacketUpdateGPSAreaTool.TYPE, PacketUpdateGPSAreaTool.STREAM_CODEC, PacketUpdateGPSAreaTool::handle);
        registrar.playToServer(PacketDescriptionPacketRequest.TYPE, PacketDescriptionPacketRequest.STREAM_CODEC, PacketDescriptionPacketRequest::handle);
        registrar.playToServer(PacketGuiButton.TYPE, PacketGuiButton.STREAM_CODEC, PacketGuiButton::handle);
        registrar.playToServer(PacketUpdateTextfield.TYPE, PacketUpdateTextfield.STREAM_CODEC, PacketUpdateTextfield::handle);
        registrar.playToServer(PacketUpdateSearchItem.TYPE, PacketUpdateSearchItem.STREAM_CODEC, PacketUpdateSearchItem::handle);
        registrar.playToServer(PacketUpdateRemoteLayout.TYPE, PacketUpdateRemoteLayout.STREAM_CODEC, PacketUpdateRemoteLayout::handle);
        registrar.playToServer(PacketUpdateMicromissileSettings.TYPE, PacketUpdateMicromissileSettings.STREAM_CODEC, PacketUpdateMicromissileSettings::handle);
        registrar.playToServer(PacketModWrenchBlock.TYPE, PacketModWrenchBlock.STREAM_CODEC, PacketModWrenchBlock::handle);
        registrar.playToServer(PacketLeftClickEmpty.TYPE, PacketLeftClickEmpty.STREAM_CODEC, PacketLeftClickEmpty::handle);
        registrar.playToServer(PacketShiftScrollWheel.TYPE, PacketShiftScrollWheel.STREAM_CODEC, PacketShiftScrollWheel::handle);
        registrar.playToServer(PacketSyncClassifyFilter.TYPE, PacketSyncClassifyFilter.STREAM_CODEC, PacketSyncClassifyFilter::handle);
        registrar.playToServer(PacketTeleportCommand.TYPE, PacketTeleportCommand.STREAM_CODEC, PacketTeleportCommand::handle);
        registrar.playToClient(PacketDescription.TYPE, PacketDescription.STREAM_CODEC, PacketDescription::handle);
        registrar.playToClient(PacketPlaySound.TYPE, PacketPlaySound.STREAM_CODEC, PacketPlaySound::handle);
        registrar.playToClient(PacketSendNBTPacket.TYPE, PacketSendNBTPacket.STREAM_CODEC, PacketSendNBTPacket::handle);
        registrar.playToClient(PacketSpawnParticle.TYPE, PacketSpawnParticle.STREAM_CODEC, PacketSpawnParticle::handle);
        registrar.playToClient(PacketSpawnParticleTrail.TYPE, PacketSpawnParticleTrail.STREAM_CODEC, PacketSpawnParticleTrail::handle);
        registrar.playToClient(PacketSpawnIndicatorParticles.TYPE, PacketSpawnIndicatorParticles.STREAM_CODEC, PacketSpawnIndicatorParticles::handle);
        registrar.playToClient(PacketUpdatePressureBlock.TYPE, PacketUpdatePressureBlock.STREAM_CODEC, PacketUpdatePressureBlock::handle);
        registrar.playToClient(PacketUpdateGui.TYPE, PacketUpdateGui.STREAM_CODEC, PacketUpdateGui::handle);
        registrar.playToClient(PacketServerTickTime.TYPE, PacketServerTickTime.STREAM_CODEC, PacketServerTickTime::handle);
        registrar.playToClient(PacketSpawnRing.TYPE, PacketSpawnRing.STREAM_CODEC, PacketSpawnRing::handle);
        registrar.playToClient(PacketShowArea.TYPE, PacketShowArea.STREAM_CODEC, PacketShowArea::handle);
        registrar.playToClient(PacketSetEntityMotion.TYPE, PacketSetEntityMotion.STREAM_CODEC, PacketSetEntityMotion::handle);
        registrar.playToClient(PacketDebugBlock.TYPE, PacketDebugBlock.STREAM_CODEC, PacketDebugBlock::handle);
        registrar.playToClient(PacketPlayMovingSound.TYPE, PacketPlayMovingSound.STREAM_CODEC, PacketPlayMovingSound::handle);
        registrar.playToClient(PacketNotifyBlockUpdate.TYPE, PacketNotifyBlockUpdate.STREAM_CODEC, PacketNotifyBlockUpdate::handle);
        registrar.playToClient(PacketMinigunStop.TYPE, PacketMinigunStop.STREAM_CODEC, PacketMinigunStop::handle);
        registrar.playToClient(PacketClearRecipeCache.TYPE, PacketClearRecipeCache.STREAM_CODEC, PacketClearRecipeCache::handle);
        registrar.playBidirectional(PacketAphorismTileUpdate.TYPE, PacketAphorismTileUpdate.STREAM_CODEC, PacketAphorismTileUpdate::handle);
        registrar.playBidirectional(PacketSetGlobalVariable.TYPE, PacketSetGlobalVariable.STREAM_CODEC, PacketSetGlobalVariable::handle);
        registrar.playBidirectional(PacketSyncSemiblock.TYPE, PacketSyncSemiblock.STREAM_CODEC, PacketSyncSemiblock::handle);
        registrar.playBidirectional(PacketSyncSmartChest.TYPE, PacketSyncSmartChest.STREAM_CODEC, PacketSyncSmartChest::handle);
        registrar.playToServer(PacketUpdatePressureModule.TYPE, PacketUpdatePressureModule.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playToServer(PacketUpdateAirGrateModule.TYPE, PacketUpdateAirGrateModule.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playToServer(PacketTubeModuleColor.TYPE, PacketTubeModuleColor.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playToServer(PacketSyncRedstoneModuleToServer.TYPE, PacketSyncRedstoneModuleToServer.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playToClient(PacketUpdateLogisticsModule.TYPE, PacketUpdateLogisticsModule.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playToClient(PacketSyncRedstoneModuleToClient.TYPE, PacketSyncRedstoneModuleToClient.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playToClient(PacketSyncThermostatModuleToClient.TYPE, PacketSyncThermostatModuleToClient.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playToServer(PacketSyncThermostatModuleToServer.TYPE, PacketSyncThermostatModuleToServer.STREAM_CODEC, TubeModulePacket::handle);
        registrar.playBidirectional(PacketSyncAmadronOffers.TYPE, PacketSyncAmadronOffers.STREAM_CODEC, PacketSyncAmadronOffers::handle);
        registrar.playToClient(PacketAmadronOrderResponse.TYPE, PacketAmadronOrderResponse.STREAM_CODEC, PacketAmadronOrderResponse::handle);
        registrar.playToServer(PacketAmadronOrderUpdate.TYPE, PacketAmadronOrderUpdate.STREAM_CODEC, PacketAmadronOrderUpdate::handle);
        registrar.playToClient(PacketAmadronStockUpdate.TYPE, PacketAmadronStockUpdate.STREAM_CODEC, PacketAmadronStockUpdate::handle);
        registrar.playToClient(PacketAmadronTradeNotifyDeal.TYPE, PacketAmadronTradeNotifyDeal.STREAM_CODEC, PacketAmadronTradeNotifyDeal::handle);
        registrar.playToClient(PacketAmadronTradeRemoved.TYPE, PacketAmadronTradeRemoved.STREAM_CODEC, PacketAmadronTradeRemoved::handle);
        registrar.playBidirectional(PacketAmadronTradeAddCustom.TYPE, PacketAmadronTradeAddCustom.STREAM_CODEC, PacketAmadronTradeAddCustom::handle);
        registrar.playBidirectional(PacketHackingBlockStart.TYPE, PacketHackingBlockStart.STREAM_CODEC, PacketHackingBlockStart::handle);
        registrar.playBidirectional(PacketHackingEntityStart.TYPE, PacketHackingEntityStart.STREAM_CODEC, PacketHackingEntityStart::handle);
        registrar.playToClient(PacketHackingBlockFinish.TYPE, PacketHackingBlockFinish.STREAM_CODEC, PacketHackingBlockFinish::handle);
        registrar.playToClient(PacketHackingEntityFinish.TYPE, PacketHackingEntityFinish.STREAM_CODEC, PacketHackingEntityFinish::handle);
        registrar.playToClient(PacketSyncHackSimulationUpdate.TYPE, PacketSyncHackSimulationUpdate.STREAM_CODEC, PacketSyncHackSimulationUpdate::handle);
        registrar.playToClient(PacketSyncEntityHacks.TYPE, PacketSyncEntityHacks.STREAM_CODEC, PacketSyncEntityHacks::handle);
        registrar.playBidirectional(PacketToggleArmorFeature.TYPE, PacketToggleArmorFeature.STREAM_CODEC, PacketToggleArmorFeature::handle);
        registrar.playToServer(PacketToggleArmorFeatureBulk.TYPE, PacketToggleArmorFeatureBulk.STREAM_CODEC, PacketToggleArmorFeatureBulk::handle);
        registrar.playToServer(PacketPneumaticKick.TYPE, PacketPneumaticKick.STREAM_CODEC, PacketPneumaticKick::handle);
        registrar.playToServer(PacketJetBootsActivate.TYPE, PacketJetBootsActivate.STREAM_CODEC, PacketJetBootsActivate::handle);
        registrar.playToServer(PacketChestplateLauncher.TYPE, PacketChestplateLauncher.STREAM_CODEC, PacketChestplateLauncher::handle);
        registrar.playToServer(PacketUpdateArmorColors.TYPE, PacketUpdateArmorColors.STREAM_CODEC, PacketUpdateArmorColors::handle);
        registrar.playToServer(PacketUpdateArmorExtraData.TYPE, PacketUpdateArmorExtraData.STREAM_CODEC, PacketUpdateArmorExtraData::handle);
        registrar.playToClient(PacketJetBootsStateSync.TYPE, PacketJetBootsStateSync.STREAM_CODEC, PacketJetBootsStateSync::handle);
        registrar.playToClient(PacketSendArmorHUDMessage.TYPE, PacketSendArmorHUDMessage.STREAM_CODEC, PacketSendArmorHUDMessage::handle);
        registrar.playToServer(PacketUpdateDebuggingDrone.TYPE, PacketUpdateDebuggingDrone.STREAM_CODEC, DronePacket::handle);
        registrar.playToClient(PacketSendDroneDebugEntry.TYPE, PacketSendDroneDebugEntry.STREAM_CODEC, DronePacket::handle);
        registrar.playToClient(PacketSyncDroneProgWidgets.TYPE, PacketSyncDroneProgWidgets.STREAM_CODEC, DronePacket::handle);
        registrar.playToClient(PacketShowWireframe.TYPE, PacketShowWireframe.STREAM_CODEC, PacketShowWireframe::handle);
        registrar.playBidirectional(PacketProgrammerSync.TYPE, PacketProgrammerSync.STREAM_CODEC, PacketProgrammerSync::handle);
    }

    public static void sendToAll(CustomPacketPayload message) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(CustomPacketPayload message, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllTracking(CustomPacketPayload message, Entity entity) {
        PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllTracking(CustomPacketPayload message, Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(pos), (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToAllTracking(CustomPacketPayload message, BlockEntity te) {
        if (te.getLevel() != null) {
            NetworkHandler.sendToAllTracking(message, te.getLevel(), te.getBlockPos());
        }
    }

    public static void sendToDimension(CustomPacketPayload message, ServerLevel level) {
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToServer(CustomPacketPayload message) {
        PacketDistributor.sendToServer((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendNonLocal(CustomPacketPayload packet) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            if (server.isDedicatedServer()) {
                NetworkHandler.sendToAll(packet);
            } else {
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    if (player.server.isSingleplayerOwner(player.getGameProfile())) continue;
                    NetworkHandler.sendToPlayer(packet, player);
                }
            }
        }
    }

    public static void sendNonLocal(ServerPlayer player, CustomPacketPayload packet) {
        if (!player.server.isSingleplayerOwner(player.getGameProfile())) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }
}

