/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;

public class PNCDungeonLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<PNCDungeonLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> PNCDungeonLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, PNCDungeonLootModifier::new)));

    public PNCDungeonLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)ConfigHelper.common().general.enableDungeonLoot.get()).booleanValue()) {
            generatedLoot.addAll(CustomPools.roll(context));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    private static class CustomPools {
        private static final Lazy<LootPool> commonPool = Lazy.of(() -> CustomPools.buildLootPool("common"));
        private static final Lazy<LootPool> uncommonPool = Lazy.of(() -> CustomPools.buildLootPool("uncommon"));
        private static final Lazy<LootPool> rarePool = Lazy.of(() -> CustomPools.buildLootPool("rare"));

        private CustomPools() {
        }

        private static List<ItemStack> roll(LootContext ctx) {
            return (List)Util.make(new ArrayList(), l -> {
                ((LootPool)commonPool.get()).addRandomItems(l::add, ctx);
                ((LootPool)uncommonPool.get()).addRandomItems(l::add, ctx);
                ((LootPool)rarePool.get()).addRandomItems(l::add, ctx);
            });
        }

        private static LootPool buildLootPool(String name) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)PneumaticRegistry.RL("custom/" + name + "_dungeon_loot"));
            return LootPool.lootPool().add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference((ResourceKey)key).setWeight(1)).name("pneumaticcraft_custom_" + name).build();
        }
    }
}

