/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerCoreItem
extends Item
implements ColorHandlers.ITintableItem {
    public SpawnerCoreItem() {
        super(ModItems.defaultProps().component(ModDataComponents.SPAWNER_CORE_STATS, (Object)SpawnerCoreStats.EMPTY));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        ISpawnerCoreStats stats = (ISpawnerCoreStats)stack.getOrDefault(ModDataComponents.SPAWNER_CORE_STATS, (Object)SpawnerCoreStats.EMPTY);
        if (stats.getUnusedPercentage() < 100) {
            stats.getEntities().keySet().stream().sorted(Comparator.comparing(t -> I18n.get((String)t.getDescriptionId(), (Object[])new Object[0]))).forEach(type -> tooltip.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate(type.getDescriptionId(), new Object[0]).withStyle(ChatFormatting.YELLOW)).append(": " + stats.getPercentage((EntityType<?>)type) + "%").withStyle(ChatFormatting.WHITE)));
            if (stats.getUnusedPercentage() > 0) {
                tooltip.add((Component)Symbols.bullet().append((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC})).append(": " + stats.getUnusedPercentage() + "%").withStyle(ChatFormatting.WHITE));
            }
        } else {
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).withStyle(ChatFormatting.YELLOW));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide) {
            return this.trySpawnEntity(context) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean trySpawnEntity(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        if (stack.getCount() != 1) {
            return false;
        }
        ISpawnerCoreStats stats = (ISpawnerCoreStats)stack.get(ModDataComponents.SPAWNER_CORE_STATS);
        if (stats != null) {
            Level world = context.getLevel();
            EntityType<?> type = stats.pickEntity(false);
            if (type == null) {
                return false;
            }
            return PneumaticCraftUtils.getRegistryName(BuiltInRegistries.ENTITY_TYPE, type).map(regName -> {
                Vec3 vec = context.getClickLocation();
                if (world.noCollision(type.getSpawnAABB(vec.x(), vec.y(), vec.z()))) {
                    ServerLevel serverworld = (ServerLevel)world;
                    CompoundTag nbt = new CompoundTag();
                    nbt.putString("id", regName.toString());
                    Entity entity = EntityType.loadEntityRecursive((CompoundTag)nbt, (Level)world, e1 -> {
                        e1.moveTo(vec.x(), vec.y(), vec.z(), e1.getYRot(), e1.getXRot());
                        return e1;
                    });
                    if (entity != null) {
                        entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), world.random.nextFloat() * 360.0f, 0.0f);
                        if (serverworld.tryAddFreshEntityWithPassengers(entity)) {
                            stats.addAmount(type, -1).save(stack);
                            return true;
                        }
                    }
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        ISpawnerCoreStats stats;
        if (tintIndex == 1 && (stats = (ISpawnerCoreStats)stack.get(ModDataComponents.SPAWNER_CORE_STATS)) != null) {
            if (stats.getUnusedPercentage() == 100) {
                return -1;
            }
            int t = (int)(ClientUtils.getClientLevel().getGameTime() % 40L);
            float b = t < 20 ? Mth.sin((float)((float)Math.PI * (float)t / 20.0f)) / 6.0f : 0.0f;
            return TintColor.HSBtoRGB(0.19722222f, 1.0f - (float)stats.getUnusedPercentage() / 100.0f, 0.83333f + b);
        }
        return -1;
    }

    public record SpawnerCoreStats(Map<EntityType<?>, Integer> map, int unused) implements ISpawnerCoreStats
    {
        public static final Codec<ISpawnerCoreStats> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.unboundedMap((Codec)BuiltInRegistries.ENTITY_TYPE.byNameCodec(), (Codec)ExtraCodecs.intRange((int)0, (int)100)).fieldOf("map").forGetter(ISpawnerCoreStats::getEntities), (App)ExtraCodecs.intRange((int)0, (int)100).fieldOf("unused").forGetter(ISpawnerCoreStats::getUnusedPercentage)).apply((Applicative)builder, SpawnerCoreStats::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, Map<EntityType<?>, Integer>> ENTITY_MAP = ByteBufCodecs.map(Maps::newHashMapWithExpectedSize, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ENTITY_TYPE), (StreamCodec)ByteBufCodecs.VAR_INT);
        public static final StreamCodec<RegistryFriendlyByteBuf, ISpawnerCoreStats> STREAM_CODEC = StreamCodec.composite(ENTITY_MAP, ISpawnerCoreStats::getEntities, (StreamCodec)ByteBufCodecs.VAR_INT, ISpawnerCoreStats::getUnusedPercentage, SpawnerCoreStats::new);
        public static final SpawnerCoreStats EMPTY = new SpawnerCoreStats(Map.of(), 100);

        @Override
        public Map<EntityType<?>, Integer> getEntities() {
            return Collections.unmodifiableMap(this.map);
        }

        @Override
        public int getPercentage(EntityType<?> entityType) {
            return this.map.getOrDefault(entityType, 0);
        }

        @Override
        public int getUnusedPercentage() {
            return this.unused;
        }

        @Override
        public ISpawnerCoreStats addAmount(EntityType<?> type, int toAdd) {
            HashMap entityCounts = new HashMap(this.map);
            int newUnused = this.unused;
            int current = this.getPercentage(type);
            if ((toAdd = Mth.clamp((int)toAdd, (int)(-current), (int)this.unused)) != 0) {
                int newAmount = Mth.clamp((int)(current + toAdd), (int)0, (int)100);
                entityCounts.put(type, newAmount);
                return new SpawnerCoreStats(Map.copyOf(entityCounts), newUnused -= toAdd);
            }
            return this;
        }

        @Override
        public void save(ItemStack stack) {
            stack.set(ModDataComponents.SPAWNER_CORE_STATS, (Object)this);
        }

        @Override
        public EntityType<?> pickEntity(boolean includeUnused) {
            if (this.unused == 100) {
                return null;
            }
            ArrayList<WeightedEntity> weightedEntities = new ArrayList<WeightedEntity>();
            this.map.forEach((type, amount) -> weightedEntities.add(new WeightedEntity((EntityType<?>)type, (int)amount)));
            if (includeUnused && this.unused > 0) {
                weightedEntities.add(new WeightedEntity(null, this.unused));
            }
            return WeightedRandom.getRandomItem((RandomSource)RandomSource.createNewThreadLocalInstance(), weightedEntities).map(WeightedEntity::type).orElse(null);
        }

        @Override
        public ISpawnerCoreStats empty() {
            return EMPTY;
        }

        private record WeightedEntity(EntityType<?> type, int weight) implements WeightedEntry
        {
            public Weight getWeight() {
                return Weight.of((int)this.weight);
            }
        }
    }

    public static class SpawnerCoreItemHandler
    extends BaseItemStackHandler {
        private ISpawnerCoreStats stats;

        public SpawnerCoreItemHandler(BlockEntity owner) {
            super(owner, 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getItem() instanceof SpawnerCoreItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.stats = null;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            super.deserializeNBT(provider, nbt);
            this.stats = null;
        }

        @Override
        public void loadContainerContents(@Nullable ItemContainerContents contents) {
            super.loadContainerContents(contents);
            this.stats = null;
        }

        @NotNull
        public ISpawnerCoreStats getStats() {
            if (this.stats == null) {
                this.stats = this.getStackInSlot(0).isEmpty() ? SpawnerCoreStats.EMPTY : (ISpawnerCoreStats)this.getStackInSlot(0).getOrDefault(ModDataComponents.SPAWNER_CORE_STATS, (Object)SpawnerCoreStats.EMPTY);
            }
            return this.stats;
        }

        public boolean isCorePresent() {
            return this.getStackInSlot(0).getItem() instanceof SpawnerCoreItem;
        }
    }
}

