/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.capabilities.PNCFluidHandlerItemStack;
import me.desht.pneumaticcraft.common.item.IFluidCapProvider;
import me.desht.pneumaticcraft.common.item.ILeftClickableItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModFluids;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.thirdparty.curios.Curios;
import me.desht.pneumaticcraft.common.thirdparty.curios.CuriosUtils;
import me.desht.pneumaticcraft.common.util.EnchantmentUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class MemoryStickItem
extends Item
implements ColorHandlers.ITintableItem,
ILeftClickableItem,
IFluidCapProvider {
    public static final int XP_FLUID_CAPACITY = 512000;
    private static final int[] TINT_COLORS = new int[]{0xF7FFBF, 0xF2FF99, 15597427, 15269709, 14941990, 14614272};

    public MemoryStickItem() {
        super(ModItems.defaultProps().stacksTo(1).component(ModDataComponents.ABSORB_ORBS, (Object)false).component(ModDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY));
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (stack.getCount() != 1) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (!worldIn.isClientSide) {
            IOHelper.getFluidHandlerForItem(stack).ifPresent(handler -> {
                int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
                int playerXp = EnchantmentUtils.getPlayerXP(playerIn);
                if (playerIn.isShiftKeyDown()) {
                    int xpToGive = EnchantmentUtils.getExperienceForLevel(playerIn.experienceLevel + 1) - playerXp;
                    int fluidAmount = xpToGive * ratio;
                    FluidStack toDrain = handler.drain(fluidAmount, IFluidHandler.FluidAction.SIMULATE);
                    if (!toDrain.isEmpty()) {
                        EnchantmentUtils.addPlayerXP(playerIn, toDrain.getAmount() / ratio);
                        handler.drain(toDrain.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                        playerIn.setItemInHand(handIn, handler.getContainer());
                    }
                } else if (playerXp > 0) {
                    int xpToTake = playerXp - EnchantmentUtils.getExperienceForLevel(playerIn.experienceLevel);
                    if (xpToTake == 0) {
                        xpToTake = playerXp - EnchantmentUtils.getExperienceForLevel(playerIn.experienceLevel - 1);
                    }
                    int fluidAmount = xpToTake * ratio;
                    FluidStack toFill = new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), fluidAmount);
                    int filled = handler.fill(toFill, IFluidHandler.FluidAction.SIMULATE);
                    if (filled >= ratio) {
                        EnchantmentUtils.addPlayerXP(playerIn, -(filled / ratio));
                        handler.fill(new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), filled), IFluidHandler.FluidAction.EXECUTE);
                        playerIn.setItemInHand(handIn, handler.getContainer());
                    }
                }
            });
        } else {
            IOHelper.getFluidHandlerForItem(stack).ifPresent(handler -> {
                int amount = handler.getFluidInTank(0).getAmount();
                if (EnchantmentUtils.getPlayerXP(playerIn) > 0 && amount < handler.getTankCapacity(0) && !playerIn.isShiftKeyDown() || handler.getFluidInTank(0).getAmount() > 0 && playerIn.isShiftKeyDown()) {
                    playerIn.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.1f, (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.35f + 0.9f);
                }
            });
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (context.registries() != null) {
            IOHelper.getFluidHandlerForItem(stack).ifPresent(handler -> {
                int ratio = XPFluidManager.getInstance().getXPRatio((Fluid)ModFluids.MEMORY_ESSENCE.get());
                if (ratio > 0) {
                    FluidStack fluidStack = handler.getFluidInTank(0);
                    int amount = fluidStack.getAmount();
                    int levels = EnchantmentUtils.getLevelForExperience(amount / ratio);
                    tooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.tooltip.memory_stick.xp_stored", (Object[])new Object[]{amount / ratio, levels}).withStyle(ChatFormatting.GREEN));
                }
            });
            boolean absorb = MemoryStickItem.shouldAbsorbXPOrbs(stack);
            tooltip.add((Component)Component.translatable((String)("pneumaticcraft.message.memory_stick.absorb." + absorb)).withStyle(ChatFormatting.YELLOW));
        }
    }

    public int getBarWidth(ItemStack stack) {
        return IOHelper.getFluidHandlerForItem(stack).map(handler -> {
            FluidStack fluidStack = handler.getFluidInTank(0);
            return Math.round((float)fluidStack.getAmount() / (float)handler.getTankCapacity(0) * 13.0f);
        }).orElse(0);
    }

    public boolean isBarVisible(ItemStack pStack) {
        return true;
    }

    public static boolean shouldAbsorbXPOrbs(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ABSORB_ORBS, (Object)false);
    }

    public static void setAbsorbXPOrbs(ItemStack stack, boolean absorb) {
        if (stack.getItem() == ModItems.MEMORY_STICK.get()) {
            stack.set(ModDataComponents.ABSORB_ORBS, (Object)absorb);
        }
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return switch (tintIndex) {
            case 1 -> IOHelper.getFluidHandlerForItem(stack).map(handler -> {
                FluidStack fluidStack = handler.getFluidInTank(0);
                if (fluidStack.isEmpty()) {
                    return 0xFFFFFF;
                }
                float f = (float)fluidStack.getAmount() / (float)handler.getTankCapacity(0);
                return TINT_COLORS[(int)(f * 5.0f)];
            }).orElse(-1);
            case 2 -> {
                if (MemoryStickItem.shouldAbsorbXPOrbs(stack)) {
                    yield -16711936;
                }
                yield -8355712;
            }
            default -> -1;
        };
    }

    @Override
    public void onLeftClickEmpty(ServerPlayer sender) {
        MemoryStickItem.toggleXPAbsorption((Player)sender, sender.getMainHandItem());
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (MemoryStickItem.shouldAbsorbXPOrbs(stack) && entityIn instanceof Player && itemSlot >= 0) {
            MemoryStickItem.cacheMemoryStickLocation((Player)entityIn, MemoryStickLocator.playerInv(itemSlot));
        }
    }

    public static boolean isRoomInStick(ItemStack stick) {
        return stick.getItem() instanceof MemoryStickItem && IOHelper.getFluidHandlerForItem(stick).map(h -> h.getFluidInTank(0).getAmount() < h.getTankCapacity(0)).orElseThrow(RuntimeException::new) != false;
    }

    private static void toggleXPAbsorption(Player player, ItemStack stack) {
        if (stack.getItem() instanceof MemoryStickItem) {
            boolean absorb = MemoryStickItem.shouldAbsorbXPOrbs(stack);
            MemoryStickItem.setAbsorbXPOrbs(stack, !absorb);
            player.displayClientMessage((Component)Component.translatable((String)("pneumaticcraft.message.memory_stick.absorb." + !absorb)).withStyle(ChatFormatting.YELLOW), true);
            player.getCommandSenderWorld().playSound(null, player.blockPosition(), (SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.PLAYERS, 1.0f, absorb ? 1.5f : 2.0f);
        }
    }

    public static void cacheMemoryStickLocation(Player entityIn, MemoryStickLocator locator) {
        Listener.memoryStickCache.computeIfAbsent(entityIn.getUUID(), k -> new HashSet()).add(locator);
    }

    @Override
    public IFluidHandlerItem provideFluidCapability(ItemStack stack) {
        return new PNCFluidHandlerItemStack(ModDataComponents.STORED_FLUID, stack, 512000, fluid -> fluid == ModFluids.MEMORY_ESSENCE.get());
    }

    public record MemoryStickLocator(String invName, int slot) {
        public static MemoryStickLocator playerInv(int slot) {
            return new MemoryStickLocator("", slot);
        }

        public static MemoryStickLocator namedInv(String name, int slot) {
            return new MemoryStickLocator(name, slot);
        }

        public ItemStack getMemoryStick(Player player) {
            if (this.invName.isEmpty()) {
                return player.getInventory().getItem(this.slot);
            }
            if (Curios.available) {
                return CuriosUtils.getStack(player, this.invName, this.slot);
            }
            return ItemStack.EMPTY;
        }
    }

    @EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        private static final Map<UUID, Long> lastEvent = new HashMap<UUID, Long>();
        private static final Map<UUID, Set<MemoryStickLocator>> memoryStickCache = new HashMap<UUID, Set<MemoryStickLocator>>();

        @SubscribeEvent
        public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getItemStack().getItem() instanceof MemoryStickItem) {
                long last;
                long now;
                if (!event.getLevel().isClientSide && (now = event.getLevel().getGameTime()) - (last = lastEvent.getOrDefault(event.getEntity().getUUID(), 0L).longValue()) > 5L) {
                    MemoryStickItem.toggleXPAbsorption(event.getEntity(), event.getItemStack());
                    lastEvent.put(event.getEntity().getUUID(), now);
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            if (event.getLevel().isClientSide && event.getItemStack().getItem() instanceof MemoryStickItem) {
                NetworkHandler.sendToServer(PacketLeftClickEmpty.INSTANCE);
            }
        }

        @SubscribeEvent
        public static void onXpOrbPickup(PlayerXpEvent.PickupXp event) {
            ItemStack stack = Listener.findMemoryStick(event.getEntity());
            if (!stack.isEmpty()) {
                IOHelper.getFluidHandlerForItem(stack).ifPresent(handler -> {
                    if (PneumaticCraftUtils.fillTankWithOrb((IFluidHandler)handler, event.getOrb(), IFluidHandler.FluidAction.EXECUTE)) {
                        event.getOrb().discard();
                        event.setCanceled(true);
                    }
                });
            }
        }

        private static ItemStack findMemoryStick(Player player) {
            Set<MemoryStickLocator> locators = memoryStickCache.get(player.getUUID());
            if (locators == null || locators.isEmpty()) {
                return ItemStack.EMPTY;
            }
            locators.removeIf(loc -> !MemoryStickItem.shouldAbsorbXPOrbs(loc.getMemoryStick(player)));
            return locators.stream().map(loc -> loc.getMemoryStick(player)).filter(MemoryStickItem::isRoomInStick).findFirst().orElse(ItemStack.EMPTY);
        }
    }
}

