/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.drone.ProgWidgetUtils;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.item.IChargeableContainerProvider;
import me.desht.pneumaticcraft.common.item.PressurizableItem;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;

public class DroneItem
extends PressurizableItem
implements IChargeableContainerProvider,
IProgrammable,
ColorHandlers.ITintableItem {
    private final BiFunction<Level, Player, DroneEntity> droneCreator;
    private final boolean programmable;
    private final DyeColor defaultColor;

    public DroneItem(BiFunction<Level, Player, DroneEntity> droneCreator, boolean programmable, DyeColor defaultColor) {
        super(ModItems.defaultProps().component(ModDataComponents.DRONE_COLOR, (Object)defaultColor.getId()).component(ModDataComponents.STORED_FLUID, (Object)SimpleFluidContent.EMPTY), 120000, 12000);
        this.droneCreator = droneCreator;
        this.programmable = programmable;
        this.defaultColor = defaultColor;
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        if (player instanceof ServerPlayer) {
            BlockState state;
            ServerPlayer sp = (ServerPlayer)player;
            Level world = ctx.getLevel();
            BlockPos pos = ctx.getClickedPos();
            ItemStack iStack = sp.getItemInHand(ctx.getHand());
            if (iStack.getItem() == ModItems.LOGISTICS_DRONE.get()) {
                ModCriterionTriggers.LOGISTICS_DRONE_DEPLOYED.get().trigger(sp);
            }
            BlockPos placePos = (state = world.getBlockState(pos)).getCollisionShape((BlockGetter)world, pos).isEmpty() ? pos : pos.relative(ctx.getClickedFace());
            this.spawnDrone(ctx.getPlayer(), world, pos, ctx.getClickedFace(), placePos, iStack);
            iStack.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.getCommandSenderWorld().isClientSide && stack.has(ModDataComponents.SAVED_DRONE_PROGRAM)) {
            entity.setExtendedLifetime();
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        FluidStack fluidStack;
        super.appendHoverText(stack, context, tooltip, flagIn);
        SimpleFluidContent storedFluid = (SimpleFluidContent)stack.get(ModDataComponents.STORED_FLUID);
        if (storedFluid != null && !storedFluid.isEmpty() && !(fluidStack = storedFluid.copy()).isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"pneumaticcraft.gui.tooltip.fluid").append(fluidStack.getAmount() + "mB ").append(fluidStack.getHoverName()).withStyle(ChatFormatting.GRAY));
        }
    }

    public DyeColor getDroneColor(ItemStack stack) {
        int color = (Integer)stack.getOrDefault(ModDataComponents.DRONE_COLOR, (Object)this.defaultColor.getId());
        return DyeColor.byId((int)color);
    }

    public boolean spawnDrone(Player player, Level level, BlockPos clickPos, Direction facing, BlockPos placePos, ItemStack iStack) {
        DroneEntity drone = this.droneCreator.apply(level, player);
        drone.setPos((double)placePos.getX() + 0.5, (double)placePos.getY() + 0.5, (double)placePos.getZ() + 0.5);
        drone.readFromItemStack(iStack);
        level.addFreshEntity((Entity)drone);
        if (drone.isAddedToLevel()) {
            drone.setDeployPos(placePos);
            if (drone.addProgram(clickPos, facing, placePos, iStack, drone.progWidgets)) {
                ProgWidgetUtils.updatePuzzleConnections(drone.progWidgets);
            }
            if (level instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
                EventHooks.finalizeMobSpawn((Mob)drone, (ServerLevelAccessor)serverLevel, (DifficultyInstance)serverLevel.getCurrentDifficultyAt(placePos), (MobSpawnType)MobSpawnType.TRIGGERED, null);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canProgram(ItemStack stack) {
        return this.programmable;
    }

    @Override
    public boolean usesPieces(ItemStack stack) {
        return true;
    }

    @Override
    public boolean showProgramTooltip() {
        return true;
    }

    @Override
    public MenuProvider getContainerProvider(ChargingStationBlockEntity te) {
        return new IChargeableContainerProvider.Provider(te, ModMenuTypes.CHARGING_DRONE.get());
    }

    @Override
    public int getTintColor(ItemStack stack, int tintIndex) {
        return tintIndex == 1 ? this.getDroneColor(stack).getTextureDiffuseColor() : -1;
    }

    public static boolean isBasicDrone(ItemStack stack) {
        DroneItem d;
        Item item = stack.getItem();
        return item instanceof DroneItem && !(d = (DroneItem)item).canProgram(stack);
    }

    @Override
    public Optional<TagKey<Item>> getUpgradeBlacklistTag() {
        return Optional.of(PneumaticCraftTags.Items.DRONE_UPGRADE_BLACKLIST);
    }
}

