/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory.handler;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BaseItemStackHandler
extends ItemStackHandler {
    protected final BlockEntity te;

    public BaseItemStackHandler(int size) {
        this(null, size);
    }

    public BaseItemStackHandler(BlockEntity te, int size) {
        super(size);
        this.te = te;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        if (this.te != null && this.te.getLevel() != null && !this.te.getLevel().isClientSide) {
            this.te.setChanged();
        }
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.isItemValid(slot, stack) ? super.insertItem(slot, stack, simulate) : stack;
    }

    public ItemContainerContents toContainerContents() {
        return ItemContainerContents.fromItems((List)this.stacks);
    }

    public void loadContainerContents(@Nullable ItemContainerContents contents) {
        if (contents != null) {
            int i;
            for (i = 0; i < contents.getSlots() && i < this.stacks.size(); ++i) {
                this.stacks.set(i, (Object)contents.getStackInSlot(i));
            }
            for (i = contents.getSlots(); i < this.stacks.size(); ++i) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
            }
        }
    }
}

