/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.heat.TemperatureListener;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.heat.HeatExchangerManager;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourManager;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class HeatExchangerLogicTicking
implements IHeatExchangerLogic {
    private final Set<IHeatExchangerLogic> hullExchangers = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<IHeatExchangerLogic> connectedExchangers = Collections.newSetFromMap(new IdentityHashMap());
    private List<HeatBehaviour> behaviours = new ArrayList<HeatBehaviour>();
    private List<HeatBehaviour> newBehaviours;
    private double ambientTemperature = -1.0;
    private double temperature = 300.0;
    @GuiSynced
    private int temperatureInt = 300;
    private double thermalResistance = 1.0;
    private double thermalCapacity = 1.0;
    private final BitSet connections = new BitSet(6);
    private final List<TemperatureListener> temperatureCallbacks = new ArrayList<TemperatureListener>();

    @Override
    public void initializeAsHull(Level level, BlockPos pos, BiPredicate<LevelAccessor, BlockPos> blockFilter, Direction ... validSides) {
        if (this.ambientTemperature < 0.0) {
            this.initializeAmbientTemperature(level, pos);
        }
        if (level.isClientSide) {
            return;
        }
        for (IHeatExchangerLogic logic2 : this.hullExchangers) {
            this.removeConnectedExchanger(logic2);
        }
        this.hullExchangers.clear();
        this.newBehaviours = new ArrayList<HeatBehaviour>();
        this.connections.clear();
        for (Direction dir : validSides) {
            if (HeatBehaviourManager.getInstance().addHeatBehaviours(level, pos.relative(dir), dir, blockFilter, this, this.newBehaviours) > 0) {
                this.connections.set(dir.get3DDataValue());
            }
            HeatExchangerManager.getInstance().getLogic(level, pos.relative(dir), dir.getOpposite(), blockFilter).ifPresent(logic -> {
                this.hullExchangers.add((IHeatExchangerLogic)logic);
                this.addConnectedExchanger((IHeatExchangerLogic)logic);
                this.connections.set(dir.get3DDataValue());
            });
        }
    }

    @Override
    public boolean isSideConnected(Direction side) {
        return this.connections.get(side.get3DDataValue());
    }

    @Override
    public void addConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
        this.connectedExchangers.add(exchanger);
        if (reciprocate) {
            exchanger.addConnectedExchanger(this, false);
        }
    }

    @Override
    public void removeConnectedExchanger(IHeatExchangerLogic exchanger, boolean reciprocate) {
        this.connectedExchangers.remove(exchanger);
        if (reciprocate) {
            exchanger.removeConnectedExchanger(this, false);
        }
    }

    @Override
    public void initializeAmbientTemperature(Level level, BlockPos pos) {
        this.ambientTemperature = HeatExchangerLogicAmbient.atPosition((LevelAccessor)level, pos).getAmbientTemperature();
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public int getTemperatureAsInt() {
        return this.temperatureInt;
    }

    @Override
    public void setTemperature(double temperature) {
        if (temperature != this.temperature) {
            double prevTemperature = this.temperature;
            this.temperature = temperature;
            this.temperatureInt = (int)temperature;
            if (Math.abs(prevTemperature - temperature) > 0.001) {
                this.temperatureCallbacks.forEach(l -> l.onTemperatureChanged(prevTemperature, temperature));
            }
        }
    }

    @Override
    public void setThermalResistance(double thermalResistance) {
        this.thermalResistance = thermalResistance;
    }

    @Override
    public double getThermalResistance() {
        return this.thermalResistance;
    }

    @Override
    public void setThermalCapacity(double capacity) {
        this.thermalCapacity = capacity;
    }

    @Override
    public double getThermalCapacity() {
        return this.thermalCapacity;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putDouble("temperature", this.temperature);
        ListTag tagList = new ListTag();
        for (HeatBehaviour behaviour : this.behaviours) {
            CompoundTag t = behaviour.serializeNBT();
            t.putString("id", behaviour.getId().toString());
            tagList.add((Object)t);
        }
        tag.put("behaviours", (Tag)tagList);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.temperature = nbt.getDouble("temperature");
        this.temperatureInt = (int)this.temperature;
        this.behaviours.clear();
        ListTag tagList = nbt.getList("behaviours", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag t = tagList.getCompound(i);
            Object behaviour = HeatBehaviourManager.getInstance().createBehaviour(ResourceLocation.parse((String)t.getString("id")));
            if (behaviour == null) continue;
            ((HeatBehaviour)behaviour).deserializeNBT(t);
            this.behaviours.add((HeatBehaviour)behaviour);
        }
    }

    @Override
    public void tick() {
        this.temperatureInt = (int)this.temperature;
        if (this.getThermalCapacity() < 0.1) {
            this.setTemperature(this.ambientTemperature);
            return;
        }
        if (this.newBehaviours != null) {
            List<HeatBehaviour> oldBehaviours = this.behaviours;
            this.behaviours = this.newBehaviours;
            this.newBehaviours = null;
            for (HeatBehaviour oldBehaviour : oldBehaviours) {
                int equalBehaviourIndex = this.behaviours.indexOf(oldBehaviour);
                if (equalBehaviourIndex < 0) continue;
                this.behaviours.get(equalBehaviourIndex).deserializeNBT(oldBehaviour.serializeNBT());
            }
        }
        Iterator<HeatBehaviour> iterator = this.behaviours.iterator();
        while (iterator.hasNext()) {
            HeatBehaviour behaviour = iterator.next();
            if (behaviour.getWorld() == null) continue;
            if (behaviour.isApplicable()) {
                behaviour.tick();
                continue;
            }
            iterator.remove();
        }
        for (IHeatExchangerLogic logic : this.connectedExchangers) {
            HeatExchangerLogicTicking.exchange(logic, this, this.getTickingHeatExchangers());
        }
    }

    @Override
    public double getAmbientTemperature() {
        return this.ambientTemperature;
    }

    @Override
    public void addTemperatureListener(TemperatureListener listener) {
        this.temperatureCallbacks.add(listener);
    }

    @Override
    public void removeTemperatureListener(TemperatureListener listener) {
        this.temperatureCallbacks.remove(listener);
    }

    public static void exchange(IHeatExchangerLogic logic, IHeatExchangerLogic logic2) {
        HeatExchangerLogicTicking.exchange(logic, logic2, 1.0);
    }

    private static void exchange(IHeatExchangerLogic logic, IHeatExchangerLogic logic2, double dispersionDivider) {
        if (logic.getThermalCapacity() < 0.1) {
            logic.setTemperature(logic.getAmbientTemperature());
            return;
        }
        double deltaTemp = logic.getTemperature() - logic2.getTemperature();
        double totalResistance = logic2.getThermalResistance() + logic.getThermalResistance();
        deltaTemp /= dispersionDivider;
        deltaTemp /= totalResistance;
        double maxDeltaTemp = (logic.getTemperature() * logic.getThermalCapacity() - logic2.getTemperature() * logic2.getThermalCapacity()) / 2.0;
        if (maxDeltaTemp >= 0.0 && deltaTemp > maxDeltaTemp || maxDeltaTemp <= 0.0 && deltaTemp < maxDeltaTemp) {
            deltaTemp = maxDeltaTemp;
        }
        logic2.addHeat(deltaTemp);
        logic.addHeat(-deltaTemp);
    }

    private int getTickingHeatExchangers() {
        int tickingHeatExchangers = 1;
        for (IHeatExchangerLogic logic : this.connectedExchangers) {
            if (!(logic instanceof HeatExchangerLogicTicking)) continue;
            ++tickingHeatExchangers;
        }
        return tickingHeatExchangers;
    }

    @Override
    public void addHeat(double amount) {
        this.setTemperature(Mth.clamp((double)(this.temperature + amount / this.getThermalCapacity()), (double)0.0, (double)2273.0));
    }

    @Override
    public <T extends HeatBehaviour> Optional<T> getHeatBehaviour(BlockPos pos, Class<T> cls) {
        for (HeatBehaviour behaviour : this.behaviours) {
            if (!behaviour.getPos().equals((Object)pos) || !cls.isAssignableFrom(behaviour.getClass())) continue;
            return Optional.of((HeatBehaviour)cls.cast(behaviour));
        }
        return Optional.empty();
    }
}

