/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class HarvestHandlerCactusLike
extends HarvestHandler {
    private final Predicate<BlockState> blockChecker;

    public HarvestHandlerCactusLike(Predicate<BlockState> blockChecker) {
        this.blockChecker = blockChecker;
    }

    @Override
    public boolean canHarvest(Level world, BlockGetter chunkCache, BlockPos pos, BlockState state, IDrone drone) {
        if (this.blockChecker.test(state)) {
            BlockState stateBelow = chunkCache.getBlockState(pos.relative(Direction.DOWN));
            return this.blockChecker.test(stateBelow);
        }
        return false;
    }

    public static class VanillaCrops
    extends HarvestHandlerCactusLike {
        public VanillaCrops() {
            super(state -> state.getBlock() == Blocks.CACTUS || state.getBlock() == Blocks.SUGAR_CANE || state.getBlock() == Blocks.KELP_PLANT || state.getBlock() == Blocks.BAMBOO);
        }
    }
}

