/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;

public class HackableCaveSpider
implements IHackableEntity<CaveSpider> {
    private static final ResourceLocation ID = PneumaticRegistry.RL("cave_spider");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    @Override
    public Class<CaveSpider> getHackableClass() {
        return CaveSpider.class;
    }

    @Override
    public void addHackInfo(CaveSpider entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.neutralize", new Object[0]));
    }

    @Override
    public void addPostHackInfo(CaveSpider entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.neutralized", new Object[0]));
    }

    @Override
    public int getHackTime(CaveSpider entity, Player player) {
        return 50;
    }

    @Override
    public void onHackFinished(CaveSpider entity, Player player) {
        if (!entity.level().isClientSide) {
            entity.discard();
            Spider spider = new Spider(EntityType.SPIDER, entity.level());
            spider.absMoveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
            spider.setHealth(entity.getHealth());
            spider.yBodyRot = entity.yBodyRot;
            entity.level().addFreshEntity((Entity)spider);
        }
    }
}

