/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAITeleport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetGoToLocation;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;

public class ProgWidgetTeleport
extends ProgWidgetGoToLocation {
    public static final MapCodec<ProgWidgetTeleport> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetTeleport.baseParts(builder).apply((Applicative)builder, ProgWidgetTeleport::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetTeleport> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetTeleport::new);

    private ProgWidgetTeleport(ProgWidget.PositionFields pos) {
        super(pos, false);
    }

    public ProgWidgetTeleport() {
        this(ProgWidget.PositionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetTeleport(this.getPosition());
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.TELEPORT.get();
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_TELEPORT;
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        DroneAITeleport droneAITeleport;
        if (drone instanceof DroneEntity) {
            DroneEntity de = (DroneEntity)drone;
            droneAITeleport = new DroneAITeleport(de, (ProgWidget)widget);
        } else {
            droneAITeleport = null;
        }
        return droneAITeleport;
    }
}

