/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLiquidFilter;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;

public class ProgWidgetLiquidInventoryCondition
extends ProgWidgetCondition {
    public static final MapCodec<ProgWidgetLiquidInventoryCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetLiquidInventoryCondition.condParts(builder).apply((Applicative)builder, ProgWidgetLiquidInventoryCondition::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetLiquidInventoryCondition> STREAM_CODEC = StreamCodec.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, ProgWidgetInventoryBase.InvBaseFields.STREAM_CODEC, ProgWidgetInventoryBase::invBaseFields, ProgWidgetCondition.ConditionFields.STREAM_CODEC, ProgWidgetCondition::conditionFields, ProgWidgetLiquidInventoryCondition::new);

    private ProgWidgetLiquidInventoryCondition(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields inv, ProgWidgetCondition.ConditionFields cond) {
        super(pos, inv, cond);
    }

    public ProgWidgetLiquidInventoryCondition() {
        super(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT, ProgWidgetCondition.ConditionFields.DEFAULT);
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetLiquidInventoryCondition(this.getPosition(), this.invBaseFields().copy(), this.conditionFields());
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.AREA.get(), ModProgWidgetTypes.LIQUID_FILTER.get(), ModProgWidgetTypes.TEXT.get());
    }

    @Override
    protected DroneAIBlockCondition getEvaluator(IDrone drone, IProgWidget widget) {
        return new DroneAIBlockCondition(drone, (ProgWidgetAreaItemBase)widget){

            @Override
            protected boolean evaluate(BlockPos pos) {
                BlockEntity te = this.drone.getDroneLevel().getBlockEntity(pos);
                int count = te == null ? this.countFluid(this.drone.getDroneLevel(), pos) : this.countFluid(te);
                ProgWidgetLiquidInventoryCondition.this.maybeRecordMeasuredVal(this.drone, count);
                return ((ICondition)((Object)this.progWidget)).getOperator().evaluate(count, ((ICondition)((Object)this.progWidget)).getRequiredCount());
            }

            private int countFluid(Level world, BlockPos pos) {
                FluidState state = world.getFluidState(pos);
                if (state.getType() != Fluids.EMPTY && ProgWidgetLiquidFilter.isLiquidValid(state.getType(), this.progWidget, 1)) {
                    return 1000;
                }
                return 0;
            }

            private int countFluid(BlockEntity te) {
                return IOHelper.getFluidHandlerForBlock(te).map(handler -> {
                    int total = 0;
                    for (int i = 0; i < handler.getTanks(); ++i) {
                        FluidStack stack = handler.getFluidInTank(i);
                        if (stack.isEmpty() || !ProgWidgetLiquidFilter.isLiquidValid(stack.getFluid(), this.progWidget, 1)) continue;
                        total += stack.getAmount();
                    }
                    return total;
                }).orElse(0);
            }
        };
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_CONDITION_LIQUID_INVENTORY;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.CONDITION_LIQUID_INVENTORY.get();
    }
}

