/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.misc.Symbols;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetItemAssign;
import me.desht.pneumaticcraft.common.item.TagFilterItem;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.thirdparty.ModNameCache;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class ProgWidgetItemFilter
extends ProgWidget
implements IVariableWidget {
    public static final MapCodec<ProgWidgetItemFilter> CODEC = RecordCodecBuilder.mapCodec(builder -> ProgWidgetItemFilter.baseParts(builder).and(builder.group((App)ItemStack.CODEC.optionalFieldOf("chk_item", (Object)ItemStack.EMPTY).forGetter(ProgWidgetItemFilter::getFilter), (App)Codec.BOOL.optionalFieldOf("chk_durability", (Object)false).forGetter(ProgWidgetItemFilter::isCheckDurability), (App)Codec.BOOL.optionalFieldOf("chk_components", (Object)false).forGetter(ProgWidgetItemFilter::isMatchComponents), (App)Codec.BOOL.optionalFieldOf("chk_mod", (Object)false).forGetter(ProgWidgetItemFilter::isMatchMod), (App)Codec.BOOL.optionalFieldOf("chk_block", (Object)false).forGetter(ProgWidgetItemFilter::isMatchBlock), (App)Codec.STRING.optionalFieldOf("var", (Object)"").forGetter(ProgWidgetItemFilter::getVariable))).apply((Applicative)builder, ProgWidgetItemFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ProgWidgetItemFilter> STREAM_CODEC = NeoForgeStreamCodecs.composite(ProgWidget.PositionFields.STREAM_CODEC, ProgWidget::getPosition, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, ProgWidgetItemFilter::getFilter, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetItemFilter::isCheckDurability, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetItemFilter::isMatchComponents, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetItemFilter::isMatchMod, (StreamCodec)ByteBufCodecs.BOOL, ProgWidgetItemFilter::isMatchBlock, (StreamCodec)ByteBufCodecs.STRING_UTF8, ProgWidgetItemFilter::getVariable, ProgWidgetItemFilter::new);
    private ItemStack filter;
    private boolean checkDurability;
    private boolean matchComponents;
    private boolean matchMod;
    private boolean matchBlock;
    private DroneAIManager aiManager;
    private String variable;

    public ProgWidgetItemFilter(ProgWidget.PositionFields pos, ItemStack filter, boolean checkDurability, boolean matchComponents, boolean matchMod, boolean matchBlock, String variable) {
        super(pos);
        this.filter = filter;
        this.checkDurability = checkDurability;
        this.matchComponents = matchComponents;
        this.matchMod = matchMod;
        this.matchBlock = matchBlock;
        this.variable = variable;
    }

    public ProgWidgetItemFilter() {
        this(ProgWidget.PositionFields.DEFAULT, ItemStack.EMPTY, false, false, false, false, "");
    }

    @Override
    public IProgWidget copyWidget() {
        return new ProgWidgetItemFilter(this.getPosition(), this.filter.copy(), this.checkDurability, this.matchComponents, this.matchMod, this.matchBlock, this.variable);
    }

    public static ProgWidgetItemFilter withFilter(ItemStack filter) {
        ProgWidgetItemFilter widget = new ProgWidgetItemFilter();
        widget.filter = filter;
        return widget;
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.isEmpty() && this.filter == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.error.noFilter", new Object[0]));
        }
        if (this.matchBlock && !(this.filter.getItem() instanceof BlockItem) && this.variable.isEmpty()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.error.notBlock", new Object[0]));
        }
    }

    @Override
    public void addWarnings(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addWarnings(curInfo, widgets);
        int n = 1;
        for (IProgWidget p = this.getParent(); p != null; p = p.getParent()) {
            if (p instanceof ProgWidgetItemAssign && n > 1) {
                curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.warning.ignoredItemAssign", new Object[0]));
                break;
            }
            ++n;
        }
    }

    @Override
    public List<Component> getExtraStringInfo() {
        return this.variable.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.varAsTextComponent(this.variable));
    }

    @Nonnull
    public ItemStack getFilter() {
        return this.variable.isEmpty() ? this.filter : (this.aiManager != null ? this.aiManager.getStack(this.aiManager.getDrone().getOwnerUUID(), this.variable) : ItemStack.EMPTY);
    }

    public ItemStack getRawFilter() {
        return this.filter;
    }

    public void setFilter(@Nonnull ItemStack filter) {
        this.filter = filter.copy();
    }

    public boolean isCheckDurability() {
        return this.checkDurability;
    }

    public void setCheckDurability(boolean checkDurability) {
        this.checkDurability = checkDurability;
    }

    public boolean isMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
    }

    public boolean isMatchMod() {
        return this.matchMod;
    }

    public void setMatchMod(boolean matchMod) {
        this.matchMod = matchMod;
    }

    public boolean isMatchBlock() {
        return this.matchBlock;
    }

    public void setMatchBlock(boolean matchBlock) {
        this.matchBlock = matchBlock;
    }

    @Override
    public ProgWidgetType<?> getType() {
        return ModProgWidgetTypes.ITEM_FILTER.get();
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.variable.isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.coordinate.variable", new Object[0]).append(": ").append(this.varAsTextComponent(this.variable)).withStyle(ChatFormatting.AQUA));
        } else if (!this.filter.isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.filterLabel", new Object[0]).withStyle(ChatFormatting.AQUA).append(": ").append(this.filter.getHoverName()));
            if (this.filter.getItem() == ModItems.TAG_FILTER.get()) {
                curTooltip.addAll(TagFilterItem.getConfiguredTagList(this.filter).stream().map(s -> Symbols.bullet().append((Component)Component.literal((String)s.location().toString()).withStyle(ChatFormatting.YELLOW))).toList());
            }
        }
        if (this.matchMod) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.matchMod", ModNameCache.getModName(this.filter.getItem())).withStyle(ChatFormatting.DARK_AQUA));
        } else if (this.matchBlock) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter.matchBlock", new Object[0]).withStyle(ChatFormatting.DARK_AQUA));
        } else {
            if (this.getRawFilter().getMaxDamage() > 0) {
                curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter." + (this.checkDurability ? "useDurability" : "ignoreDurability"), new Object[0]).withStyle(ChatFormatting.DARK_AQUA));
            }
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.itemFilter." + (this.matchComponents ? "useComponents" : "ignoreComponents"), new Object[0]).withStyle(ChatFormatting.DARK_AQUA));
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public ProgWidgetType<?> returnType() {
        return ModProgWidgetTypes.ITEM_FILTER.get();
    }

    @Override
    public List<ProgWidgetType<?>> getParameters() {
        return ImmutableList.of(ModProgWidgetTypes.ITEM_FILTER.get());
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ITEM_FILTER;
    }

    public static boolean isItemValidForFilters(ItemStack item, List<ProgWidgetItemFilter> whitelist, List<ProgWidgetItemFilter> blacklist, BlockState blockState) {
        if (blacklist != null) {
            for (ProgWidgetItemFilter black : blacklist) {
                if (!ProgWidgetItemFilter.matchFilter(item, blockState, black)) continue;
                return false;
            }
        }
        if (whitelist == null || whitelist.isEmpty()) {
            return true;
        }
        for (ProgWidgetItemFilter white : whitelist) {
            if (!ProgWidgetItemFilter.matchFilter(item, blockState, white)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFilter(ItemStack stack, BlockState blockState, ProgWidgetItemFilter filter) {
        if (filter.matchBlock && blockState != null && filter.getFilter().getItem() instanceof BlockItem) {
            return blockState.getBlock() == ((BlockItem)filter.getFilter().getItem()).getBlock();
        }
        if (PneumaticCraftUtils.doesItemMatchFilter(filter.getFilter(), stack, filter.checkDurability && blockState == null, filter.matchComponents, filter.matchMod)) {
            return blockState == null || !filter.checkDurability;
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.GRAY;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProgWidgetItemFilter that = (ProgWidgetItemFilter)o;
        return this.baseEquals(that) && this.checkDurability == that.checkDurability && this.matchComponents == that.matchComponents && this.matchMod == that.matchMod && this.matchBlock == that.matchBlock && Objects.equals(this.filter, that.filter) && Objects.equals(this.variable, that.variable);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.filter, this.checkDurability, this.matchComponents, this.matchMod, this.matchBlock, this.variable);
    }
}

