/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import java.util.Arrays;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.LogisticsManager;
import me.desht.pneumaticcraft.common.drone.ai.DroneAILiquidExport;
import me.desht.pneumaticcraft.common.drone.ai.DroneAILiquidImport;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityAIInventoryExport;
import me.desht.pneumaticcraft.common.drone.ai.DroneEntityAIInventoryImport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidExport;
import me.desht.pneumaticcraft.common.drone.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.registry.ModProgWidgetTypes;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.StreamUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class DroneAILogistics
extends Goal {
    private Goal curAI;
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase widget;
    private LogisticsManager.LogisticsTask curTask;

    public DroneAILogistics(IDrone drone, ProgWidgetAreaItemBase widget) {
        this.drone = IDroneBase.asDroneBase(drone);
        this.widget = widget;
    }

    private LogisticsManager getLogisticsManager() {
        Set<BlockPos> area;
        if (this.drone.getLogisticsManager() == null && !(area = this.widget.getCachedAreaSet()).isEmpty()) {
            Stream<ISemiBlock> semiBlocksInArea = SemiblockTracker.getInstance().getSemiblocksInArea(this.drone.getDroneLevel(), this.widget.getAreaExtents());
            Stream<ISemiBlock> logisticFrames = StreamUtils.ofType(AbstractLogisticsFrameEntity.class, semiBlocksInArea);
            LogisticsManager manager = new LogisticsManager();
            logisticFrames.filter(frame -> area.contains(frame.getBlockPos())).forEach(manager::addLogisticFrame);
            this.drone.setLogisticsManager(manager);
        }
        return this.drone.getLogisticsManager();
    }

    public boolean canUse() {
        if (this.getLogisticsManager() == null) {
            return false;
        }
        this.curTask = null;
        return this.doLogistics();
    }

    private boolean doLogistics() {
        ItemStack item = this.drone.getInv().getStackInSlot(0);
        FluidStack fluid = this.drone.getFluidTank().getFluid();
        PriorityQueue<LogisticsManager.LogisticsTask> tasks = this.getLogisticsManager().getTasks(item.isEmpty() ? fluid : item, true);
        if (!tasks.isEmpty()) {
            this.curTask = tasks.poll();
            return this.execute(this.curTask);
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.curTask == null) {
            return false;
        }
        if (!this.curAI.canContinueToUse()) {
            if (this.curAI instanceof DroneEntityAIInventoryImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingItem);
                return this.clearAIAndProvideAgain();
            }
            if (this.curAI instanceof DroneAILiquidImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingFluid);
                return this.clearAIAndProvideAgain();
            }
            this.curAI = null;
            return false;
        }
        this.curTask.informRequester();
        return true;
    }

    private boolean clearAIAndProvideAgain() {
        this.curAI = null;
        if (this.curTask.isStillValid(this.drone.getInv().getStackInSlot(0).isEmpty() ? this.drone.getFluidTank().getFluid() : this.drone.getInv().getStackInSlot(0)) && this.execute(this.curTask)) {
            return true;
        }
        this.curTask = null;
        return this.doLogistics();
    }

    public boolean execute(LogisticsManager.LogisticsTask task) {
        if (!this.drone.getInv().getStackInSlot(0).isEmpty() && !task.transportingItem.isEmpty()) {
            if (this.hasNoPathTo(task.requester.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryExport((IDrone)this.drone, new FakeWidgetLogistics(task.requester.getBlockPos(), task.requester.getSide(), task.transportingItem));
        } else if (this.drone.getFluidTank().getFluidAmount() > 0 && !task.transportingFluid.isEmpty()) {
            if (this.hasNoPathTo(task.requester.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidExport<FakeWidgetLogistics>(this.drone, new FakeWidgetLogistics(task.requester.getBlockPos(), task.requester.getSide(), task.transportingFluid));
        } else if (!task.transportingItem.isEmpty()) {
            if (this.hasNoPathTo(task.provider.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryImport((IDrone)this.drone, new FakeWidgetLogistics(task.provider.getBlockPos(), task.provider.getSide(), task.transportingItem));
        } else {
            if (this.hasNoPathTo(task.provider.getBlockPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidImport<FakeWidgetLogistics>(this.drone, new FakeWidgetLogistics(task.provider.getBlockPos(), task.provider.getSide(), task.transportingFluid));
        }
        if (this.curAI.canUse()) {
            task.informRequester();
            return true;
        }
        return false;
    }

    private boolean hasNoPathTo(BlockPos pos) {
        for (Direction d : DirectionUtil.VALUES) {
            if (!this.drone.isBlockValidPathfindBlock(pos.relative(d))) continue;
            return false;
        }
        this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.general.debug.cantNavigate", pos);
        return true;
    }

    private static class FakeWidgetLogistics
    extends ProgWidgetInventoryBase
    implements ILiquidFiltered,
    ILiquidExport {
        private final ItemStack stack;
        private final FluidStack fluid;
        private final Set<BlockPos> area;
        private final boolean[] sides = new boolean[6];

        FakeWidgetLogistics(BlockPos pos, Direction side, @Nonnull ItemStack stack) {
            super(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
            this.stack = stack;
            this.fluid = FluidStack.EMPTY;
            this.area = Set.of(pos);
            this.sides[side.get3DDataValue()] = true;
        }

        FakeWidgetLogistics(BlockPos pos, Direction side, FluidStack fluid) {
            super(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT);
            this.stack = ItemStack.EMPTY;
            this.fluid = fluid;
            this.area = Set.of(pos);
            this.sides[side.get3DDataValue()] = true;
        }

        private FakeWidgetLogistics(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields invBaseFields, ItemStack stack, FluidStack fluid, Set<BlockPos> area, boolean[] sides) {
            super(pos, invBaseFields);
            this.stack = stack;
            this.fluid = fluid;
            this.area = Set.copyOf(area);
            System.arraycopy(sides, 0, this.sides, 0, 6);
        }

        @Override
        public IProgWidget copyWidget() {
            return new FakeWidgetLogistics(this.getPosition(), this.invBaseFields().copy(), this.stack.copy(), this.fluid.copy(), Set.copyOf(this.area), Arrays.copyOf(this.sides, this.sides.length));
        }

        @Override
        public DyeColor getColor() {
            return DyeColor.WHITE;
        }

        @Override
        public Set<BlockPos> getArea(Set<BlockPos> area) {
            area.addAll(this.area);
            return area;
        }

        @Override
        public void setSides(boolean[] sides) {
        }

        @Override
        public boolean[] getSides() {
            return this.sides;
        }

        @Override
        public boolean isItemValidForFilters(@Nonnull ItemStack item) {
            return !item.isEmpty() && ItemStack.isSameItem((ItemStack)item, (ItemStack)this.stack);
        }

        @Override
        public ResourceLocation getTexture() {
            return null;
        }

        @Override
        public boolean useCount() {
            return true;
        }

        @Override
        public void setUseCount(boolean useCount) {
        }

        @Override
        public int getCount() {
            return !this.stack.isEmpty() ? this.stack.getCount() : this.fluid.getAmount();
        }

        @Override
        public void setCount(int count) {
        }

        @Override
        public boolean isFluidValid(Fluid fluid) {
            return fluid == this.fluid.getFluid();
        }

        @Override
        public void setPlaceFluidBlocks(boolean placeFluidBlocks) {
        }

        @Override
        public boolean isPlacingFluidBlocks() {
            return false;
        }

        @Override
        public ProgWidgetType<?> getType() {
            return ModProgWidgetTypes.LOGISTICS.get();
        }
    }
}

