/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.spawning;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.data.PneumaticCraftTags;
import me.desht.pneumaticcraft.api.item.ISpawnerCoreStats;
import me.desht.pneumaticcraft.api.misc.ITranslatableEnum;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRangedTE;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.inventory.VacuumTrapMenu;
import me.desht.pneumaticcraft.common.item.SpawnerCoreItem;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class VacuumTrapBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
MenuProvider,
ISerializableTanks,
IRangedTE {
    public static final String DEFENDER_TAG = "pneumaticcraft:defender";
    public static final int MEMORY_ESSENCE_AMOUNT = 100;
    private final SpawnerCoreItem.SpawnerCoreItemHandler inv = new SpawnerCoreItem.SpawnerCoreItemHandler(this);
    private final List<Mob> targetEntities = new ArrayList<Mob>();
    private final RangeManager rangeManager = new RangeManager(this, 0x60600060);
    @GuiSynced
    private final SmartSyncTank xpTank = new XPTank(this);
    @DescSynced
    private boolean isCoreLoaded;
    @DescSynced
    public Problems problem = Problems.OK;

    public VacuumTrapBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.VACUUM_TRAP.get(), pos, state, PressureTier.TIER_ONE, 10000, 4);
    }

    @Override
    public boolean hasFluidCapability() {
        return true;
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.xpTank.tick();
        this.rangeManager.setRange(3 + this.getUpgrades(ModUpgrades.RANGE.get()));
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (this.isOpen() && this.isCoreLoaded && this.nonNullLevel().random.nextBoolean()) {
            ClientUtils.emitParticles(this.level, this.worldPosition, (ParticleOptions)ParticleTypes.PORTAL);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.isCoreLoaded = this.inv.isCorePresent();
        if (this.isOpen() && this.isCoreLoaded && this.inv.getStats().getUnusedPercentage() > 0 && this.getPressure() <= this.getMinWorkingPressure()) {
            if ((this.nonNullLevel().getGameTime() & 0xFL) == 0L) {
                this.scanForEntities();
            }
            Vec3 trapVec = Vec3.atCenterOf((Vec3i)this.worldPosition);
            double min = this.nonNullLevel().getFluidState(this.worldPosition).getType() == Fluids.WATER ? 2.5 : 1.75;
            for (Mob e : this.targetEntities) {
                if (!e.isAlive() || e.getTags().contains(DEFENDER_TAG)) continue;
                if (e.distanceToSqr(trapVec) <= min) {
                    this.absorbEntity(e);
                    this.addAir((int)(10.0f * e.getHealth()));
                    continue;
                }
                e.getNavigation().moveTo(trapVec.x(), trapVec.y(), trapVec.z(), 1.2);
            }
        }
        this.problem = !this.isCoreLoaded ? Problems.NO_CORE : (this.inv.getStats().getUnusedPercentage() == 0 ? Problems.CORE_FULL : (!this.isOpen() ? Problems.TRAP_CLOSED : Problems.OK));
    }

    private void absorbEntity(Mob e) {
        ISpawnerCoreStats newStats;
        int toAdd = 1;
        if (this.xpTank.getFluid().getAmount() >= 100) {
            toAdd += e.level().random.nextInt(3) + 1;
        }
        if ((newStats = this.inv.getStats().addAmount(e.getType(), toAdd)) != this.inv.getStats()) {
            e.discard();
            if (toAdd > 1) {
                this.xpTank.drain(100, IFluidHandler.FluidAction.EXECUTE);
            }
            ItemStack stack = this.inv.getStackInSlot(0);
            stack.set(ModDataComponents.SPAWNER_CORE_STATS, (Object)newStats);
            this.inv.setStackInSlot(0, stack);
            e.level().playSound(null, this.worldPosition, SoundEvents.PORTAL_TRIGGER, SoundSource.BLOCKS, 1.0f, 2.0f);
            if (this.level instanceof ServerLevel) {
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.CLOUD, e.getX(), e.getY() + 0.5, e.getZ(), 5, 0.0, 1.0, 0.0, 0.0);
            }
        }
    }

    private void scanForEntities() {
        this.targetEntities.clear();
        this.targetEntities.addAll(this.nonNullLevel().getEntitiesOfClass(Mob.class, this.rangeManager.getExtentsAsAABB(), this::isApplicable));
    }

    private boolean isApplicable(LivingEntity e) {
        TamableAnimal t;
        return e.getType().is(PneumaticCraftTags.EntityTypes.VACUUM_TRAP_WHITELISTED) || !e.getType().is(Tags.EntityTypes.BOSSES) && !(e instanceof DroneEntity) && !(e instanceof Warden) && (!(e instanceof TamableAnimal) || !(t = (TamableAnimal)e).isTame()) && !e.getType().is(PneumaticCraftTags.EntityTypes.VACUUM_TRAP_BLACKLISTED);
    }

    @Override
    public IFluidHandler getFluidHandler(@Nullable Direction dir) {
        return this.xpTank;
    }

    public IFluidTank getFluidTank() {
        return this.xpTank;
    }

    @Override
    @Nonnull
    public Map<DataComponentType<SimpleFluidContent>, PNCFluidTank> getSerializableTanks() {
        return Map.of(ModDataComponents.MAIN_TANK.get(), this.xpTank);
    }

    @Override
    public IItemHandler getItemHandler(@javax.annotation.Nullable Direction dir) {
        return this.inv;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == Direction.DOWN || side.getAxis() == this.getRotation().getAxis();
    }

    @Override
    public float getMinWorkingPressure() {
        return -0.5f;
    }

    @javax.annotation.Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new VacuumTrapMenu(windowId, inv, this.getBlockPos());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inv.deserializeNBT(provider, tag.getCompound("Items"));
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inv.serializeNBT(provider));
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        if (!this.shouldPreserveStateOnBreak()) {
            super.getContentsToDrop(drops);
        }
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.inv.loadContainerContents((ItemContainerContents)componentInput.get(ModDataComponents.BLOCK_ENTITY_SAVED_INV));
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.shouldPreserveStateOnBreak()) {
            builder.set(ModDataComponents.BLOCK_ENTITY_SAVED_INV, (Object)this.inv.toContainerContents());
        }
    }

    public boolean isOpen() {
        return this.getBlockState().getBlock() == ModBlocks.VACUUM_TRAP.get() && (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.OPEN) != false;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    private class XPTank
    extends SmartSyncTank {
        public XPTank(VacuumTrapBlockEntity vacuumTrapBlockEntity) {
            super(vacuumTrapBlockEntity, 16000);
        }

        @Override
        public boolean isFluidValid(FluidStack stack) {
            return stack.getFluid().is(PneumaticCraftTags.Fluids.EXPERIENCE);
        }
    }

    public static enum Problems implements ITranslatableEnum
    {
        OK,
        NO_CORE,
        CORE_FULL,
        TRAP_CLOSED;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.vacuum_trap." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

