/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity.drone;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUITextFieldSensitive;
import me.desht.pneumaticcraft.common.drone.ProgWidgetUtils;
import me.desht.pneumaticcraft.common.drone.progwidgets.IAreaProvider;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetLabel;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.drone.progwidgets.SavedDroneProgram;
import me.desht.pneumaticcraft.common.inventory.ProgrammerMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketProgrammerSync;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModCriterionTriggers;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class ProgrammerBlockEntity
extends AbstractTickingBlockEntity
implements IGUITextFieldSensitive,
MenuProvider {
    private static final int PROGRAM_SLOT = 0;
    private static final int INVENTORY_SIZE = 1;
    private static final int MAX_HISTORY_SIZE = 20;
    public final List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final ProgrammerItemHandler inventory = new ProgrammerItemHandler();
    public double translatedX;
    public double translatedY;
    public int zoomState;
    public boolean showInfo = true;
    public boolean showFlow = true;
    @GuiSynced
    public boolean recentreStartPiece = false;
    @GuiSynced
    public boolean canUndo;
    @GuiSynced
    public boolean canRedo;
    @GuiSynced
    public boolean programOnInsert;
    @GuiSynced
    public int availablePuzzlePieces;
    @DescSynced
    public ItemStack displayedStack = ItemStack.EMPTY;
    private final List<Tag> history = new LinkedList<Tag>();
    private int historyIndex;

    public ProgrammerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.PROGRAMMER.get(), pos, state);
        this.history.add((Tag)new ListTag());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory.deserializeNBT(provider, tag.getCompound("Items"));
        this.displayedStack = this.inventory.getStackInSlot(0);
        this.programOnInsert = tag.getBoolean("ProgramOnInsert");
        this.history.addAll((Collection<Tag>)tag.getList("history", 9));
        if (this.history.isEmpty()) {
            this.history.add((Tag)new ListTag());
        }
        this.readProgWidgetsFromNBT((Tag)tag.getList("pneumaticcraft:progWidgets", 10), provider);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put("Items", (Tag)this.inventory.serializeNBT(provider));
        tag.put("history", (Tag)Util.make((Object)new ListTag(), l -> l.addAll(this.history)));
        tag.putBoolean("ProgramOnInsert", this.programOnInsert);
        tag.put("pneumaticcraft:progWidgets", ProgWidgetUtils.putWidgetsToNBT(provider, this.progWidgets));
    }

    public List<IProgWidget> mergeWidgetsFromNBT(List<IProgWidget> toMerge) {
        ArrayList<IProgWidget> result = new ArrayList<IProgWidget>(this.progWidgets);
        if (!this.progWidgets.isEmpty() && !toMerge.isEmpty()) {
            PuzzleExtents extents1 = this.getPuzzleExtents(this.progWidgets);
            PuzzleExtents extents2 = this.getPuzzleExtents(toMerge);
            for (IProgWidget w2 : toMerge) {
                w2.setPosition(w2.getX() - extents2.x() + extents1.x() + extents1.width() + 10, w2.getY() - extents2.y() + extents1.y());
            }
        }
        toMerge.forEach(w -> {
            if (w instanceof ProgWidgetStart) {
                ProgWidgetLabel label = new ProgWidgetLabel();
                label.setPosition(w.getX(), w.getY());
                result.add(label);
                ProgWidgetText text = ProgWidgetText.withText("Merge #" + this.nonNullLevel().getGameTime());
                text.setPosition(label.getX() + label.getWidth() / 2, label.getY());
                result.add(text);
            } else {
                result.add((IProgWidget)w);
            }
        });
        return result;
    }

    private PuzzleExtents getPuzzleExtents(List<IProgWidget> widgets) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (IProgWidget w : widgets) {
            minX = Math.min(minX, w.getX());
            maxX = Math.max(maxX, w.getX() + w.getWidth());
            minY = Math.min(minY, w.getY());
            maxY = Math.max(maxY, w.getY() + w.getHeight());
        }
        return new PuzzleExtents(minX, minY, maxX - minX, maxY - minY);
    }

    public void readProgWidgetsFromNBT(Tag tag, HolderLookup.Provider provider) {
        this.progWidgets.clear();
        this.progWidgets.addAll(ProgWidgetUtils.getWidgetsFromNBT(provider, tag));
        ProgWidgetUtils.updatePuzzleConnections(this.progWidgets);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        switch (tag) {
            case "program_when": {
                this.programOnInsert = !this.programOnInsert;
                this.setChanged();
                break;
            }
            case "import": {
                this.tryImport(shiftHeld);
                break;
            }
            case "export": {
                this.tryProgramDrone((Player)player);
                break;
            }
            case "undo": {
                this.undo();
                break;
            }
            case "redo": {
                this.redo();
            }
        }
        this.sendDescriptionPacket();
    }

    @Nonnull
    public ItemStack getItemInProgrammingSlot() {
        return this.inventory.getStackInSlot(0);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable Direction dir) {
        return this.inventory;
    }

    @Override
    public void setText(int textFieldID, String text) {
        ItemStack stack = this.inventory.getStackInSlot(0).copy();
        if (textFieldID == 0 && !stack.isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)text));
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public String getText(int textFieldID) {
        return this.inventory.getStackInSlot(0).getHoverName().getString();
    }

    private void tryImport(boolean merge) {
        List<IProgWidget> newWidgets;
        List<IProgWidget> saved = SavedDroneProgram.loadProgWidgets(this.inventory.getStackInSlot(0));
        List<IProgWidget> list = newWidgets = merge ? this.mergeWidgetsFromNBT(saved) : saved;
        if (!newWidgets.isEmpty()) {
            List<IProgWidget> widgets = merge ? this.mergeWidgetsFromNBT(newWidgets) : newWidgets;
            this.setProgWidgets(widgets, null);
        } else if (!merge) {
            this.setProgWidgets(List.of(), null);
        }
    }

    private void tryProgramDrone(Player player) {
        if (this.inventory.getStackInSlot(0).getItem() instanceof IProgrammable) {
            if (player == null || !player.isCreative()) {
                int required = this.getRequiredPuzzleCount();
                if (required > 0) {
                    if (!this.takePuzzlePieces(player, true)) {
                        if (player instanceof ServerPlayer) {
                            NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundSource.BLOCKS, this.getBlockPos(), 1.0f, 1.5f, false), (ServerPlayer)player);
                        }
                        return;
                    }
                    this.takePuzzlePieces(player, false);
                } else if (required < 0) {
                    this.returnPuzzlePieces(player, -required);
                }
            }
            ItemStack stack = this.inventory.getStackInSlot(0);
            SavedDroneProgram.writeToItem(stack, this.progWidgets);
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                NetworkHandler.sendToPlayer(new PacketPlaySound((SoundEvent)ModSounds.HUD_INIT_COMPLETE.get(), SoundSource.BLOCKS, this.getBlockPos(), 1.0f, 1.0f, false), sp);
                ModCriterionTriggers.PROGRAM_DRONE.get().trigger(sp);
            }
        }
    }

    private void returnPuzzlePieces(@Nullable Player player, int count) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.PROGRAMMING_PUZZLE.get());
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity te = this.getCachedNeighbor(d);
            if (te != null) {
                while (count > 0) {
                    int toInsert = Math.min(count, stack.getMaxStackSize());
                    int inserted = IOHelper.getInventoryForBlock(te, d.getOpposite()).map(h -> {
                        ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)stack.copyWithCount(toInsert), (boolean)false);
                        return toInsert - excess.getCount();
                    }).orElse(0);
                    if (inserted == 0) break;
                    count -= inserted;
                }
            }
            if (count > 0) continue;
            return;
        }
        while (count > 0) {
            int size = Math.min(count, stack.getMaxStackSize());
            if (player != null) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.copyWithCount(size));
            } else {
                PneumaticCraftUtils.dropItemOnGround(stack.copyWithCount(size), this.getLevel(), this.getBlockPos());
            }
            count -= size;
        }
    }

    public int getRequiredPuzzleCount() {
        IProgrammable programmable;
        ItemStack stackInSlot = this.inventory.getStackInSlot(0);
        Item item = stackInSlot.getItem();
        if (item instanceof IProgrammable && (programmable = (IProgrammable)item).usesPieces(stackInSlot)) {
            int dronePieces = SavedDroneProgram.fromItemStack(stackInSlot).getRequiredPuzzlePieces();
            int required = (int)this.progWidgets.stream().filter(p -> !p.freeToUse()).count();
            return (required - dronePieces) * stackInSlot.getCount();
        }
        return 0;
    }

    private boolean takePuzzlePieces(@Nullable Player player, boolean simulate) {
        int required = this.getRequiredPuzzleCount();
        if (required <= 0) {
            return true;
        }
        int found = 0;
        if (player != null && (found += this.extractPuzzlePieces((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), required, simulate)) >= required) {
            return true;
        }
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity te = this.getCachedNeighbor(d);
            if (te == null) continue;
            int r = required - found;
            if ((found += IOHelper.getInventoryForBlock(te, d.getOpposite()).map(h -> this.extractPuzzlePieces((IItemHandler)h, r, simulate)).orElse(0).intValue()) < required) continue;
            return true;
        }
        return false;
    }

    private int extractPuzzlePieces(IItemHandler handler, int max, boolean simulate) {
        int n = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extracted;
            ItemStack stackInSlot = handler.getStackInSlot(i);
            if (stackInSlot.getItem() != ModItems.PROGRAMMING_PUZZLE.get() || (n += (extracted = handler.extractItem(i, Math.min(max - n, stackInSlot.getMaxStackSize()), simulate)).getCount()) < max) continue;
            return n;
        }
        return n;
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (IProgWidget widget : this.progWidgets) {
            if (!(widget instanceof IVariableWidget)) continue;
            ((IVariableWidget)((Object)widget)).addVariables(variables);
        }
        variables.remove("");
        return variables;
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if ((this.nonNullLevel().getGameTime() & 0xFL) == 0L && this.countPlayersUsing() > 0) {
            int total = 0;
            for (Direction dir : DirectionUtil.VALUES) {
                BlockEntity te = this.getCachedNeighbor(dir);
                if (te == null) continue;
                total += IOHelper.getInventoryForBlock(te, dir.getOpposite()).map(handler -> IOHelper.countItems(handler, stack -> stack.getItem() == ModItems.PROGRAMMING_PUZZLE.get())).orElse(0).intValue();
            }
            this.availablePuzzlePieces = total;
        }
    }

    public void previewArea(IProgWidget progWidget) {
        if (progWidget == null) {
            AreaRenderManager.getInstance().removeHandlers(this);
        } else if (progWidget instanceof IAreaProvider) {
            IAreaProvider areaProvider = (IAreaProvider)((Object)progWidget);
            HashSet<BlockPos> area = new HashSet<BlockPos>();
            areaProvider.getArea(area);
            AreaRenderManager.getInstance().showArea(area, -1878982912, (BlockEntity)this);
        }
    }

    private void saveToHistory(HolderLookup.Provider provider) {
        Tag tag = ProgWidgetUtils.putWidgetsToNBT(provider, this.progWidgets);
        if (this.history.isEmpty() || !this.history.get(this.historyIndex).equals((Object)tag)) {
            while (this.history.size() > this.historyIndex + 1) {
                this.history.remove(this.historyIndex + 1);
            }
            this.history.add(tag);
            if (this.history.size() > 20) {
                this.history.removeFirst();
            }
            this.historyIndex = this.history.size() - 1;
            this.updateUndoRedoState();
        }
    }

    private void undo() {
        if (this.canUndo) {
            --this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.get(this.historyIndex), (HolderLookup.Provider)this.nonNullLevel().registryAccess());
            this.updateUndoRedoState();
            this.syncToClient(null);
        }
    }

    private void redo() {
        if (this.canRedo) {
            ++this.historyIndex;
            this.readProgWidgetsFromNBT(this.history.get(this.historyIndex), (HolderLookup.Provider)this.nonNullLevel().registryAccess());
            this.updateUndoRedoState();
            this.syncToClient(null);
        }
    }

    private void updateUndoRedoState() {
        this.canUndo = this.historyIndex > 0;
        this.canRedo = this.historyIndex < this.history.size() - 1;
        this.setChanged();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
        return new ProgrammerMenu(i, playerInventory, this.getBlockPos());
    }

    public void setProgWidgets(List<IProgWidget> widgets, Player player) {
        this.progWidgets.clear();
        this.progWidgets.addAll(widgets);
        ProgWidgetUtils.updatePuzzleConnections(this.progWidgets);
        if (!this.nonNullLevel().isClientSide) {
            this.setChanged();
            this.saveToHistory((HolderLookup.Provider)this.nonNullLevel().registryAccess());
            this.syncToClient(player);
        }
    }

    private void syncToClient(Player updatingPlayer) {
        if (!this.nonNullLevel().isClientSide) {
            List players = this.nonNullLevel().getEntitiesOfClass(ServerPlayer.class, new AABB(this.worldPosition).inflate(5.0));
            for (ServerPlayer player : players) {
                if (player == updatingPlayer || !(player.containerMenu instanceof ProgrammerMenu)) continue;
                NetworkHandler.sendToPlayer(PacketProgrammerSync.forBlockEntity(this), player);
            }
        }
    }

    private class ProgrammerItemHandler
    extends BaseItemStackHandler {
        ProgrammerItemHandler() {
            super(ProgrammerBlockEntity.this, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (ProgrammerBlockEntity.this.programOnInsert && slot == 0 && !this.getStackInSlot(slot).isEmpty() && !this.te.getLevel().isClientSide) {
                ProgrammerBlockEntity.this.tryProgramDrone(null);
            }
            ProgrammerBlockEntity.this.displayedStack = this.getStackInSlot(slot);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return IProgrammable.isProgrammable(itemStack);
        }
    }

    private record PuzzleExtents(int x, int y, int width, int height) {
    }
}

