/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import me.desht.pneumaticcraft.api.remote.BaseSettings;
import me.desht.pneumaticcraft.api.remote.IRemoteWidget;
import me.desht.pneumaticcraft.api.remote.WidgetSettings;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteEditorScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetComboBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.inventory.RemoteMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractRemoteConfigScreen<R extends IRemoteWidget>
extends AbstractPneumaticCraftScreen {
    protected final R remoteWidget;
    final RemoteEditorScreen guiRemote;
    protected WidgetTextField labelField;
    protected WidgetTextField tooltipField;
    protected WidgetComboBox enableField;
    protected WidgetTextFieldNumber xValueField;
    protected WidgetTextFieldNumber yValueField;
    protected WidgetTextFieldNumber zValueField;
    protected WidgetButtonExtended enableVarTypeButton;
    private boolean playerGlobalEnableVar;

    public AbstractRemoteConfigScreen(R remoteWidget, RemoteEditorScreen guiRemote) {
        super((Component)Component.translatable((String)remoteWidget.getTranslationKey()));
        this.remoteWidget = remoteWidget;
        this.guiRemote = guiRemote;
        this.xSize = 183;
        this.ySize = 202;
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(graphics, mouseX, mouseY, partialTick);
        GuiUtils.drawScreenWithTitleArea(graphics, this.guiLeft, this.guiTop, this.xSize, this.ySize, -2238534);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return null;
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void init() {
        super.init();
        GlobalVariableHelper variableHelper = GlobalVariableHelper.getInstance();
        BaseSettings baseSettings = this.remoteWidget.baseSettings();
        this.playerGlobalEnableVar = baseSettings.enableVariable().isEmpty() || baseSettings.enableVariable().startsWith("#");
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.enable", new Object[0]), this.guiLeft + 10, this.guiTop + 150);
        this.addLabel(this.title, this.width / 2, this.guiTop + 5, WidgetLabel.Alignment.CENTRE);
        this.enableVarTypeButton = new WidgetButtonExtended(this.guiLeft + 10, this.guiTop + 158, 12, 14, variableHelper.getVarPrefix(this.playerGlobalEnableVar), b -> this.togglePlayerGlobalEnable()).setTooltipKey("pneumaticcraft.gui.remote.varType.tooltip");
        this.addRenderableWidget((GuiEventListener)this.enableVarTypeButton);
        if (this.remoteWidget.hasConfigurableText()) {
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.text", new Object[0]), this.guiLeft + 10, this.guiTop + 20);
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.tooltip", new Object[0]), this.guiLeft + 10, this.guiTop + 46);
        }
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.enableValue", new Object[0]), this.guiLeft + 10, this.guiTop + 175);
        this.addLabel((Component)Component.literal((String)"X:"), this.guiLeft + 10, this.guiTop + 186);
        this.addLabel((Component)Component.literal((String)"Y:"), this.guiLeft + 67, this.guiTop + 186);
        this.addLabel((Component)Component.literal((String)"Z:"), this.guiLeft + 124, this.guiTop + 186);
        this.enableField = new WidgetComboBox(this.font, this.guiLeft + 23, this.guiTop + 159, 147);
        this.enableField.setElements(this.extractVarnames(this.playerGlobalEnableVar));
        this.enableField.setValue(variableHelper.stripVarPrefix(baseSettings.enableVariable()));
        this.enableField.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.enable.tooltip", new Object[0])));
        this.addRenderableWidget((GuiEventListener)this.enableField);
        MutableComponent valueTooltip = PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.enableValue.tooltip", new Object[0]);
        this.xValueField = new WidgetTextFieldNumber(this.font, this.guiLeft + 20, this.guiTop + 184, 38);
        this.xValueField.setValue(baseSettings.enablingValue().getX());
        this.xValueField.setTooltip(Tooltip.create((Component)valueTooltip));
        this.addRenderableWidget((GuiEventListener)this.xValueField);
        this.yValueField = new WidgetTextFieldNumber(this.font, this.guiLeft + 78, this.guiTop + 184, 38);
        this.yValueField.setValue(baseSettings.enablingValue().getY());
        this.yValueField.setTooltip(Tooltip.create((Component)valueTooltip));
        this.addRenderableWidget((GuiEventListener)this.yValueField);
        this.zValueField = new WidgetTextFieldNumber(this.font, this.guiLeft + 136, this.guiTop + 184, 38);
        this.zValueField.setValue(baseSettings.enablingValue().getZ());
        this.zValueField.setTooltip(Tooltip.create((Component)valueTooltip));
        this.addRenderableWidget((GuiEventListener)this.zValueField);
        if (this.remoteWidget.hasConfigurableText()) {
            this.labelField = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 29, 160);
            this.labelField.setMaxLength(2048);
            this.labelField.setValue(this.toJsonString(this.remoteWidget.widgetSettings().title()));
            this.labelField.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.label.tooltip", new Object[0])));
            this.addRenderableWidget((GuiEventListener)this.labelField);
            this.tooltipField = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 55, 160);
            this.tooltipField.setMaxLength(2048);
            this.tooltipField.setValue(this.toJsonString(this.remoteWidget.widgetSettings().tooltip()));
            this.addRenderableWidget((GuiEventListener)this.tooltipField);
        }
    }

    private void togglePlayerGlobalEnable() {
        this.playerGlobalEnableVar = !this.playerGlobalEnableVar;
        this.enableVarTypeButton.setMessage((Component)Component.literal((String)GlobalVariableHelper.getInstance().getVarPrefix(this.playerGlobalEnableVar)));
        this.enableField.setElements(this.extractVarnames(this.playerGlobalEnableVar));
    }

    public void onClose() {
        R newWidget = this.makeUpdatedRemoteWidget();
        if (newWidget != null) {
            this.guiRemote.updateWidgetFromConfigScreen((IRemoteWidget)newWidget);
        }
        this.minecraft.setScreen((Screen)this.guiRemote);
    }

    protected R makeUpdatedRemoteWidget() {
        return null;
    }

    protected BaseSettings makeBaseSettings() {
        return new BaseSettings(GlobalVariableHelper.getInstance().getPrefixedVar(this.enableField.getValue(), this.playerGlobalEnableVar), new BlockPos(this.xValueField.getIntValue(), this.yValueField.getIntValue(), this.zValueField.getIntValue()));
    }

    protected WidgetSettings makeWidgetSettings() {
        WidgetSettings res = this.remoteWidget.widgetSettings();
        if (this.remoteWidget.hasConfigurableText()) {
            res = res.withText(this.fromJson(this.labelField.getValue()), this.fromJson(this.tooltipField.getValue()));
        }
        return res;
    }

    private Component fromJson(String text) {
        try {
            if (!(((String)text).startsWith("\"") || ((String)text).startsWith("{") || ((String)text).startsWith("["))) {
                text = "\"" + (String)text + "\"";
            }
            JsonElement json = JsonParser.parseString((String)text);
            return (Component)ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonSyntaxException::new);
        }
        catch (JsonParseException e) {
            return Component.literal((String)("<parse error>: " + e.getMessage()));
        }
    }

    private String toJsonString(Component component) {
        JsonElement element = (JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)component).result().orElse(new JsonPrimitive("<encode error>"));
        String str = element.toString();
        if (str.startsWith("\"") && str.endsWith("\"")) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    protected List<String> extractVarnames(boolean playerGlobal) {
        return ((RemoteMenu)this.guiRemote.getMenu()).allKnownGlobalVars().stream().filter(v -> playerGlobal && v.startsWith("#") || !playerGlobal && v.startsWith("%")).map(v -> v.substring(1)).toList();
    }
}

