/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor.options;

import java.util.Optional;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IClientArmorRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IKeybindingButton;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.KeyHandler;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.AbstractSliderOptions;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.JetBootsClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.JetBootsHandler;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;

public class JetBootsOptions
extends AbstractSliderOptions<JetBootsClientHandler> {
    private ICheckboxWidget checkBoxBuilderMode;
    private ICheckboxWidget checkBoxStabilizers;
    private IKeybindingButton changeKeybindingButton;

    public JetBootsOptions(IGuiScreen screen, JetBootsClientHandler upgradeHandler) {
        super(screen, upgradeHandler);
    }

    @Override
    public void populateGui(IGuiScreen gui) {
        super.populateGui(gui);
        IClientArmorRegistry registry = PneumaticRegistry.getInstance().getClientArmorRegistry();
        ResourceLocation ownerID = ((JetBootsClientHandler)this.getClientUpgradeHandler()).getID();
        this.checkBoxBuilderMode = registry.makeKeybindingCheckBox(JetBootsClientHandler.MODULE_BUILDER_MODE, 5, 60, -1, b -> this.setFlag(ModDataComponents.JET_BOOTS_BUILDER_MODE.get(), 3, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(this.checkBoxBuilderMode.asWidget());
        this.checkBoxStabilizers = registry.makeKeybindingCheckBox(JetBootsClientHandler.MODULE_FLIGHT_STABILIZERS, 5, 75, -1, b -> this.setFlag(ModDataComponents.JET_BOOTS_STABILIZERS.get(), 4, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(this.checkBoxStabilizers.asWidget());
        ICheckboxWidget hover = registry.makeKeybindingCheckBox(JetBootsClientHandler.MODULE_HOVER, 5, 90, -1, b -> this.setFlag(ModDataComponents.JET_BOOTS_HOVER.get(), 1, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(hover.asWidget());
        ICheckboxWidget smartHover = registry.makeKeybindingCheckBox(JetBootsClientHandler.MODULE_SMART_HOVER, 5, 105, -1, b -> this.setFlag(ModDataComponents.JET_BOOTS_SMART_HOVER.get(), 1, (ICheckboxWidget)b)).withOwnerUpgradeID(ownerID);
        gui.addWidget(smartHover.asWidget());
        this.changeKeybindingButton = registry.makeKeybindingButton(155, KeyHandler.getInstance().keybindJetBoots);
        gui.addWidget(this.changeKeybindingButton.asWidget());
        gui.addWidget(ClientArmorRegistry.getInstance().makeStatMoveButton(30, 177, (IArmorUpgradeClientHandler<?>)this.getClientUpgradeHandler()));
    }

    @Override
    protected PointXY getSliderPos() {
        return new PointXY(30, 125);
    }

    @Override
    protected DataComponentType<Integer> getIntegerComponent() {
        return ModDataComponents.JET_BOOTS_PCT.get();
    }

    private void setFlag(DataComponentType<Boolean> componentType, int minTier, ICheckboxWidget cb) {
        CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
        if (commonArmorHandler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get()) >= minTier) {
            JetBootsHandler upgradeHandler = (JetBootsHandler)((JetBootsClientHandler)this.getClientUpgradeHandler()).getCommonHandler();
            PacketUpdateArmorExtraData.sendToServer(upgradeHandler, componentType, cb.isChecked());
            upgradeHandler.onDataFieldUpdated(CommonArmorHandler.getHandlerForPlayer(), componentType, cb.isChecked());
            ResourceLocation ownerId = upgradeHandler.getID();
            HUDHandler.getInstance().addFeatureToggleMessage(IArmorUpgradeHandler.getStringKey(ownerId), IArmorUpgradeHandler.getStringKey(cb.getUpgradeId()), cb.isChecked());
        }
    }

    @Override
    public void tick() {
        super.tick();
        int nUpgrades = CommonArmorHandler.getHandlerForPlayer().getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get());
        this.checkBoxBuilderMode.asWidget().active = nUpgrades >= 3;
        this.checkBoxStabilizers.asWidget().active = nUpgrades >= 4;
    }

    @Override
    protected Component getPrefix() {
        return Component.literal((String)"Power: ");
    }

    @Override
    protected Component getSuffix() {
        return Component.literal((String)"%");
    }

    @Override
    public Optional<IKeybindingButton> getKeybindingButton() {
        return Optional.of(this.changeKeybindingButton);
    }
}

