/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.common.util.PastebinHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.legacyconv.ConversionType;
import me.desht.pneumaticcraft.lib.Log;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class PastebinScreen
extends AbstractPneumaticCraftScreen {
    private final ConversionType conversionType;
    private WidgetTextField usernameBox;
    private WidgetTextField passwordBox;
    private WidgetTextField pastebinBox;
    private final Screen parentScreen;
    private Component statusMessage = Component.empty();
    private Component lastMessage = Component.empty();
    private int messageTimer;
    private EnumState state = EnumState.NONE;
    boolean shouldMerge;
    private final JsonElement input;
    private JsonElement output;

    public PastebinScreen(Screen parentScreen, JsonElement input, ConversionType conversionType) {
        super((Component)Component.literal((String)"Pastebin"));
        this.xSize = 183;
        this.ySize = 202;
        this.conversionType = conversionType;
        this.parentScreen = parentScreen;
        this.input = input;
    }

    @Override
    public void init() {
        super.init();
        if (!PastebinHandler.isLoggedIn()) {
            this.usernameBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 30, 80);
            this.addRenderableWidget((GuiEventListener)this.usernameBox);
            this.passwordBox = new WidgetTextField(this.font, this.guiLeft + 10, this.guiTop + 56, 80).setAsPasswordBox();
            this.addRenderableWidget((GuiEventListener)this.passwordBox);
            WidgetButtonExtended loginButton = new WidgetButtonExtended(this.guiLeft + 100, this.guiTop + 30, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.login", new Object[0]), b -> this.login());
            loginButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loginOptional", new Object[0]));
            this.addRenderableWidget((GuiEventListener)loginButton);
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.username", new Object[0]), this.guiLeft + 10, this.guiTop + 20);
            this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.password", new Object[0]), this.guiLeft + 10, this.guiTop + 46);
        } else {
            WidgetButtonExtended logoutButton = new WidgetButtonExtended(this.guiLeft + 60, this.guiTop + 30, 60, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.logout", new Object[0]), b -> this.logout());
            this.addRenderableWidget((GuiEventListener)logoutButton);
        }
        this.pastebinBox = new WidgetTextField(this, this.font, this.guiLeft + 10, this.guiTop + 130, 160){

            public void setFocused(boolean focused) {
                boolean previousFocus = this.isFocused();
                super.setFocused(focused);
                if (previousFocus != focused && focused) {
                    this.moveCursorToEnd(true);
                    this.setHighlightPos(0);
                }
            }
        };
        this.addRenderableWidget((GuiEventListener)this.pastebinBox);
        WidgetButtonExtended pasteButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 78, 120, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.upload", new Object[0]), b -> this.sendToPastebin());
        this.addRenderableWidget((GuiEventListener)pasteButton);
        WidgetButtonExtended getButton = new WidgetButtonExtended(this.guiLeft + 31, this.guiTop + 167, 120, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.get", new Object[0]), b -> this.getFromPastebin());
        this.addRenderableWidget((GuiEventListener)getButton);
        WidgetButtonExtended putInClipBoard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 78, 20, 20, (Component)Component.empty(), b -> this.putToClipboard());
        putInClipBoard.setRenderedIcon(Textures.GUI_COPY_ICON_LOCATION);
        putInClipBoard.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.copyToClipboard", new Object[0]));
        this.addRenderableWidget((GuiEventListener)putInClipBoard);
        WidgetButtonExtended retrieveFromClipboard = new WidgetButtonExtended(this.guiLeft + 8, this.guiTop + 167, 20, 20, (Component)Component.empty(), b -> this.getFromClipboard());
        retrieveFromClipboard.setRenderedIcon(Textures.GUI_PASTE_ICON_LOCATION);
        retrieveFromClipboard.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.button.loadFromClipboard", new Object[0]));
        this.addRenderableWidget((GuiEventListener)retrieveFromClipboard);
        if (this.parentScreen instanceof ProgrammerScreen) {
            WidgetCheckBox mergeCB = new WidgetCheckBox(0, this.guiTop + 155, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.merge", new Object[0]), b -> {
                this.shouldMerge = b.checked;
            });
            mergeCB.setX(this.guiLeft + (170 - mergeCB.getWidth()));
            mergeCB.setTooltip(Tooltip.create((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.merge.tooltip", new Object[0])));
            this.addRenderableWidget((GuiEventListener)mergeCB);
        }
        this.addLabel((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.pastebinLink", new Object[0]), this.guiLeft + 10, this.guiTop + 120);
    }

    public JsonElement getOutput() {
        return this.output;
    }

    private void login() {
        PastebinHandler.login(this.usernameBox.getValue(), this.passwordBox.getValue());
        this.state = EnumState.LOGIN;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.loggingIn", new Object[0]);
    }

    private void logout() {
        PastebinHandler.logout();
        this.state = EnumState.LOGOUT;
    }

    private void sendToPastebin() {
        PastebinHandler.put(this.input.toString());
        this.state = EnumState.PUTTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadingToPastebin", new Object[0]);
    }

    private void putToClipboard() {
        this.minecraft.keyboardHandler.setClipboard(this.input.toString());
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.clipboardSetToContents", new Object[0]);
    }

    private void getFromPastebin() {
        PastebinHandler.get(this.pastebinBox.getValue());
        this.state = EnumState.GETTING;
        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievingFromPastebin", new Object[0]);
    }

    private void getFromClipboard() {
        this.readFromString(this.minecraft.keyboardHandler.getClipboard());
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state == EnumState.LOGOUT) {
            this.state = EnumState.NONE;
            this.init(this.minecraft, this.width, this.height);
        }
        if (this.state != EnumState.NONE && PastebinHandler.isDone()) {
            this.statusMessage = Component.empty();
            switch (this.state.ordinal()) {
                case 1: {
                    String pastebinText = PastebinHandler.getHandler().contents;
                    if (pastebinText != null) {
                        this.readFromString(pastebinText);
                        break;
                    }
                    this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidPastebin", new Object[0]);
                    break;
                }
                case 2: {
                    if (PastebinHandler.getException() != null) {
                        this.statusMessage = Component.literal((String)PastebinHandler.getException().getMessage());
                        break;
                    }
                    String pastebinText = PastebinHandler.getHandler().getLink;
                    if (pastebinText == null) {
                        pastebinText = "<ERROR>";
                    }
                    if (pastebinText.contains("pastebin.com")) {
                        this.pastebinBox.setValue(pastebinText);
                        this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.uploadedToPastebin", new Object[0]));
                        break;
                    }
                    this.statusMessage = Component.literal((String)pastebinText);
                    break;
                }
                case 3: {
                    if (!PastebinHandler.isLoggedIn()) {
                        this.statusMessage = PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidLogin", new Object[0]);
                    }
                    this.init();
                }
            }
            this.state = EnumState.NONE;
        }
        if (this.messageTimer > 0 && --this.messageTimer <= 0) {
            this.lastMessage = Component.empty();
        }
    }

    private void setTempMessage(Component msg) {
        this.lastMessage = msg;
        this.messageTimer = 60;
    }

    private void readFromString(String string) {
        try {
            JsonObject json = JsonParser.parseString((String)string).getAsJsonObject();
            int version = this.conversionType.determineVersion(json);
            if (version < 3) {
                for (int i = version; i < 3; ++i) {
                    this.conversionType.convertLegacy(json, i);
                }
            } else if (version > 3) {
                throw new JsonSyntaxException("unexpected input version " + version + ": current is 3");
            }
            this.output = json;
            this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.retrievedFromPastebin", new Object[0]));
        }
        catch (Exception e) {
            Log.error("JSON parse error: {}", e.getMessage());
            this.setTempMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pastebin.invalidFormattedPastebin", new Object[0]).withStyle(ChatFormatting.GOLD));
        }
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        this.renderBackground(graphics, x, y, partialTicks);
        super.render(graphics, x, y, partialTicks);
        if (!this.statusMessage.getString().isEmpty()) {
            graphics.drawString(this.font, this.statusMessage, this.guiLeft + 5, this.guiTop + 5, -256, false);
        } else if (!this.lastMessage.getString().isEmpty()) {
            graphics.drawString(this.font, this.lastMessage, this.guiLeft + 5, this.guiTop + 5, -16711936, false);
        }
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_PASTEBIN;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static enum EnumState {
        NONE,
        GETTING,
        PUTTING,
        LOGIN,
        LOGOUT;

    }
}

