/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.heat;

import java.util.function.BiPredicate;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public interface IHeatExchangerAdapter
extends IHeatExchangerLogic {
    @Override
    default public void tick() {
    }

    @Override
    default public void initializeAsHull(Level level, BlockPos pos, BiPredicate<LevelAccessor, BlockPos> blockFilter, Direction ... validSides) {
    }

    @Override
    default public void initializeAmbientTemperature(Level level, BlockPos pos) {
    }

    @Override
    default public void setTemperature(double temperature) {
    }

    @Override
    default public int getTemperatureAsInt() {
        return (int)this.getTemperature();
    }

    @Override
    default public void setThermalResistance(double thermalResistance) {
    }

    @Override
    default public void setThermalCapacity(double capacity) {
    }

    public static abstract class Simple<CAP>
    implements IHeatExchangerAdapter {
        protected final Direction side;
        protected final CAP foreignHeatCap;
        protected final double ambientTemperature;

        public Simple(Direction side, CAP foreignHeatCap, double ambientTemperature) {
            this.side = side;
            this.foreignHeatCap = foreignHeatCap;
            this.ambientTemperature = ambientTemperature;
        }

        @Override
        public double getAmbientTemperature() {
            return this.ambientTemperature;
        }

        @Override
        public boolean isSideConnected(Direction side) {
            return this.side == side;
        }
    }
}

