/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.Validate;

public class TemperatureRange {
    public static final Codec<TemperatureRange> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("min", (Object)0).forGetter(TemperatureRange::getMin), (App)Codec.INT.optionalFieldOf("max", (Object)Integer.MAX_VALUE).forGetter(TemperatureRange::getMax)).apply((Applicative)instance, TemperatureRange::of)).validate(TemperatureRange::validate);
    public static StreamCodec<ByteBuf, TemperatureRange> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TemperatureRange::getMin, (StreamCodec)ByteBufCodecs.INT, TemperatureRange::getMax, TemperatureRange::new);
    private static final TemperatureRange INVALID = new TemperatureRange(0, 1){

        @Override
        public boolean inRange(int temp) {
            return false;
        }

        @Override
        public boolean inRange(double temp) {
            return false;
        }
    };
    private static final TemperatureRange ANY = new TemperatureRange(0, Integer.MAX_VALUE);
    private final int min;
    private final int max;

    private TemperatureRange(int min, int max) {
        Validate.isTrue((min >= 0 && max >= 0 ? 1 : 0) != 0, (String)"negative temperatures are not accepted!", (Object[])new Object[0]);
        Validate.isTrue((min < max ? 1 : 0) != 0, (String)"min temp must be < max temp!", (Object[])new Object[0]);
        this.min = min;
        this.max = max;
    }

    private static DataResult<TemperatureRange> validate(TemperatureRange range) {
        return range.min < range.max ? DataResult.success((Object)range) : DataResult.error(() -> "min must be < max", (Object)range);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public static TemperatureRange of(int minTemp, int maxTemp) {
        return minTemp == 0 && maxTemp == Integer.MAX_VALUE ? TemperatureRange.any() : new TemperatureRange(minTemp, maxTemp);
    }

    public static TemperatureRange any() {
        return ANY;
    }

    public static TemperatureRange min(int minTemp) {
        return new TemperatureRange(minTemp, Integer.MAX_VALUE);
    }

    public static TemperatureRange max(int maxTemp) {
        return new TemperatureRange(0, maxTemp);
    }

    public boolean inRange(int temp) {
        return temp >= this.min && temp <= this.max;
    }

    public boolean inRange(double temp) {
        return (int)temp >= this.min && (int)temp <= this.max;
    }

    public static TemperatureRange invalid() {
        return INVALID;
    }

    public boolean isAny() {
        return this == ANY;
    }

    public boolean hasMin() {
        return this.min > 0;
    }

    public boolean hasMax() {
        return this.max < Integer.MAX_VALUE;
    }

    public String asString(TemperatureScale scale) {
        if (this.isAny()) {
            return "any";
        }
        if (this == TemperatureRange.invalid()) {
            return "invalid";
        }
        if (this.min > -2147483647) {
            if (this.max < Integer.MAX_VALUE) {
                return scale.convertFromKelvin(this.min) + scale.symbol() + " - " + scale.convertFromKelvin(this.max) + scale.symbol();
            }
            return ">= " + scale.convertFromKelvin(this.min) + scale.symbol();
        }
        if (this.max < Integer.MAX_VALUE) {
            return "<= " + scale.convertFromKelvin(this.max) + scale.symbol();
        }
        return "any";
    }

    public static enum TemperatureScale {
        KELVIN("K"),
        CELSIUS("\u00b0C"),
        FAHRENHEIT("\u00b0F");

        private final String symbol;

        private TemperatureScale(String symbol) {
            this.symbol = symbol;
        }

        public float convertFromKelvin(float tempIn) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> tempIn - 273.0f;
                case 2 -> (tempIn - 273.0f) * 1.8f + 32.0f;
                case 0 -> tempIn;
            };
        }

        public String symbol() {
            return this.symbol;
        }
    }
}

