/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.mixin;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.hat.CowboyHatItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin {
    LivingEntityMixin() {
    }

    @Inject(method={"travelRidden"}, at={@At(value="HEAD")}, cancellable=true)
    private void travelRidden(Player player, Vec3 vec, CallbackInfo ci) {
        CowboyHatItem relic;
        Mob mounted;
        ItemStack stack;
        block7: {
            block6: {
                stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.COWBOY_HAT.value()));
                LivingEntity livingEntity = (LivingEntity)this;
                if (!(livingEntity instanceof Mob)) break block6;
                mounted = (Mob)livingEntity;
                livingEntity = stack.getItem();
                if (livingEntity instanceof CowboyHatItem && (relic = (CowboyHatItem)livingEntity).getToggled(stack)) break block7;
            }
            return;
        }
        if (!mounted.isControlledByLocalInstance()) {
            mounted.setDeltaMovement(Vec3.ZERO);
            mounted.setSpeed(0.0f);
            mounted.calculateEntityAnimation(false);
        }
        float speed = player.getSpeed();
        mounted.setTarget(null);
        mounted.setSpeed((float)((double)speed + (double)speed * relic.getStatValue(stack, "cowboy", "speed") * 2.0));
        this.rarcompat$tickRidden(mounted, player);
        if (relic.isWaterOrFlyingMob(mounted)) {
            this.rarcompat$travel(this.rarcompat$getRiddenInput(player, relic, mounted), mounted);
        } else {
            mounted.travel(this.rarcompat$getRiddenInput(player, relic, mounted));
        }
        ci.cancel();
    }

    @Unique
    protected Vec3 rarcompat$getRiddenInput(Player player, CowboyHatItem relic, Mob mounted) {
        float f = player.xxa * 0.5f;
        float f1 = player.zza;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        if (relic.isWaterOrFlyingMob(mounted)) {
            double verticalSpeed = mounted.getDeltaMovement().y;
            double speedMultiplier = 0.5;
            if (mounted.getDeltaMovement().y != 0.0) {
                speedMultiplier += Math.abs(verticalSpeed) * 0.1;
            }
            return new Vec3((double)f, player.getLookAngle().y * speedMultiplier, (double)f1);
        }
        return new Vec3((double)f, 0.0, (double)f1);
    }

    @Unique
    protected void rarcompat$tickRidden(Mob mob, Player player) {
        Vec2 rotation = mob instanceof FlyingMob ? new Vec2(-player.getXRot() * 0.5f, player.getYRot()) : new Vec2(player.getXRot() * 0.5f, player.getYRot());
        mob.setXRot(rotation.x % 360.0f);
        mob.setYRot(rotation.y % 360.0f);
        mob.yBodyRot = mob.yHeadRot = mob.getYRot();
        mob.yRotO = mob.yHeadRot;
    }

    @Unique
    public void rarcompat$travel(Vec3 movementInput, Mob mob) {
        if (!mob.isControlledByLocalInstance()) {
            return;
        }
        Vec3 adjustedMovement = mob.handleRelativeFrictionAndCalculateMovement(movementInput, 1.0f);
        if (!mob.isInWater() && mob instanceof WaterAnimal) {
            mob.setDeltaMovement(adjustedMovement.x, -0.08, adjustedMovement.z);
        } else {
            mob.setDeltaMovement(adjustedMovement.x, movementInput.y * 0.8, adjustedMovement.z);
        }
    }
}

