/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hat;

import artifacts.registry.ModItems;
import artifacts.registry.ModSoundEvents;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

public class WhoopeeCushionItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"push").stat(StatData.builder((String)"chance").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.075).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"radius").initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.05).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 10, 13).star(1, 8, 6).star(2, 16, 9).star(3, 17, 14).star(4, 16, 22).star(5, 6, 21).star(6, 3, 13).link(0, 1).link(0, 2).link(0, 3).link(0, 4).link(0, 5).link(0, 6).link(0, 6).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2270887).borderBottom(-8639958).build()).beams(BeamsData.builder().startColor(-1017222).endColor(15759994).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"push").initialValue(1).gem(GemShape.SQUARE, GemColor.YELLOW).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.OVERWORLD}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.isAbilityUnlocked(stack, "push") || !player.onGround()) {
            return;
        }
        boolean isSneaking = player.isShiftKeyDown();
        RandomSource random = player.getRandom();
        if (isSneaking && !((Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)false)).booleanValue() && random.nextDouble() < this.getStatValue(stack, "push", "chance")) {
            this.createWhoopee((ServerLevel)player.level(), player, stack, random);
        }
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)isSneaking);
    }

    public void createWhoopee(ServerLevel level, Player player, ItemStack stack, RandomSource random) {
        level.playSound(null, player.blockPosition(), (SoundEvent)ModSoundEvents.FART.value(), player.getSoundSource(), 1.0f, 0.75f + player.getRandom().nextFloat());
        this.spreadRelicExperience((LivingEntity)player, stack, 1);
        for (LivingEntity livingEntity2 : level.getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(this.getStatValue(stack, "push", "radius"))).stream().filter(livingEntity -> !livingEntity.getUUID().equals(player.getUUID())).toList()) {
            Vec3 vec3 = livingEntity2.position().subtract(player.position()).normalize();
            if (livingEntity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
                NetworkHandler.sendToClient((CustomPacketPayload)new PacketPlayerMotion(vec3.x, 0.2, vec3.z), (ServerPlayer)serverPlayer);
            } else {
                livingEntity2.setDeltaMovement(vec3.x, 0.2, vec3.z);
            }
            livingEntity2.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 1));
        }
        level.sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(0, 100 + random.nextInt(50), 0), (float)0.5f, (int)50, (float)0.9f), player.getX(), player.getY() + 0.5, player.getZ(), 30, 0.25, 0.3, 0.25, 0.1);
    }

    @EventBusSubscriber
    public static class WhoopeeCushionEvent {
        @SubscribeEvent
        public static void onAttackPlayer(LivingDamageEvent.Pre event) {
            WhoopeeCushionItem relic;
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || event.getSource().getEntity() == player) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.WHOOPEE_CUSHION.value()));
            Item item = stack.getItem();
            if (!(item instanceof WhoopeeCushionItem) || !(relic = (WhoopeeCushionItem)item).isAbilityUnlocked(stack, "push") || player.getRandom().nextDouble() > relic.getStatValue(stack, "push", "chance")) {
                return;
            }
            relic.createWhoopee((ServerLevel)player.getCommandSenderWorld(), player, stack, player.getRandom());
        }
    }
}

