/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.curios.api.SlotContext;

public class SnowshoesItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"speed").stat(StatData.builder((String)"amount").initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 6, 7).star(1, 11, 3).star(2, 16, 8).star(3, 15, 16).star(4, 14, 25).star(5, 8, 25).star(6, 9, 17).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 0).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-5338802).borderBottom(-10403546).build()).beams(BeamsData.builder().startColor(-5338802).endColor(6373670).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"speed").initialValue(1).gem(GemShape.SQUARE, GemColor.CYAN).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.FROST, LootEntries.TAIGA, LootEntries.MOUNTAIN}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        double modifier;
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide() || !this.canPlayerUseAbility(player, stack, "speed")) {
            return;
        }
        double step = 0.01;
        double d = modifier = this.isStandingOnSnow(player) ? step : -step;
        if (modifier != 0.0) {
            this.addSpeed(stack, modifier);
        }
        EntityUtils.resetAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (float)((float)this.getSpeed(stack)), (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        if (this.isStandingOnSnow(player) && player.tickCount % 60 == 0 && (player.getKnownMovement().x != 0.0 || player.getKnownMovement().z != 0.0)) {
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
    }

    public void addSpeed(ItemStack stack, double val) {
        if (this.getSpeed(stack) <= this.getStatValue(stack, "speed", "amount") || val < 0.0) {
            this.setSpeed(stack, this.getSpeed(stack) + val);
        }
    }

    public double getSpeed(ItemStack stack) {
        return (Double)stack.getOrDefault((Supplier)DataComponentRegistry.SPEED, (Object)0.0);
    }

    public void setSpeed(ItemStack stack, double val) {
        stack.set((Supplier)DataComponentRegistry.SPEED, (Object)Math.max(val, 0.0));
    }

    private boolean isStandingOnSnow(Player player) {
        for (int i = 0; i < 8; ++i) {
            if (!player.getCommandSenderWorld().getBlockState(player.blockPosition().atY((int)Math.floor(WorldUtils.getGroundHeight((Entity)player, (Vec3)player.position().add(0.0, 0.1, 0.0), (int)8))).below(i)).is(BlockTags.SNOW)) continue;
            return true;
        }
        return false;
    }

    public boolean canWalkOnPowderedSnow(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return super.canWalkOnPowderedSnow(slotContext, stack);
        }
        Player player = (Player)livingEntity;
        return this.canPlayerUseAbility(player, stack, "passive");
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (newStack.getItem() == stack.getItem()) {
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)slotContext.entity(), (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }
}

