/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.storage;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.storage.StorageVariant;
import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import com.refinedmods.refinedstorage.mekanism.content.Items;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;

public enum ChemicalStorageVariant implements StringRepresentable,
StorageVariant
{
    SIXTY_FOUR_B("64b", 64L),
    TWO_HUNDRED_FIFTY_SIX_B("256b", 256L),
    THOUSAND_TWENTY_FOUR_B("1024b", 1024L),
    EIGHT_THOUSAND_NINETY_TWO_B("8192b", 8192L),
    CREATIVE("creative", null);

    private final String name;
    private final ResourceLocation storageDiskId;
    private final ResourceLocation storageBlockId;
    @Nullable
    private final ResourceLocation storagePartId;
    @Nullable
    private final Long capacityInBuckets;

    private ChemicalStorageVariant(String name, Long capacityInBuckets) {
        this.name = name;
        this.storagePartId = capacityInBuckets != null ? MekanismIntegrationIdentifierUtil.createMekanismIntegrationIdentifier(name + "_chemical_storage_part") : null;
        this.storageDiskId = MekanismIntegrationIdentifierUtil.createMekanismIntegrationIdentifier(name + "_chemical_storage_disk");
        this.storageBlockId = MekanismIntegrationIdentifierUtil.createMekanismIntegrationIdentifier(name + "_chemical_storage_block");
        this.capacityInBuckets = capacityInBuckets;
    }

    @Nullable
    public Long getCapacityInBuckets() {
        return this.capacityInBuckets;
    }

    @Nullable
    public Long getCapacity() {
        if (this.capacityInBuckets == null) {
            return null;
        }
        return this.capacityInBuckets * Platform.INSTANCE.getBucketAmount();
    }

    @Nullable
    public Item getStoragePart() {
        if (this == CREATIVE) {
            return null;
        }
        return Items.getChemicalStoragePart(this);
    }

    public ResourceLocation getStorageDiskId() {
        return this.storageDiskId;
    }

    public ResourceLocation getStorageBlockId() {
        return this.storageBlockId;
    }

    @Nullable
    public ResourceLocation getStoragePartId() {
        return this.storagePartId;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }
}

