/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.grid;

import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalResourceType;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class ChemicalGridInsertionStrategy
implements GridInsertionStrategy {
    private final AbstractContainerMenu menu;
    private final GridOperations gridOperations;

    public ChemicalGridInsertionStrategy(AbstractContainerMenu menu, ServerPlayer player, Grid grid) {
        this.menu = menu;
        this.gridOperations = grid.createOperations((ResourceType)ChemicalResourceType.INSTANCE, player);
    }

    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        IChemicalHandler cursorStorage = this.getChemicalCursorStorage();
        if (cursorStorage == null) {
            return false;
        }
        if (cursorStorage.getChemicalTanks() == 0) {
            return false;
        }
        ChemicalStack extractableResource = cursorStorage.getChemicalInTank(0);
        if (extractableResource.isEmpty()) {
            return false;
        }
        ChemicalResource chemicalResource = ChemicalResource.ofChemicalStack(extractableResource);
        this.gridOperations.insert((ResourceKey)chemicalResource, insertMode, (resource, amount, action, source) -> {
            Chemical chemical;
            if (!(resource instanceof ChemicalResource)) return 0L;
            ChemicalResource $b$0 = (ChemicalResource)resource;
            try {
                Chemical patt1$temp;
                chemical = patt1$temp = $b$0.chemical();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            ChemicalStack toDrain = new ChemicalStack(chemical, amount);
            ChemicalStack drained = cursorStorage.extractChemical(toDrain, ChemicalUtil.toMekanismAction(action));
            return drained.getAmount();
        });
        return true;
    }

    @Nullable
    private IChemicalHandler getChemicalCursorStorage() {
        return this.getChemicalStorage(this.menu.getCarried());
    }

    @Nullable
    private IChemicalHandler getChemicalStorage(ItemStack stack) {
        return (IChemicalHandler)stack.getCapability(ChemicalUtil.ITEM_CAPABILITY);
    }

    public boolean onTransfer(int slotIndex) {
        throw new UnsupportedOperationException();
    }
}

