/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.mekanism.MekanismIntegrationIdentifierUtil;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class Config {
    private final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    private final ModConfigSpec spec;
    private final ChemicalStorageBlockEntry chemicalStorageBlock = new ChemicalStorageBlockEntry(this);

    public Config() {
        this.spec = this.builder.build();
    }

    private static String translationKey(String value) {
        return MekanismIntegrationIdentifierUtil.createMekanismIntegrationTranslationKey("config", "option." + value);
    }

    public ChemicalStorageBlockEntry getChemicalStorageBlock() {
        return this.chemicalStorageBlock;
    }

    public ModConfigSpec getSpec() {
        return this.spec;
    }

    public class ChemicalStorageBlockEntry {
        private final ModConfigSpec.LongValue sixtyFourBEnergyUsage;
        private final ModConfigSpec.LongValue twoHundredFiftySixBEnergyUsage;
        private final ModConfigSpec.LongValue thousandTwentyFourBEnergyUsage;
        private final ModConfigSpec.LongValue eightThousandHundredNinetyTwoBEnergyUsage;
        private final ModConfigSpec.LongValue creativeEnergyUsage;

        ChemicalStorageBlockEntry(Config this$0) {
            this$0.builder.translation(Config.translationKey("chemicalStorageBlock")).push("chemicalStorageBlock");
            this.sixtyFourBEnergyUsage = this$0.builder.translation(Config.translationKey("chemicalStorageBlock.sixtyFourBEnergyUsage")).defineInRange("64bEnergyUsage", 2L, 0L, Long.MAX_VALUE);
            this.twoHundredFiftySixBEnergyUsage = this$0.builder.translation(Config.translationKey("chemicalStorageBlock.twoHundredFiftySixBEnergyUsage")).defineInRange("256bEnergyUsage", 4L, 0L, Long.MAX_VALUE);
            this.thousandTwentyFourBEnergyUsage = this$0.builder.translation(Config.translationKey("chemicalStorageBlock.thousandTwentyFourBEnergyUsage")).defineInRange("1024bEnergyUsage", 6L, 0L, Long.MAX_VALUE);
            this.eightThousandHundredNinetyTwoBEnergyUsage = this$0.builder.translation(Config.translationKey("chemicalStorageBlock.eightThousandHundredNinetyTwoBEnergyUsage")).defineInRange("8192bEnergyUsage", 8L, 0L, Long.MAX_VALUE);
            this.creativeEnergyUsage = this$0.builder.translation(Config.translationKey("chemicalStorageBlock.creativeEnergyUsage")).defineInRange("creativeEnergyUsage", 16L, 0L, Long.MAX_VALUE);
            this$0.builder.pop();
        }

        public long get64bEnergyUsage() {
            return (Long)this.sixtyFourBEnergyUsage.get();
        }

        public long get256bEnergyUsage() {
            return (Long)this.twoHundredFiftySixBEnergyUsage.get();
        }

        public long get1024bEnergyUsage() {
            return (Long)this.thousandTwentyFourBEnergyUsage.get();
        }

        public long get8192bEnergyUsage() {
            return (Long)this.eightThousandHundredNinetyTwoBEnergyUsage.get();
        }

        public long getCreativeEnergyUsage() {
            return (Long)this.creativeEnergyUsage.get();
        }
    }
}

