/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainerInsertStrategy;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.world.item.ItemStack;

class ChemicalResourceContainerInsertStrategy
implements ResourceContainerInsertStrategy {
    ChemicalResourceContainerInsertStrategy() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<ResourceContainerInsertStrategy.InsertResult> insert(ItemStack container, ResourceAmount resourceAmount) {
        Chemical chemical;
        ResourceKey resourceKey = resourceAmount.resource();
        if (!(resourceKey instanceof ChemicalResource)) return Optional.empty();
        ChemicalResource chemicalResource = (ChemicalResource)resourceKey;
        try {
            Chemical chemical2;
            chemical = chemical2 = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ItemStack modifiedContainer = container.copy();
        return Optional.ofNullable((IChemicalHandler)modifiedContainer.getCapability(ChemicalUtil.ITEM_CAPABILITY)).map(handler -> handler.insertChemical(new ChemicalStack(chemical, resourceAmount.amount()), Action.EXECUTE)).map(remainder -> resourceAmount.amount() - remainder.getAmount()).map(inserted -> new ResourceContainerInsertStrategy.InsertResult(modifiedContainer, inserted.longValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<ResourceContainerInsertStrategy.ConversionInfo> getConversionInfo(ResourceKey resource, ItemStack carriedStack) {
        Chemical chemical;
        if (!(resource instanceof ChemicalResource)) return Optional.empty();
        ChemicalResource chemicalResource = (ChemicalResource)resource;
        try {
            Chemical chemical2;
            chemical = chemical2 = chemicalResource.chemical();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ItemStack modifiedStack = carriedStack.copy();
        return Optional.ofNullable((IChemicalHandler)modifiedStack.getCapability(ChemicalUtil.ITEM_CAPABILITY)).map(handler -> handler.insertChemical(new ChemicalStack(chemical, Platform.INSTANCE.getBucketAmount()), Action.EXECUTE)).filter(ChemicalStack::isEmpty).map(result -> new ResourceContainerInsertStrategy.ConversionInfo(carriedStack, modifiedStack));
    }
}

