/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.pocketstorage.inventory;

import com.flanks255.pocketstorage.inventory.PSUItemHandler;
import com.flanks255.pocketstorage.items.PSUTier;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.IItemHandler;

public class PSUData {
    private final UUID uuid;
    private PSUTier tier;
    private final PSUItemHandler inventory;
    private final Optional<IItemHandler> optional;
    public final Metadata meta = new Metadata();

    public PSUData(UUID uuidIn, PSUTier tierIn) {
        this.uuid = uuidIn;
        this.tier = tierIn;
        this.inventory = new PSUItemHandler(this.tier);
        this.optional = Optional.of(this.inventory);
    }

    public PSUData(UUID uuidIn, CompoundTag incomingNBT, HolderLookup.Provider registryAccess) {
        this.uuid = uuidIn;
        this.tier = PSUTier.values()[Math.min(incomingNBT.getInt("Tier"), PSUTier.TIER4.ordinal())];
        this.inventory = new PSUItemHandler(this.tier);
        this.inventory.deserializeNBT(registryAccess, incomingNBT.getCompound("Inventory"));
        this.optional = Optional.of(this.inventory);
        if (incomingNBT.contains("Metadata")) {
            this.meta.deserializeNBT(registryAccess, incomingNBT.getCompound("Metadata"));
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Optional<IItemHandler> getOptional() {
        return this.optional;
    }

    public PSUItemHandler getHandler() {
        return this.inventory;
    }

    public void upgrade(PSUTier newTier) {
        if (newTier.ordinal() > this.tier.ordinal()) {
            this.tier = newTier;
            this.inventory.upgrade(this.tier);
        }
    }

    public void updateAccessRecords(String player, long time) {
        if (this.meta.firstAccessedTime == 0L) {
            this.meta.firstAccessedTime = time;
            this.meta.firstAccessedPlayer = player;
        }
        this.meta.setLastAccessedTime(time);
        this.meta.setLastAccessedPlayer(player);
    }

    public PSUTier getTier() {
        return this.tier;
    }

    public static Optional<PSUData> fromNBT(CompoundTag nbt, HolderLookup.Provider registryAccess) {
        if (nbt.contains("UUID")) {
            UUID uuid = nbt.getUUID("UUID");
            return Optional.of(new PSUData(uuid, nbt, registryAccess));
        }
        return Optional.empty();
    }

    public CompoundTag toNBT(HolderLookup.Provider registryAccess) {
        CompoundTag nbt = new CompoundTag();
        nbt.putUUID("UUID", this.uuid);
        nbt.putString("StringUUID", this.uuid.toString());
        nbt.putInt("Tier", this.tier.ordinal());
        nbt.put("Inventory", (Tag)this.inventory.serializeNBT(registryAccess));
        nbt.put("Metadata", (Tag)this.meta.serializeNBT(registryAccess));
        return nbt;
    }

    public static class Metadata
    implements INBTSerializable<CompoundTag> {
        private String firstAccessedPlayer = "";
        private long firstAccessedTime = 0L;
        private String lastAccessedPlayer = "";
        private long lastAccessedTime = 0L;

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void setLastAccessedTime(long lastAccessedTime) {
            this.lastAccessedTime = lastAccessedTime;
        }

        public String getLastAccessedPlayer() {
            return this.lastAccessedPlayer;
        }

        public void setLastAccessedPlayer(String lastAccessedPlayer) {
            this.lastAccessedPlayer = lastAccessedPlayer;
        }

        public long getFirstAccessedTime() {
            return this.firstAccessedTime;
        }

        public String getFirstAccessedPlayer() {
            return this.firstAccessedPlayer;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putString("firstPlayer", this.firstAccessedPlayer);
            nbt.putLong("firstTime", this.firstAccessedTime);
            nbt.putString("lastPlayer", this.lastAccessedPlayer);
            nbt.putLong("lastTime", this.lastAccessedTime);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            this.firstAccessedPlayer = nbt.getString("firstPlayer");
            this.firstAccessedTime = nbt.getLong("firstTime");
            this.lastAccessedPlayer = nbt.getString("lastPlayer");
            this.lastAccessedTime = nbt.getLong("lastTime");
        }
    }
}

