/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.network.handlers;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.attachment.AttachmentSync;
import net.neoforged.neoforge.common.world.AuxiliaryLightManager;
import net.neoforged.neoforge.common.world.LevelChunkAuxiliaryLightManager;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.ConfigSync;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.payload.AdvancedAddEntityPayload;
import net.neoforged.neoforge.network.payload.AdvancedContainerSetDataPayload;
import net.neoforged.neoforge.network.payload.AdvancedOpenScreenPayload;
import net.neoforged.neoforge.network.payload.AuxiliaryLightDataPayload;
import net.neoforged.neoforge.network.payload.ClientboundCustomSetTimePayload;
import net.neoforged.neoforge.network.payload.ConfigFilePayload;
import net.neoforged.neoforge.network.payload.FrozenRegistryPayload;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncCompletedPayload;
import net.neoforged.neoforge.network.payload.FrozenRegistrySyncStartPayload;
import net.neoforged.neoforge.network.payload.SyncAttachmentsPayload;
import net.neoforged.neoforge.registries.RegistryManager;
import net.neoforged.neoforge.registries.RegistrySnapshot;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
public final class ClientPayloadHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientPayloadHandler.class);
    private static final Set<ResourceLocation> toSynchronize = Sets.newConcurrentHashSet();
    private static final Map<ResourceLocation, RegistrySnapshot> synchronizedRegistries = Maps.newConcurrentMap();

    private ClientPayloadHandler() {
    }

    public static void handle(FrozenRegistryPayload payload, IPayloadContext context) {
        synchronizedRegistries.put(payload.registryName(), payload.snapshot());
        toSynchronize.remove(payload.registryName());
    }

    public static void handle(FrozenRegistrySyncStartPayload payload, IPayloadContext context) {
        toSynchronize.addAll(payload.toAccess());
        synchronizedRegistries.clear();
    }

    public static void handle(FrozenRegistrySyncCompletedPayload payload, IPayloadContext context) {
        if (!toSynchronize.isEmpty()) {
            context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.missing", (Object[])new Object[]{toSynchronize.stream().map(Object::toString).collect(Collectors.joining(", "))}));
            return;
        }
        try {
            Set<ResourceKey<?>> keysUnknownToClient = RegistryManager.applySnapshot(synchronizedRegistries, false);
            if (!keysUnknownToClient.isEmpty()) {
                context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.server-with-unknown-keys", (Object[])new Object[]{keysUnknownToClient.stream().map(Object::toString).collect(Collectors.joining(", "))}));
                return;
            }
            toSynchronize.clear();
            synchronizedRegistries.clear();
            context.reply(FrozenRegistrySyncCompletedPayload.INSTANCE);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle registry sync from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.registries.sync.failed", (Object[])new Object[]{t.toString()}));
        }
    }

    public static void handle(ConfigFilePayload payload, IPayloadContext context) {
        ConfigSync.receiveSyncedConfig(payload.contents(), payload.fileName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(AdvancedAddEntityPayload advancedAddEntityPayload, IPayloadContext context) {
        block5: {
            try {
                Entity entity = context.player().level().getEntity(advancedAddEntityPayload.entityId());
                if (!(entity instanceof IEntityWithComplexSpawn)) break block5;
                IEntityWithComplexSpawn entityAdditionalSpawnData = (IEntityWithComplexSpawn)entity;
                RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])advancedAddEntityPayload.customPayload()), entity.registryAccess(), context.listener().getConnectionType());
                try {
                    entityAdditionalSpawnData.readSpawnData(buf);
                }
                finally {
                    buf.release();
                }
            }
            catch (Throwable t) {
                LOGGER.error("Failed to handle advanced add entity from server.", t);
                context.disconnect((Component)Component.translatable((String)"neoforge.network.advanced_add_entity.failed", (Object[])new Object[]{t.toString()}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(AdvancedOpenScreenPayload msg, IPayloadContext context) {
        Minecraft mc = Minecraft.getInstance();
        RegistryAccess registryAccess = mc.player.registryAccess();
        RegistryFriendlyByteBuf buf = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])msg.additionalData()), registryAccess, context.listener().getConnectionType());
        try {
            ClientPayloadHandler.createMenuScreen(msg.name(), msg.menuType(), msg.windowId(), buf);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle advanced open screen from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.advanced_open_screen.failed", (Object[])new Object[]{t.toString()}));
        }
        finally {
            buf.release();
        }
    }

    private static <T extends AbstractContainerMenu> void createMenuScreen(Component name, MenuType<T> menuType, int windowId, RegistryFriendlyByteBuf buf) {
        Minecraft mc = Minecraft.getInstance();
        MenuScreens.getScreenFactory(menuType).ifPresent(f -> {
            Screen s = f.create(menuType.create(windowId, mc.player.getInventory(), buf), mc.player.getInventory(), name);
            mc.player.containerMenu = ((MenuAccess)s).getMenu();
            mc.setScreen(s);
        });
    }

    public static void handle(AuxiliaryLightDataPayload msg, IPayloadContext context) {
        try {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                return;
            }
            AuxiliaryLightManager lightManager = mc.level.getAuxLightManager(msg.pos());
            if (lightManager instanceof LevelChunkAuxiliaryLightManager) {
                LevelChunkAuxiliaryLightManager manager = (LevelChunkAuxiliaryLightManager)lightManager;
                manager.handleLightDataSync(msg.entries());
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to handle auxiliary light data from server.", t);
            context.disconnect((Component)Component.translatable((String)"neoforge.network.aux_light_data.failed", (Object[])new Object[]{msg.pos().toString(), t.toString()}));
        }
    }

    public static void handle(AdvancedContainerSetDataPayload msg, IPayloadContext context) {
        context.handle((Packet<?>)msg.toVanillaPacket());
    }

    public static void handle(ClientboundCustomSetTimePayload payload, IPayloadContext context) {
        ClientLevel level = Minecraft.getInstance().level;
        level.setGameTime(payload.gameTime());
        level.setDayTime(payload.dayTime());
        ((GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_DAYLIGHT)).set(payload.gameRule(), null);
        level.setDayTimeFraction(payload.dayTimeFraction());
        level.setDayTimePerTick(payload.dayTimePerTick());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void handle(SyncAttachmentsPayload payload, IPayloadContext context) {
        SyncAttachmentsPayload.Target target = payload.target();
        Objects.requireNonNull(target);
        SyncAttachmentsPayload.Target target2 = target;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SyncAttachmentsPayload.BlockEntityTarget.class, SyncAttachmentsPayload.ChunkTarget.class, SyncAttachmentsPayload.EntityTarget.class, SyncAttachmentsPayload.LevelTarget.class}, (Object)target2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                BlockPos pos;
                SyncAttachmentsPayload.BlockEntityTarget blockEntityTarget = (SyncAttachmentsPayload.BlockEntityTarget)target2;
                try {
                    BlockPos blockPos;
                    pos = blockPos = blockEntityTarget.pos();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                BlockEntity blockEntity = context.player().level().getBlockEntity(pos);
                if (blockEntity == null) {
                    LOGGER.warn("Received synced attachments from unknown block entity");
                    return;
                }
                AttachmentSync.receiveSyncedDataAttachments((AttachmentHolder)blockEntity, context.player().registryAccess(), payload.types(), payload.syncPayload());
                return;
            }
            case 1: {
                ChunkPos pos;
                SyncAttachmentsPayload.ChunkTarget chunkTarget = (SyncAttachmentsPayload.ChunkTarget)target2;
                {
                    ChunkPos chunkPos;
                    pos = chunkPos = chunkTarget.pos();
                }
                ChunkAccess chunk = context.player().level().getChunk(pos.x, pos.z, ChunkStatus.FULL, false);
                if (chunk == null) {
                    LOGGER.warn("Received synced attachments from unknown chunk");
                    return;
                }
                AttachmentSync.receiveSyncedDataAttachments(chunk.getAttachmentHolder(), chunk.getLevel().registryAccess(), payload.types(), payload.syncPayload());
                return;
            }
            case 2: {
                int entityId;
                SyncAttachmentsPayload.EntityTarget entityTarget = (SyncAttachmentsPayload.EntityTarget)target2;
                {
                    int n2;
                    entityId = n2 = entityTarget.entity();
                }
                Entity entity = context.player().level().getEntity(entityId);
                if (entity == null) {
                    LOGGER.warn("Received synced attachments from unknown entity");
                    return;
                }
                AttachmentSync.receiveSyncedDataAttachments((AttachmentHolder)entity, entity.registryAccess(), payload.types(), payload.syncPayload());
                return;
            }
            case 3: 
        }
        SyncAttachmentsPayload.LevelTarget levelTarget = (SyncAttachmentsPayload.LevelTarget)target2;
        AttachmentSync.receiveSyncedDataAttachments((AttachmentHolder)context.player().level(), context.player().registryAccess(), payload.types(), payload.syncPayload());
    }
}

