/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.Models;

import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BlockGenHelper {
    public static NonNullBiConsumer<DataGenContext<Block, ElectricMotorBlock>, RegistrateBlockstateProvider> directionalBlockState(ResourceLocation resourceLocation) {
        return (ctx, prov) -> BlockGenHelper.directionalModel(resourceLocation, ctx, prov);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> directionalBlockState() {
        return (ctx, prov) -> BlockGenHelper.directionalModel(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)("block/" + BlockGenHelper.getBlockName((Block)ctx.get()) + "/block")), ctx, prov);
    }

    public static NonNullBiConsumer<DataGenContext<Block, ElectricMotorBlock>, RegistrateBlockstateProvider> horizontalBlockState(ResourceLocation resourceLocation) {
        return (ctx, prov) -> BlockGenHelper.horizontalModel(resourceLocation, ctx, prov, 0);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> horizontalBlockState() {
        return (ctx, prov) -> BlockGenHelper.horizontalModel(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)("block/" + BlockGenHelper.getBlockName((Block)ctx.get()) + "/block")), ctx, prov, 90);
    }

    public static <T extends Block> void directionalModel(ResourceLocation resourceLocation, DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
        BlockModelProvider models = prov.models();
        ModelFile.ExistingModelFile blockModel = models.getExistingFile(resourceLocation);
        prov.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)blockModel).rotationX(dir == Direction.DOWN ? 270 : (dir.getAxis().isHorizontal() ? 0 : 90)).rotationY(dir.getAxis().isVertical() ? 90 : ((int)dir.toYRot() + 360) % 360).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED, BlockStateProperties.POWERED});
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> simpleBlock(ResourceLocation resourceLocation) {
        return (ctx, prov) -> BlockGenHelper.simpleBlockModel(resourceLocation, ctx, prov);
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> simpleBlock() {
        return (ctx, prov) -> BlockGenHelper.simpleBlockModel(ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)("block/" + BlockGenHelper.getBlockName((Block)ctx.get()) + "/block")), ctx, prov);
    }

    public static <T extends Block> void horizontalModel(ResourceLocation resourceLocation, DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov, int angleOffset) {
        BlockModelProvider models = prov.models();
        ModelFile.ExistingModelFile blockModel = models.getExistingFile(resourceLocation);
        prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)blockModel).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + angleOffset) % 360).build());
    }

    public static <T extends Block> void simpleBlockModel(ResourceLocation resourceLocation, DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
        ModelFile.ExistingModelFile blockModel = prov.models().getExistingFile(resourceLocation);
        prov.simpleBlock((Block)ctx.get(), (ModelFile)blockModel);
    }

    public static String getBlockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }
}

