/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content;

import com.satherov.crystalix.CrystalixConfig;
import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.core.lang.CrystalixLanguage;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public class BatchProcessor {
    private static final List<Batch> BATCHES = new ArrayList<Batch>();

    public static void tick(ServerTickEvent.Post event) {
        Iterator<Batch> iterator = BATCHES.iterator();
        while (iterator.hasNext()) {
            ServerPlayer player;
            MinecraftServer server = event.getServer();
            Batch batch = iterator.next();
            ServerLevel level = server.getLevel(batch.dimension);
            if (level == null) continue;
            if (batch.tick == Integer.MIN_VALUE) {
                batch.initTick(server.getTickCount());
            } else if (batch.tick + 20 < server.getTickCount() && batch.tick != Integer.MAX_VALUE && (player = server.getPlayerList().getPlayer(batch.owner)) != null) {
                player.displayClientMessage((Component)CrystalixLanguage.MESSAGE_SIZE.translate(), true);
                batch.tick = Integer.MAX_VALUE;
            }
            if (batch.phase == Batch.Phase.EXPLORING) {
                batch.explore((LevelAccessor)level);
                if (batch.shouldBeginProcessing()) {
                    batch.beginProcessing();
                }
            } else {
                batch.process((LevelAccessor)level);
            }
            if (!batch.isDone()) continue;
            batch.clear();
            iterator.remove();
        }
    }

    public static Batch schedule(Batch batch) {
        BATCHES.add(batch);
        return batch;
    }

    public static class Batch {
        private final UUID owner;
        private final ResourceKey<Level> dimension;
        private final ItemStack wand;
        private final Set<BlockPos> visited = new LinkedHashSet<BlockPos>();
        private final ArrayDeque<BlockPos> frontier = new ArrayDeque();
        private int tick = Integer.MIN_VALUE;
        private ArrayDeque<BlockPos> queue = null;
        private Phase phase = Phase.EXPLORING;
        private final int maxPerTick = CrystalixConfig.getMaxEditOperation();
        private final int maxTotal = CrystalixConfig.getMaxEditForce();

        protected Batch(ServerPlayer player, BlockPos start, ItemStack wand) {
            this.owner = player.getUUID();
            this.dimension = player.level().dimension();
            this.wand = wand;
            this.frontier.add(start);
            this.visited.add(start);
        }

        public static Batch of(ServerPlayer player, BlockPos start, ItemStack wand) {
            return new Batch(player, start, wand);
        }

        protected void explore(LevelAccessor level) {
            if (this.visited.size() >= this.maxTotal) {
                return;
            }
            int operations = 0;
            block0: while (!this.frontier.isEmpty() && operations < this.maxPerTick && this.visited.size() < this.maxTotal) {
                BlockPos pos = this.frontier.pollFirst();
                if (!(level.getBlockState(pos).getBlock() instanceof CrystalixGlass)) continue;
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            BlockPos n;
                            if (dx == 0 && dy == 0 && dz == 0 || level.isOutsideBuildHeight(n = pos.offset(dx, dy, dz)) || !level.isAreaLoaded(n, 0) || this.visited.contains(n) || !(level.getBlockState(n).getBlock() instanceof CrystalixGlass)) continue;
                            this.visited.add(n);
                            this.frontier.addLast(n);
                            ++operations;
                            if (this.visited.size() >= this.maxTotal) break;
                        }
                        if (this.visited.size() >= this.maxTotal) break;
                    }
                    if (this.visited.size() >= this.maxTotal) continue block0;
                }
            }
        }

        protected void initTick(int tick) {
            this.tick = tick;
        }

        protected boolean shouldBeginProcessing() {
            return this.phase == Phase.EXPLORING && (this.frontier.isEmpty() || this.visited.size() >= this.maxTotal);
        }

        protected void beginProcessing() {
            this.phase = Phase.PROCESSING;
            this.queue = new ArrayDeque<BlockPos>(this.visited);
        }

        protected void process(LevelAccessor level) {
            if (this.phase != Phase.PROCESSING || this.queue == null) {
                return;
            }
            int operations = 0;
            while (!this.queue.isEmpty() && operations < this.maxPerTick) {
                BlockPos pos = this.queue.pollFirst();
                if (level.isOutsideBuildHeight(pos) || !level.isAreaLoaded(pos, 0)) continue;
                BlockState state = level.getBlockState(pos);
                Block block = state.getBlock();
                if (block instanceof CrystalixGlass) {
                    CrystalixGlass glass = (CrystalixGlass)block;
                    level.setBlock(pos, glass.modifyFromWand(state, this.wand), 3);
                }
                ++operations;
            }
        }

        protected boolean isDone() {
            return this.phase == Phase.PROCESSING && (this.queue == null || this.queue.isEmpty());
        }

        protected void clear() {
            this.frontier.clear();
            this.visited.clear();
            if (this.queue != null) {
                this.queue.clear();
            }
        }

        static enum Phase {
            EXPLORING,
            PROCESSING;

        }
    }
}

