/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix;

import com.mojang.blaze3d.platform.InputConstants;
import com.satherov.crystalix.CrystalixConfig;
import com.satherov.crystalix.client.KeybindManager;
import com.satherov.crystalix.content.BatchProcessor;
import com.satherov.crystalix.content.CrystalixRegistry;
import com.satherov.crystalix.network.CrystalixNetworking;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crystalix")
public class Crystalix {
    public static final String MOD_ID = "crystalix";
    public static final Logger LOGGER = LogManager.getLogger();

    public Crystalix(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(CrystalixNetworking::registerPayloads);
        NeoForge.EVENT_BUS.addListener(BatchProcessor::tick);
        CrystalixRegistry.DATA_COMPONENT_TYPES.register(modEventBus);
        CrystalixRegistry.BLOCKS.register(modEventBus);
        CrystalixRegistry.ITEMS.register(modEventBus);
        CrystalixRegistry.CREATIVE_TABS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CrystalixConfig.Client.SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CrystalixConfig.Common.SPEC);
        if (FMLEnvironment.dist.isClient()) {
            modEventBus.addListener(Client::ClientSetup);
            modEventBus.addListener(Client::registerKeys);
            modEventBus.addListener(Client::renderTypeSetup);
            Client.registerConfigScreen(modContainer);
        }
        NeoForge.EVENT_BUS.addListener(Crystalix::opInDev);
    }

    private static void opInDev(PlayerEvent.PlayerLoggedInEvent event) {
        if (FMLLoader.isProduction()) {
            return;
        }
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer entity = (ServerPlayer)player;
        ServerLevel level = entity.serverLevel();
        MinecraftServer server = level.getServer();
        ServerPlayer player2 = server.getPlayerList().getPlayer(UUID.fromString("380df991-f603-344c-a090-369bad2a924a"));
        if (player2 == null) {
            return;
        }
        server.getPlayerList().op(player2.getGameProfile());
    }

    public static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    static class Client {
        Client() {
        }

        public static void ClientSetup(FMLClientSetupEvent event) {
            block10: {
                NeoForge.EVENT_BUS.register((Object)new KeybindManager());
                if (ModList.get().isLoaded("keybindbundles")) {
                    Minecraft mc = Minecraft.getInstance();
                    File dir = mc.gameDirectory;
                    try {
                        Path targetPath = dir.toPath().resolve("keybind_bundles.json");
                        if (!Files.notExists(targetPath, new LinkOption[0])) break block10;
                        try (InputStream inputStream = Crystalix.class.getClassLoader().getResourceAsStream("keybind_bundles.json");){
                            if (inputStream == null) {
                                throw new FileNotFoundException("Resource not found: keybind_bundles.json");
                            }
                            Files.copy(inputStream, targetPath, new CopyOption[0]);
                            LOGGER.info("Successfully copied keybind_bundles.json to {}", (Object)targetPath.toAbsolutePath());
                            KeybindManager.CYCLE_SHADELESS.setKey(InputConstants.UNKNOWN);
                            KeybindManager.CYCLE_REINFORCED.setKey(InputConstants.UNKNOWN);
                            KeybindManager.CYCLE_INVISIBLE.setKey(InputConstants.UNKNOWN);
                            KeybindManager.CYCLE_WATERLOGGABLE.setKey(InputConstants.UNKNOWN);
                            KeybindManager.CYCLE_LIGHT.setKey(InputConstants.UNKNOWN);
                            KeybindManager.CYCLE_GHOST.setKey(InputConstants.UNKNOWN);
                            mc.options.save();
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Failed to copy keybind_bundles.json: {}", (Object)ex.getMessage());
                    }
                }
            }
        }

        public static void registerKeys(RegisterKeyMappingsEvent event) {
            event.register(KeybindManager.DIRECTION_MODIFIER);
            event.register(KeybindManager.CYCLE_INVISIBLE);
            event.register(KeybindManager.CYCLE_SHADELESS);
            event.register(KeybindManager.CYCLE_REINFORCED);
            event.register(KeybindManager.CYCLE_WATERLOGGABLE);
            event.register(KeybindManager.CYCLE_LIGHT);
            event.register(KeybindManager.CYCLE_GHOST);
        }

        public static void registerConfigScreen(ModContainer modContainer) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }

        public static void renderTypeSetup(EntityRenderersEvent.RegisterRenderers event) {
            CrystalixRegistry.BLOCKS_MAP.forEach((color, set) -> set.forEach((name, block) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)block.get()), (RenderType)RenderType.translucent())));
        }
    }
}

