/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.emi;

import com.klikli_dev.theurgy.content.recipe.LiquefactionRecipe;
import com.klikli_dev.theurgy.integration.emi.EmiPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class LiquefactionEmiRecipe
implements EmiRecipe {
    private final RecipeHolder<LiquefactionRecipe> recipe;

    public LiquefactionEmiRecipe(RecipeHolder<LiquefactionRecipe> recipe) {
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiPlugin.LIQUEFACTION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiStack> inputs = new ArrayList<EmiStack>(Arrays.stream(((LiquefactionRecipe)this.recipe.value()).getSolvent().getFluids()).map(f -> EmiStack.of((Fluid)f.getFluid(), (long)((LiquefactionRecipe)this.recipe.value()).getSolventAmount())).toList());
        inputs.add((EmiStack)EmiIngredient.of((Ingredient)((Ingredient)((LiquefactionRecipe)this.recipe.value()).getIngredients().getFirst())));
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemStack)((LiquefactionRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
    }

    public int getDisplayWidth() {
        return 102;
    }

    public int getDisplayHeight() {
        return 43;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 45, 8);
        widgets.addSlot(EmiIngredient.of(Arrays.stream(((LiquefactionRecipe)this.recipe.value()).getSolvent().getFluids()).map(f -> EmiStack.of((Fluid)f.getFluid(), (long)((LiquefactionRecipe)this.recipe.value()).getSolventAmount())).toList()), 1, 1);
        widgets.addSlot(EmiIngredient.of((Ingredient)((Ingredient)((LiquefactionRecipe)this.recipe.value()).getIngredients().getFirst())), 19, 1);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)((LiquefactionRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)), 81, 9).recipeContext((EmiRecipe)this);
        int cookTime = ((LiquefactionRecipe)this.recipe.value()).getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"theurgy.gui.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            widgets.addText((Component)timeString, this.getDisplayWidth() - stringWidth, 34, -8355712, false);
        }
    }
}

