/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.transmutation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookSpotlightPageModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FermentationVatEntry
extends EntryProvider {
    public static final String ENTRY_ID = "fermentation_vat";

    public FermentationVatEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Transmutation Apparatus");
        this.pageText("As discussed, Transmutation consists of Fermentation and the already known Reformation.\n\\\n\\\nView the {0} Category on how to craft and use the required apparatus.\n", new Object[]{this.entryLink("Apparatus", "apparatus", "transmutation_and_exaltation")});
        this.page("reformation_array", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Reformation Array");
        this.pageText("You need to set up a reformation array, the usage was already discussed in the {0} and following entries.\n", new Object[]{this.entryLink("Reformation Array", "getting_started", "reformation_array")});
        this.page(ENTRY_ID, () -> BookSpotlightPageModel.create().withItem(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FERMENTATION_VAT.get()})).withText(this.context().pageText()));
        this.pageText("You further need at least one fermentation vat. Multiple vats can be used to process multiple sulfurs in parallel.\n");
    }

    protected String entryName() {
        return "Required Apparatus";
    }

    protected String entryDescription() {
        return "The apparatus needed for transmutation";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.FERMENTATION_VAT.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

