/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.mercurialwand.mode;

import com.klikli_dev.theurgy.content.item.mercurialwand.mode.CycleSelectedDirectionMode;
import com.klikli_dev.theurgy.content.item.mode.ItemModeRenderHandler;
import com.klikli_dev.theurgy.content.item.mode.TargetDirectionSetter;
import com.klikli_dev.theurgy.content.render.BlockOverlays;
import com.klikli_dev.theurgy.content.render.Color;
import com.klikli_dev.theurgy.content.render.RenderTypes;
import com.klikli_dev.theurgy.content.render.cube.CubeModel;
import com.klikli_dev.theurgy.content.render.cube.CubeModelRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;

public class CycleSelectedDirectionModeRenderHandler
extends ItemModeRenderHandler<CycleSelectedDirectionMode> {
    public CycleSelectedDirectionModeRenderHandler(CycleSelectedDirectionMode mode) {
        super(mode);
    }

    @Override
    public void renderBlockHighlight(RenderHighlightEvent.Block event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        BlockHitResult rayTraceResult = event.getTarget();
        if (rayTraceResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        BlockEntity blockEntity = player.level().getBlockEntity(rayTraceResult.getBlockPos());
        if (blockEntity instanceof TargetDirectionSetter) {
            TargetDirectionSetter directionSettable = (TargetDirectionSetter)blockEntity;
            Direction currentDirection = directionSettable.targetDirection();
            Direction newDirection = ((CycleSelectedDirectionMode)this.mode).nextDirection(currentDirection);
            BlockPos targetPos = directionSettable.targetPos();
            PoseStack ps = event.getPoseStack();
            Camera camera = event.getCamera();
            MultiBufferSource bufferSource = event.getMultiBufferSource();
            Vec3 viewPosition = camera.getPosition();
            ps.pushPose();
            ps.translate((double)targetPos.getX() - viewPosition.x, (double)targetPos.getY() - viewPosition.y, (double)targetPos.getZ() - viewPosition.z);
            CubeModelRenderer.renderCube(CubeModel.getOverlayModel(newDirection, BlockOverlays.WHITE), ps, bufferSource.getBuffer(RenderTypes.translucentCullNoDepthBlockSheet()), Color.GREEN.getRGB(), 0xF000F0, OverlayTexture.NO_OVERLAY, CubeModelRenderer.FaceDisplay.FRONT, camera);
            if (currentDirection != newDirection) {
                CubeModelRenderer.renderCube(CubeModel.getOverlayModel(currentDirection, BlockOverlays.WHITE), ps, bufferSource.getBuffer(RenderTypes.translucentCullNoDepthBlockSheet()), Color.YELLOW.getRGB(), 0xF000F0, OverlayTexture.NO_OVERLAY, CubeModelRenderer.FaceDisplay.FRONT, camera);
            }
            ps.popPose();
        }
    }
}

