/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import com.klikli_dev.theurgy.content.item.filter.FilterItem;
import com.klikli_dev.theurgy.content.item.filter.ListFilterMenu;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListFilterItem
extends FilterItem {
    public ListFilterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected List<Component> makeSummary(ItemStack filter, HolderLookup.Provider provider) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!filter.has(DataComponentRegistry.FILTER_ITEMS)) {
            return list;
        }
        ItemContainerContents filterItems = (ItemContainerContents)filter.get(DataComponentRegistry.FILTER_ITEMS);
        boolean blacklist = (Boolean)filter.getOrDefault(DataComponentRegistry.FILTER_IS_DENY_LIST, (Object)false);
        list.add((Component)(blacklist ? Component.translatable((String)"theurgy.gui.filter.deny_list_button.tooltip") : Component.translatable((String)"theurgy.gui.filter.accept_list_button.tooltip")).withStyle(ChatFormatting.GOLD));
        int count = 0;
        for (int i = 0; i < filterItems.getSlots(); ++i) {
            if (count > 3) {
                list.add((Component)Component.literal((String)"- ...").withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            ItemStack filterStack = filterItems.getStackInSlot(i);
            if (filterStack.isEmpty()) continue;
            list.add((Component)Component.literal((String)"- ").append(filterStack.getHoverName()).withStyle(ChatFormatting.GRAY));
            ++count;
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        return list;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return ListFilterMenu.create(pContainerId, pPlayerInventory, pPlayer.getMainHandItem());
    }
}

