/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.gui;

import com.klikli_dev.theurgy.content.gui.ScrollInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class SelectionScrollInput
extends ScrollInput {
    private final MutableComponent scrollToSelect = Component.translatable((String)"theurgy.gui.scroll_input.scroll_to_select");
    protected List<? extends Component> options = new ArrayList<Component>();

    public SelectionScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.inverted();
    }

    public ScrollInput forOptions(List<? extends Component> options) {
        this.options = options;
        this.max = options.size();
        this.format(options::get);
        this.updateTooltip();
        return this;
    }

    @Override
    public void updateTooltip() {
        int visibleItemCount;
        int halfVisibleItemCount;
        int start;
        int end;
        MutableComponent tooltip = Component.empty();
        if (this.title != null) {
            tooltip.append((Component)this.title.plainCopy().withStyle(s -> s.withColor(5476833)));
        }
        if ((end = Math.min((start = Math.max(this.state - (halfVisibleItemCount = (visibleItemCount = 8) / 2), this.min)) + visibleItemCount, this.max)) - start > visibleItemCount) {
            start = end - visibleItemCount;
        }
        start = Math.max(start, this.min);
        end = Math.min(end, this.max);
        if (start > this.min) {
            tooltip.append("\n").append((Component)Component.literal((String)"> ...").withStyle(ChatFormatting.GRAY));
        }
        for (int i = start; i < end; ++i) {
            if (i == this.state) {
                tooltip.append("\n").append((Component)Component.empty().append("-> ").append(this.options.get(i)).withStyle(ChatFormatting.WHITE));
                continue;
            }
            tooltip.append("\n").append((Component)Component.empty().append("> ").append(this.options.get(i)).withStyle(ChatFormatting.GRAY));
        }
        if (end < this.max) {
            tooltip.append("\n").append((Component)Component.literal((String)"> ...").withStyle(ChatFormatting.GRAY));
        }
        if (this.hint != null) {
            tooltip.append("\n").append((Component)this.hint.plainCopy().withStyle(s -> s.withColor(9877472)));
        }
        tooltip.append("\n").append((Component)this.scrollToSelect.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        this.setTooltip(Tooltip.create((Component)tooltip));
    }
}

