/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.machines.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import tv.soaryn.xycraft.machines.content.registries.MachinesContent;
import tv.soaryn.xycraft.machines.datagen.MachineBlockStateDataGen;
import tv.soaryn.xycraft.machines.datagen.MachineItemModelDataGen;
import tv.soaryn.xycraft.machines.datagen.MachineItemTagDataGen;
import tv.soaryn.xycraft.machines.datagen.MachineLanguageDataGen;
import tv.soaryn.xycraft.machines.datagen.MachinesBlockLoot;
import tv.soaryn.xycraft.machines.datagen.MachinesBlockTagDataGen;
import tv.soaryn.xycraft.machines.datagen.MachinesFluidTagDataGen;
import tv.soaryn.xycraft.machines.datagen.MachinesRecipeDataGen;

@EventBusSubscriber(modid="xycraft_machines", bus=EventBusSubscriber.Bus.MOD)
public class MachineDataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(true, (DataProvider)new MachinesRecipeDataGen(output, lookup));
        if (event.includeServer()) {
            MachinesBlockTagDataGen blockTag = new MachinesBlockTagDataGen(output, lookup, "xycraft_machines", existingFileHelper);
            generator.addProvider(true, (DataProvider)blockTag);
            generator.addProvider(true, (DataProvider)new MachinesFluidTagDataGen(output, lookup, "xycraft_machines", existingFileHelper));
            generator.addProvider(true, (DataProvider)new MachineItemTagDataGen(output, lookup, blockTag.contentsGetter(), "xycraft_machines", existingFileHelper));
            generator.addProvider(true, (DataProvider)MachinesBlockLoot.supplier(output, lookup));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new MachineLanguageDataGen(output, "xycraft_machines", "en_us"));
            generator.addProvider(true, (DataProvider)new MachineLanguageDataGen(output, "xycraft_machines", "lol_us"));
            generator.addProvider(true, (DataProvider)new MachineBlockStateDataGen(output, MachinesContent.Map, "xycraft_machines", existingFileHelper));
            generator.addProvider(true, (DataProvider)new MachineItemModelDataGen(output, "xycraft_machines", existingFileHelper));
        }
    }
}

